/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class SessionIdAccessMap
implements Serializable {
    @XmlElement(name="map")
    private Map<String, Boolean> permissionGranted;

    public SessionIdAccessMap() {
    }

    public SessionIdAccessMap(Map<String, Boolean> permissionGranted) {
        this.permissionGranted = permissionGranted;
    }

    public Map<String, Boolean> getPermissionGranted() {
        this.ensureInitialized();
        return this.permissionGranted;
    }

    public void setPermissionGranted(Map<String, Boolean> permissionGranted) {
        this.permissionGranted = permissionGranted;
    }

    @XmlTransient
    public Set<String> clientIds() {
        return Sets.newHashSet(this.getPermissionGranted().keySet());
    }

    public Set<String> getClientIds(boolean granted) {
        HashSet clientIds = Sets.newHashSet();
        for (Map.Entry<String, Boolean> entry : this.getPermissionGranted().entrySet()) {
            if (!entry.getValue().equals(granted)) continue;
            clientIds.add(entry.getKey());
        }
        return clientIds;
    }

    public Boolean get(String clientId) {
        Boolean result = this.getPermissionGranted().get(clientId);
        return result != null ? result : false;
    }

    private void ensureInitialized() {
        if (this.permissionGranted == null) {
            this.permissionGranted = new HashMap<String, Boolean>();
        }
    }

    public void put(String clientId, Boolean granted) {
        this.getPermissionGranted().put(clientId, granted);
    }

    public void putIfAbsent(String clientId) {
        this.ensureInitialized();
        if (this.permissionGranted.get(clientId) == null) {
            this.permissionGranted.put(clientId, false);
        }
    }
}

