/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.persistence.Transient;
import org.gluu.oxauth.model.common.SessionIdAccessMap;
import org.gluu.oxauth.model.common.SessionIdState;
import org.gluu.oxauth.model.common.User;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DN;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.JsonObject;
import org.gluu.persist.annotation.ObjectClass;

@Named(value="sessionUser")
@DataEntry
@ObjectClass(value="oxAuthSessionId")
public class SessionId
implements Serializable {
    private static final long serialVersionUID = -237476411915686378L;
    @DN
    private String dn;
    @AttributeName(name="oxAuthSessionId")
    private String id;
    @AttributeName(name="oxLastAccessTime")
    private Date lastUsedAt;
    @AttributeName(name="oxAuthUserDN")
    private String userDn;
    @AttributeName(name="authnTime")
    private Date authenticationTime;
    @AttributeName(name="oxState")
    private SessionIdState state;
    @AttributeName(name="oxAuthSessionState")
    private String sessionState;
    @AttributeName(name="oxAuthPermissionGranted")
    private Boolean permissionGranted;
    @AttributeName(name="oxAsJwt")
    private Boolean isJwt = false;
    @AttributeName(name="oxJwt")
    private String jwt;
    @JsonObject
    @AttributeName(name="oxAuthPermissionGrantedMap")
    private SessionIdAccessMap permissionGrantedMap;
    @JsonObject
    @AttributeName(name="oxInvolvedClients")
    private SessionIdAccessMap involvedClients;
    @JsonObject
    @AttributeName(name="oxAuthSessionAttribute")
    private Map<String, String> sessionAttributes;
    @Transient
    private transient boolean persisted;
    @Transient
    private User user;

    public String getDn() {
        return this.dn;
    }

    public void setDn(String p_dn) {
        this.dn = p_dn;
    }

    public String getJwt() {
        return this.jwt;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public Boolean getIsJwt() {
        return this.isJwt;
    }

    public void setIsJwt(Boolean isJwt) {
        this.isJwt = isJwt;
    }

    public SessionIdAccessMap getInvolvedClients() {
        if (this.involvedClients == null) {
            this.involvedClients = new SessionIdAccessMap();
        }
        return this.involvedClients;
    }

    public void setInvolvedClients(SessionIdAccessMap involvedClients) {
        this.involvedClients = involvedClients;
    }

    public SessionIdState getState() {
        return this.state;
    }

    public void setState(SessionIdState state) {
        this.state = state;
    }

    public String getSessionState() {
        return this.sessionState;
    }

    public void setSessionState(String sessionState) {
        this.sessionState = sessionState;
    }

    public String getOPBrowserState() {
        return this.sessionAttributes.get("opbs");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String p_id) {
        this.id = p_id;
    }

    public Date getLastUsedAt() {
        return this.lastUsedAt;
    }

    public void setLastUsedAt(Date p_lastUsedAt) {
        this.lastUsedAt = p_lastUsedAt;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String p_userDn) {
        this.userDn = p_userDn != null ? p_userDn : "";
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Date getAuthenticationTime() {
        return this.authenticationTime;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime;
    }

    public Boolean getPermissionGranted() {
        return this.permissionGranted;
    }

    public void setPermissionGranted(Boolean permissionGranted) {
        this.permissionGranted = permissionGranted;
    }

    public SessionIdAccessMap getPermissionGrantedMap() {
        if (this.permissionGrantedMap == null) {
            this.permissionGrantedMap = new SessionIdAccessMap();
        }
        return this.permissionGrantedMap;
    }

    public void setPermissionGrantedMap(SessionIdAccessMap permissionGrantedMap) {
        this.permissionGrantedMap = permissionGrantedMap;
    }

    public Boolean isPermissionGrantedForClient(String clientId) {
        return this.permissionGrantedMap != null && this.permissionGrantedMap.get(clientId) != false;
    }

    public void addPermission(String clientId, Boolean granted) {
        if (this.permissionGrantedMap == null) {
            this.permissionGrantedMap = new SessionIdAccessMap();
        }
        this.permissionGrantedMap.put(clientId, granted);
    }

    @Nonnull
    public Map<String, String> getSessionAttributes() {
        if (this.sessionAttributes == null) {
            this.sessionAttributes = Maps.newHashMap();
        }
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionId id1 = (SessionId)o;
        return !(this.id == null ? id1.id != null : !this.id.equals(id1.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionState {");
        sb.append("dn='").append(this.dn).append('\'');
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", lastUsedAt=").append(this.lastUsedAt);
        sb.append(", userDn='").append(this.userDn).append('\'');
        sb.append(", authenticationTime=").append(this.authenticationTime);
        sb.append(", state=").append((Object)this.state);
        sb.append(", sessionState='").append(this.sessionState).append('\'');
        sb.append(", permissionGranted=").append(this.permissionGranted);
        sb.append(", isJwt=").append(this.isJwt);
        sb.append(", jwt=").append(this.jwt);
        sb.append(", permissionGrantedMap=").append(this.permissionGrantedMap);
        sb.append(", involvedClients=").append(this.involvedClients);
        sb.append(", sessionAttributes=").append(this.sessionAttributes);
        sb.append(", persisted=").append(this.persisted);
        sb.append("}");
        return sb.toString();
    }
}

