/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantType;
import org.gluu.oxauth.model.common.CIBAAuthenticationRequestId;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.registration.Client;

public class CIBAGrant
extends AuthorizationGrant {
    private CIBAAuthenticationRequestId cibaAuthenticationRequestId;
    private String clientNotificationToken;
    private String bindingMessage;
    private Long lastAccessControl;
    private boolean userAuthorization;
    private boolean tokensDelivered;

    public void init(User user, Client client, int expiresIn) {
        super.init(user, AuthorizationGrantType.CIBA, client, null);
        this.setCIBAAuthenticationRequestId(new CIBAAuthenticationRequestId(expiresIn));
        this.setIsCachedWithNoPersistence(true);
    }

    public CIBAAuthenticationRequestId getCIBAAuthenticationRequestId() {
        return this.cibaAuthenticationRequestId;
    }

    public void setCIBAAuthenticationRequestId(CIBAAuthenticationRequestId cibaAuthenticationRequestId) {
        this.cibaAuthenticationRequestId = cibaAuthenticationRequestId;
    }

    public String getClientNotificationToken() {
        return this.clientNotificationToken;
    }

    public void setClientNotificationToken(String clientNotificationToken) {
        this.clientNotificationToken = clientNotificationToken;
    }

    public String getBindingMessage() {
        return this.bindingMessage;
    }

    public void setBindingMessage(String bindingMessage) {
        this.bindingMessage = bindingMessage;
    }

    public Long getLastAccessControl() {
        return this.lastAccessControl;
    }

    public void setLastAccessControl(Long lastAccessControl) {
        this.lastAccessControl = lastAccessControl;
    }

    public boolean isUserAuthorization() {
        return this.userAuthorization;
    }

    public void setUserAuthorization(boolean userAuthorization) {
        this.userAuthorization = userAuthorization;
    }

    public boolean isTokensDelivered() {
        return this.tokensDelivered;
    }

    public void setTokensDelivered(boolean tokensDelivered) {
        this.tokensDelivered = tokensDelivered;
    }
}

