/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.Instance;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.AbstractAuthorizationGrant;
import org.gluu.oxauth.model.common.CIBAAuthenticationRequestId;
import org.gluu.oxauth.model.common.CIBAGrant;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.registration.Client;

public class CIBACacheGrant
implements Serializable {
    private String authorizationRequestId;
    private User user;
    private Client client;
    private Set<String> scopes;
    private String grantId;
    private String sessionDn;
    private int expiresIn = 1;
    private String clientNotificationToken;
    private String bindingMessage;
    private Long lastAccessControl;
    private boolean userAuthorization;
    private boolean tokensDelivered;

    public CIBACacheGrant() {
    }

    public CIBACacheGrant(CIBAGrant grant, AppConfiguration appConfiguration) {
        if (grant.getCIBAAuthenticationRequestId() != null) {
            this.authorizationRequestId = grant.getCIBAAuthenticationRequestId().getCode();
        }
        this.initExpiresIn(grant, appConfiguration);
        this.user = grant.getUser();
        this.client = grant.getClient();
        this.scopes = grant.getScopes();
        this.grantId = grant.getGrantId();
        this.sessionDn = grant.getSessionDn();
        this.clientNotificationToken = grant.getClientNotificationToken();
        this.bindingMessage = grant.getBindingMessage();
        this.lastAccessControl = grant.getLastAccessControl();
        this.userAuthorization = grant.isUserAuthorization();
        this.tokensDelivered = grant.isTokensDelivered();
    }

    private void initExpiresIn(CIBAGrant grant, AppConfiguration appConfiguration) {
        this.expiresIn = grant.getCIBAAuthenticationRequestId() != null ? grant.getCIBAAuthenticationRequestId().getExpiresIn() : appConfiguration.getBackchannelAuthenticationResponseExpiresIn();
    }

    public CIBAGrant asCIBAGrant(Instance<AbstractAuthorizationGrant> grantInstance) {
        CIBAGrant grant = (CIBAGrant)grantInstance.select(CIBAGrant.class, new Annotation[0]).get();
        grant.init(this.user, this.client, this.expiresIn);
        grant.setCIBAAuthenticationRequestId(new CIBAAuthenticationRequestId(this.expiresIn));
        grant.getCIBAAuthenticationRequestId().setCode(this.authorizationRequestId);
        grant.setScopes(this.scopes);
        grant.setGrantId(this.grantId);
        grant.setSessionDn(this.sessionDn);
        grant.setClientNotificationToken(this.clientNotificationToken);
        grant.setBindingMessage(this.bindingMessage);
        grant.setLastAccessControl(this.lastAccessControl);
        grant.setUserAuthorization(this.userAuthorization);
        grant.setTokensDelivered(this.tokensDelivered);
        return grant;
    }

    public String cacheKey() {
        return CIBACacheGrant.cacheKey(this.authorizationRequestId, this.grantId);
    }

    public static String cacheKey(String authorizationRequestId, String grantId) {
        if (StringUtils.isBlank((String)authorizationRequestId)) {
            return grantId;
        }
        return authorizationRequestId;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }
}

