/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.token.HandleTokenFactory;
import org.gluu.oxauth.model.util.HashUtil;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.model.base.Deletable;

public abstract class AbstractToken
implements Serializable,
Deletable {
    @AttributeName(name="tknCde", consistency=true)
    private String code;
    @AttributeName(name="iat")
    private Date creationDate;
    @AttributeName(name="exp")
    private Date expirationDate;
    @AttributeName(name="del")
    private boolean deletable = true;
    private boolean revoked;
    private boolean expired;
    @AttributeName(name="amr")
    private String authMode;
    @AttributeName(name="ssnId")
    private String sessionDn;
    private String x5ts256;

    public AbstractToken(int lifeTime) {
        if (lifeTime <= 0) {
            throw new IllegalArgumentException("Lifetime of the token is less or equal to zero.");
        }
        Calendar calendar = Calendar.getInstance();
        this.creationDate = calendar.getTime();
        calendar.add(13, lifeTime);
        this.expirationDate = calendar.getTime();
        this.code = HandleTokenFactory.generateHandleToken();
        this.revoked = false;
        this.expired = false;
    }

    protected AbstractToken(String code, Date creationDate, Date expirationDate) {
        this.code = code;
        this.creationDate = creationDate;
        this.expirationDate = expirationDate;
        this.checkExpired();
    }

    public void checkExpired() {
        this.checkExpired(new Date());
    }

    public void checkExpired(Date now) {
        if (now.after(this.expirationDate)) {
            this.expired = true;
        }
    }

    public boolean isValid() {
        return !this.revoked && !this.expired;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Date getCreationDate() {
        return this.creationDate != null ? new Date(this.creationDate.getTime()) : null;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate != null ? new Date(creationDate.getTime()) : null;
    }

    public Date getExpirationDate() {
        return this.expirationDate != null ? new Date(this.expirationDate.getTime()) : null;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate != null ? new Date(expirationDate.getTime()) : null;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public synchronized void setRevoked(boolean revoked) {
        this.revoked = revoked;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public synchronized void setExpired(boolean expired) {
        this.expired = expired;
    }

    public String getAuthMode() {
        return this.authMode;
    }

    public void setAuthMode(String authMode) {
        this.authMode = authMode;
    }

    public String getX5ts256() {
        return this.x5ts256;
    }

    public void setX5ts256(String x5ts256) {
        this.x5ts256 = x5ts256;
    }

    public String getSessionDn() {
        return this.sessionDn;
    }

    public void setSessionDn(String sessionDn) {
        this.sessionDn = sessionDn;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public int getExpiresIn() {
        int expiresIn = 0;
        this.checkExpired();
        if (this.isValid()) {
            long diff = this.expirationDate.getTime() - new Date().getTime();
            expiresIn = diff != 0L ? (int)(diff / 1000L) : 0;
        }
        return expiresIn;
    }

    public static String getHash(String input, SignatureAlgorithm signatureAlgorithm) {
        return HashUtil.getHash((String)input, (SignatureAlgorithm)signatureAlgorithm);
    }
}

