/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.authorize;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.ScopeService;
import org.gluu.oxauth.service.SpontaneousScopeService;
import org.gluu.oxauth.service.external.ExternalSpontaneousScopeService;
import org.gluu.oxauth.service.external.context.SpontaneousScopeExternalContext;
import org.slf4j.Logger;

@Stateless
@Named(value="scopeChecker")
public class ScopeChecker {
    @Inject
    private Logger log;
    @Inject
    private ScopeService scopeService;
    @Inject
    private SpontaneousScopeService spontaneousScopeService;
    @Inject
    private ExternalSpontaneousScopeService externalSpontaneousScopeService;

    public Set<String> checkScopesPolicy(Client client, String scope) {
        this.log.debug("Checking scopes policy for: " + scope);
        HashSet<String> grantedScopes = new HashSet<String>();
        if (scope == null || client == null) {
            return grantedScopes;
        }
        String[] scopesRequested = scope.split(" ");
        String[] scopesAllowed = client.getScopes() != null ? client.getScopes() : new String[]{};
        for (String scopeRequested : scopesRequested) {
            if (StringUtils.isBlank((String)scopeRequested)) continue;
            List<String> scopesAllowedIds = this.scopeService.getScopeIdsByDns(Arrays.asList(scopesAllowed));
            if (scopesAllowedIds.contains(scopeRequested)) {
                grantedScopes.add(scopeRequested);
                continue;
            }
            if (this.spontaneousScopeService.isAllowedBySpontaneousScopes(client, scopeRequested)) {
                grantedScopes.add(scopeRequested);
                this.spontaneousScopeService.createSpontaneousScopeIfNeeded(scopeRequested);
            }
            SpontaneousScopeExternalContext context = new SpontaneousScopeExternalContext(client, scopeRequested, scopesAllowedIds, this.spontaneousScopeService);
            this.externalSpontaneousScopeService.executeExternalManipulateScope(context);
        }
        this.log.debug("Granted scopes: " + grantedScopes);
        return grantedScopes;
    }
}

