/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.authorize;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import org.gluu.oxauth.model.authorize.IdTokenMember;
import org.gluu.oxauth.model.authorize.UserInfoMember;
import org.gluu.oxauth.model.common.Display;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.exception.InvalidJweException;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.jwe.Jwe;
import org.gluu.oxauth.model.jwe.JweDecrypterImpl;
import org.gluu.oxauth.model.jwt.JwtHeader;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.util.Base64Util;
import org.gluu.oxauth.model.util.JwtUtil;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.service.ClientService;
import org.gluu.service.cdi.util.CdiUtil;
import org.gluu.util.security.StringEncrypter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JwtAuthorizationRequest {
    private String type;
    private String algorithm;
    private String encryptionAlgorithm;
    private String keyId;
    private List<ResponseType> responseTypes;
    private String clientId;
    private List<String> scopes;
    private String redirectUri;
    private String nonce;
    private String state;
    private Display display;
    private List<Prompt> prompts;
    private UserInfoMember userInfoMember;
    private IdTokenMember idTokenMember;
    private String encodedJwt;
    private AppConfiguration appConfiguration;

    public JwtAuthorizationRequest(AppConfiguration appConfiguration, AbstractCryptoProvider cryptoProvider, String encodedJwt, Client client) throws InvalidJwtException, InvalidJweException {
        block36: {
            try {
                this.appConfiguration = appConfiguration;
                this.responseTypes = new ArrayList<ResponseType>();
                this.scopes = new ArrayList<String>();
                this.prompts = new ArrayList<Prompt>();
                this.encodedJwt = encodedJwt;
                if (encodedJwt != null && !encodedJwt.isEmpty()) {
                    String[] parts = encodedJwt.split("\\.");
                    if (parts.length == 5) {
                        String encodedHeader = parts[0];
                        String encodedEncryptedKey = parts[1];
                        String encodedInitializationVector = parts[2];
                        String encodedCipherText = parts[3];
                        String encodedIntegrityValue = parts[4];
                        JwtHeader jwtHeader = new JwtHeader(encodedHeader);
                        this.keyId = jwtHeader.getKeyId();
                        KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)jwtHeader.getClaimAsString("alg"));
                        BlockEncryptionAlgorithm blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName((String)jwtHeader.getClaimAsString("enc"));
                        JweDecrypterImpl jweDecrypter = null;
                        if ("RSA".equals(keyEncryptionAlgorithm.getFamily())) {
                            PrivateKey privateKey = cryptoProvider.getPrivateKey(this.keyId);
                            jweDecrypter = new JweDecrypterImpl(privateKey);
                        } else {
                            ClientService clientService = (ClientService)CdiUtil.bean(ClientService.class);
                            jweDecrypter = new JweDecrypterImpl(clientService.decryptSecret(client.getClientSecret()).getBytes("UTF-8"));
                        }
                        jweDecrypter.setKeyEncryptionAlgorithm(keyEncryptionAlgorithm);
                        jweDecrypter.setBlockEncryptionAlgorithm(blockEncryptionAlgorithm);
                        Jwe jwe = jweDecrypter.decrypt(encodedJwt);
                        this.loadHeader(jwe.getHeader().toJsonString());
                        this.loadPayload(jwe.getClaims().toJsonString());
                        break block36;
                    }
                    if (parts.length == 2 || parts.length == 3) {
                        SignatureAlgorithm sigAlg;
                        String encodedHeader = parts[0];
                        String encodedClaim = parts[1];
                        String encodedSignature = "";
                        if (parts.length == 3) {
                            encodedSignature = parts[2];
                        }
                        String signingInput = encodedHeader + "." + encodedClaim;
                        String header = new String(Base64Util.base64urldecode((String)encodedHeader), "UTF-8");
                        String payload = new String(Base64Util.base64urldecode((String)encodedClaim), "UTF-8");
                        payload = payload.replace("\\", "");
                        JSONObject jsonHeader = new JSONObject(header);
                        if (jsonHeader.has("typ")) {
                            this.type = jsonHeader.getString("typ");
                        }
                        if (jsonHeader.has("alg")) {
                            this.algorithm = jsonHeader.getString("alg");
                        }
                        if (jsonHeader.has("kid")) {
                            this.keyId = jsonHeader.getString("kid");
                        }
                        if ((sigAlg = SignatureAlgorithm.fromString((String)this.algorithm)) != null) {
                            if (this.validateSignature(cryptoProvider, sigAlg, client, signingInput, encodedSignature)) {
                                int i;
                                JSONObject jsonPayload = new JSONObject(payload);
                                if (jsonPayload.has("response_type")) {
                                    JSONArray responseTypeJsonArray = jsonPayload.optJSONArray("response_type");
                                    if (responseTypeJsonArray != null) {
                                        for (i = 0; i < responseTypeJsonArray.length(); ++i) {
                                            ResponseType responseType = ResponseType.fromString((String)responseTypeJsonArray.getString(i));
                                            this.responseTypes.add(responseType);
                                        }
                                    } else {
                                        this.responseTypes.addAll(ResponseType.fromString((String)jsonPayload.getString("response_type"), (String)" "));
                                    }
                                }
                                if (jsonPayload.has("client_id")) {
                                    this.clientId = jsonPayload.getString("client_id");
                                }
                                if (jsonPayload.has("scope")) {
                                    JSONArray scopesJsonArray = jsonPayload.optJSONArray("scope");
                                    if (scopesJsonArray != null) {
                                        for (i = 0; i < scopesJsonArray.length(); ++i) {
                                            String scope = scopesJsonArray.getString(i);
                                            this.scopes.add(scope);
                                        }
                                    } else {
                                        String scopeStringList = jsonPayload.getString("scope");
                                        this.scopes.addAll(Util.splittedStringAsList((String)scopeStringList, (String)" "));
                                    }
                                }
                                if (jsonPayload.has("redirect_uri")) {
                                    this.redirectUri = URLDecoder.decode(jsonPayload.getString("redirect_uri"), "UTF-8");
                                }
                                if (jsonPayload.has("nonce")) {
                                    this.nonce = jsonPayload.getString("nonce");
                                }
                                if (jsonPayload.has("state")) {
                                    this.state = jsonPayload.getString("state");
                                }
                                if (jsonPayload.has("display")) {
                                    this.display = Display.fromString((String)jsonPayload.getString("display"));
                                }
                                if (jsonPayload.has("prompt")) {
                                    JSONArray promptJsonArray = jsonPayload.optJSONArray("prompt");
                                    if (promptJsonArray != null) {
                                        for (int i2 = 0; i2 < promptJsonArray.length(); ++i2) {
                                            Prompt prompt = Prompt.fromString((String)promptJsonArray.getString(i2));
                                            this.prompts.add(prompt);
                                        }
                                    } else {
                                        this.prompts.addAll(Prompt.fromString((String)jsonPayload.getString("prompt"), (String)" "));
                                    }
                                }
                                if (jsonPayload.has("claims")) {
                                    JSONObject claimsJsonObject = jsonPayload.getJSONObject("claims");
                                    if (claimsJsonObject.has("userinfo")) {
                                        this.userInfoMember = new UserInfoMember(claimsJsonObject.getJSONObject("userinfo"));
                                    }
                                    if (claimsJsonObject.has("id_token")) {
                                        this.idTokenMember = new IdTokenMember(claimsJsonObject.getJSONObject("id_token"));
                                    }
                                }
                                break block36;
                            }
                            throw new InvalidJwtException("The JWT signature is not valid");
                        }
                        throw new InvalidJwtException("The JWT algorithm is not supported");
                    }
                    throw new InvalidJwtException("The JWT is not well formed");
                }
                throw new InvalidJwtException("The JWT is null or empty");
            }
            catch (JSONException e) {
                throw new InvalidJwtException((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidJwtException((Throwable)e);
            }
            catch (StringEncrypter.EncryptionException e) {
                throw new InvalidJwtException((Throwable)e);
            }
            catch (Exception e) {
                throw new InvalidJwtException((Throwable)e);
            }
        }
    }

    public String getEncodedJwt() {
        return this.encodedJwt;
    }

    private void loadHeader(String header) throws JSONException {
        JSONObject jsonHeader = new JSONObject(header);
        if (jsonHeader.has("typ")) {
            this.type = jsonHeader.getString("typ");
        }
        if (jsonHeader.has("alg")) {
            this.algorithm = jsonHeader.getString("alg");
        }
        if (jsonHeader.has("enc")) {
            this.encryptionAlgorithm = jsonHeader.getString("enc");
        }
        if (jsonHeader.has("kid")) {
            this.keyId = jsonHeader.getString("kid");
        }
    }

    private void loadPayload(String payload) throws JSONException, UnsupportedEncodingException {
        int i;
        JSONObject jsonPayload = new JSONObject(payload);
        if (jsonPayload.has("response_type")) {
            JSONArray responseTypeJsonArray = jsonPayload.optJSONArray("response_type");
            if (responseTypeJsonArray != null) {
                for (i = 0; i < responseTypeJsonArray.length(); ++i) {
                    ResponseType responseType = ResponseType.fromString((String)responseTypeJsonArray.getString(i));
                    this.responseTypes.add(responseType);
                }
            } else {
                this.responseTypes.addAll(ResponseType.fromString((String)jsonPayload.getString("response_type"), (String)" "));
            }
        }
        if (jsonPayload.has("client_id")) {
            this.clientId = jsonPayload.getString("client_id");
        }
        if (jsonPayload.has("scope")) {
            JSONArray scopesJsonArray = jsonPayload.optJSONArray("scope");
            if (scopesJsonArray != null) {
                for (i = 0; i < scopesJsonArray.length(); ++i) {
                    String scope = scopesJsonArray.getString(i);
                    this.scopes.add(scope);
                }
            } else {
                String scopeStringList = jsonPayload.getString("scope");
                this.scopes.addAll(Util.splittedStringAsList((String)scopeStringList, (String)" "));
            }
        }
        if (jsonPayload.has("redirect_uri")) {
            this.redirectUri = URLDecoder.decode(jsonPayload.getString("redirect_uri"), "UTF-8");
        }
        if (jsonPayload.has("nonce")) {
            this.nonce = jsonPayload.getString("nonce");
        }
        if (jsonPayload.has("state")) {
            this.state = jsonPayload.getString("state");
        }
        if (jsonPayload.has("display")) {
            this.display = Display.fromString((String)jsonPayload.getString("display"));
        }
        if (jsonPayload.has("prompt")) {
            JSONArray promptJsonArray = jsonPayload.optJSONArray("prompt");
            if (promptJsonArray != null) {
                for (int i2 = 0; i2 < promptJsonArray.length(); ++i2) {
                    Prompt prompt = Prompt.fromString((String)promptJsonArray.getString(i2));
                    this.prompts.add(prompt);
                }
            } else {
                this.prompts.addAll(Prompt.fromString((String)jsonPayload.getString("prompt"), (String)" "));
            }
        }
        if (jsonPayload.has("claims")) {
            JSONObject claimsJsonObject = jsonPayload.getJSONObject("claims");
            if (claimsJsonObject.has("userinfo")) {
                this.userInfoMember = new UserInfoMember(claimsJsonObject.getJSONObject("userinfo"));
            }
            if (claimsJsonObject.has("id_token")) {
                this.idTokenMember = new IdTokenMember(claimsJsonObject.getJSONObject("id_token"));
            }
        }
    }

    private boolean validateSignature(AbstractCryptoProvider cryptoProvider, SignatureAlgorithm signatureAlgorithm, Client client, String signingInput, String signature) throws Exception {
        ClientService clientService = (ClientService)CdiUtil.bean(ClientService.class);
        String sharedSecret = clientService.decryptSecret(client.getClientSecret());
        JSONObject jwks = Strings.isNullOrEmpty((String)client.getJwks()) ? JwtUtil.getJSONWebKeys((String)client.getJwksUri()) : new JSONObject(client.getJwks());
        boolean validSignature = cryptoProvider.verifySignature(signingInput, signature, this.keyId, jwks, sharedSecret, signatureAlgorithm);
        return validSignature;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public List<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public List<Prompt> getPrompts() {
        return this.prompts;
    }

    public void setPrompts(List<Prompt> prompts) {
        this.prompts = prompts;
    }

    public UserInfoMember getUserInfoMember() {
        return this.userInfoMember;
    }

    public void setUserInfoMember(UserInfoMember userInfoMember) {
        this.userInfoMember = userInfoMember;
    }

    public IdTokenMember getIdTokenMember() {
        return this.idTokenMember;
    }

    public void setIdTokenMember(IdTokenMember idTokenMember) {
        this.idTokenMember = idTokenMember;
    }
}

