/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.idgen.ws.rs;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.idgen.ws.rs.InumGenerator;
import org.gluu.oxauth.model.common.IdType;
import org.gluu.oxauth.service.api.IdGenerator;
import org.gluu.oxauth.service.external.ExternalIdGeneratorService;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Stateless
@Named(value="idGenService")
public class IdGenService
implements IdGenerator {
    @Inject
    private Logger log;
    @Inject
    private InumGenerator inumGenerator;
    @Inject
    private ExternalIdGeneratorService externalIdGeneratorService;

    public String generateId(IdType p_idType, String p_idPrefix) {
        return this.generateId(p_idType.getType(), p_idPrefix);
    }

    public String generateId(String p_idType, String p_idPrefix) {
        String generatedId;
        if (this.externalIdGeneratorService.isEnabled() && StringHelper.isNotEmpty((String)(generatedId = this.externalIdGeneratorService.executeExternalDefaultGenerateIdMethod("oxauth", p_idType, p_idPrefix)))) {
            return generatedId;
        }
        return this.inumGenerator.generateId(p_idType, p_idPrefix);
    }
}

