/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.bcauthorize.ws.rs;

import com.wordnik.swagger.annotations.Api;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.gluu.oxauth.audit.ApplicationAuditLogger;
import org.gluu.oxauth.bcauthorize.ws.rs.BackchannelDeviceRegistrationRestWebService;
import org.gluu.oxauth.ciba.CIBADeviceRegistrationValidatorProxy;
import org.gluu.oxauth.ciba.CIBASupportProxy;
import org.gluu.oxauth.model.audit.Action;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.ciba.BackchannelAuthenticationErrorResponseType;
import org.gluu.oxauth.model.ciba.BackchannelDeviceRegistrationErrorResponseType;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.DefaultErrorResponse;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.service.UserService;
import org.gluu.oxauth.util.ServerUtil;
import org.slf4j.Logger;

@Path(value="/")
@Api(value="/oxauth/bc-deviceRegistration", description="Backchannel Device Registration Endpoint")
public class BackchannelDeviceRegistrationRestWebServiceImpl
implements BackchannelDeviceRegistrationRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UserService userService;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private CIBASupportProxy cibaSupportProxy;
    @Inject
    private CIBADeviceRegistrationValidatorProxy cibaDeviceRegistrationValidatorProxy;

    @Override
    public Response requestBackchannelDeviceRegistrationPost(String idTokenHint, String deviceRegistrationToken, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.BACKCHANNEL_DEVICE_REGISTRATION);
        this.log.debug("Attempting to request backchannel device registration: idTokenHint = {}, deviceRegistrationToken = {}, isSecure = {}", new Object[]{idTokenHint, deviceRegistrationToken, securityContext.isSecure()});
        Response.ResponseBuilder builder = Response.ok();
        if (!this.cibaSupportProxy.isCIBASupported()) {
            builder = Response.status((int)Response.Status.FORBIDDEN.getStatusCode());
            builder.entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)BackchannelDeviceRegistrationErrorResponseType.ACCESS_DENIED, "The CIBA (Client Initiated Backchannel Authentication) is not enabled in the server."));
            return builder.build();
        }
        DefaultErrorResponse cibaDeviceRegistrationValidation = this.cibaDeviceRegistrationValidatorProxy.validateParams(idTokenHint, deviceRegistrationToken);
        if (cibaDeviceRegistrationValidation != null) {
            builder = Response.status((int)cibaDeviceRegistrationValidation.getStatus());
            builder.entity((Object)this.errorResponseFactory.errorAsJson(cibaDeviceRegistrationValidation.getType(), cibaDeviceRegistrationValidation.getReason()));
            return builder.build();
        }
        User user = null;
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(idTokenHint);
        if (authorizationGrant == null) {
            builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.UNKNOWN_USER_ID));
            return builder.build();
        }
        user = authorizationGrant.getUser();
        if (user == null) {
            builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelDeviceRegistrationErrorResponseType.UNKNOWN_USER_ID));
            return builder.build();
        }
        this.userService.setCustomAttribute(user, "oxAuthBackchannelDeviceRegistrationToken", deviceRegistrationToken);
        this.userService.updateUser(user);
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }
}

