/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.bcauthorize.ws.rs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Api(value="/", description="The Backchannel Authentication Endpoint is used to initiate an out-of-band authentication of the end-user.")
public interface BackchannelAuthorizeRestWebService {
    @POST
    @Path(value="/bc-authorize")
    @Produces(value={"application/json"})
    @ApiOperation(value="Performs backchannel authorization.", notes="The Backchannel Authentication Endpoint is used to initiate an out-of-band authentication of the end-user.", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=400, message="invalid_request\n    The request is missing a required parameter, includes an invalid parameter value, includes a parameter more than once, contains more than one of the hints, or is otherwise malformed."), @ApiResponse(code=400, message="invalid_scope\n    The requested scope is invalid, unknown, or malformed."), @ApiResponse(code=400, message="expired_login_hint_token\n    The login_hint_token provided in the authentication request is not valid because it has expired."), @ApiResponse(code=400, message="unknown_user_id\n    The OpenID Provider is not able to identify which end-user the Client wishes to be authenticated by means of the hint provided in the request (login_hint_token, id_token_hint or login_hint)."), @ApiResponse(code=400, message="unauthorized_client\n    The Client is not authorized to use this authentication flow."), @ApiResponse(code=400, message="missing_user_code\n    User code is required but was missing from the request."), @ApiResponse(code=400, message="invalid_user_code\n    User code was invalid."), @ApiResponse(code=400, message="invalid_binding_message\n    The binding message is invalid or unacceptable for use in the context of the given request."), @ApiResponse(code=401, message="invalid_client\n    Client authentication failed (e.g., invalid client credentials, unknown client, no client authentication included, or unsupported authentication method)."), @ApiResponse(code=403, message="access_denied\n    The resource owner or OpenID Provider denied the CIBA (Client Initiated Backchannel Authentication) request.")})
    public Response requestBackchannelAuthorizationPost(@FormParam(value="client_id") @ApiParam(value="OAuth 2.0 Client Identifier valid at the Authorization Server. ", required=true) String var1, @FormParam(value="scope") @ApiParam(value="CIBA authentication requests must contain the openid scope value.", required=true) String var2, @FormParam(value="client_notification_token") @ApiParam(value="It is a bearer token provided by the Client that will be used by the OpenID Provider to authenticate the callback request to the Client. It is required if the Client is registered to use Ping or Push modes.", required=true) String var3, @FormParam(value="acr_values") @ApiParam(value="Requested Authentication Context Class Reference values.", required=false) String var4, @FormParam(value="login_hint_token") @ApiParam(value="A token containing information identifying the end-user for whom authentication is being requested.", required=false) String var5, @FormParam(value="id_token_hint") @ApiParam(value="An ID Token previously issued to the Client by the OpenID Provider being passed back as a hint to identify the end-user for whom authentication is being requested.", required=false) String var6, @FormParam(value="login_hint") @ApiParam(value="A hint to the OpenID Provider regarding the end-user for whom authentication is being requested.", required=false) String var7, @FormParam(value="binding_message") @ApiParam(value="A human readable identifier or message intended to be displayed on both the consumption device and the authentication device to interlock them together for the transaction by way of a visual cue for the end-user.", required=false) String var8, @FormParam(value="user_code") @ApiParam(value="A secret code, such as password or pin, known only to the user but verifiable by the OP.", required=false) String var9, @FormParam(value="requested_expiry") @ApiParam(value="A positive integer allowing the client to request the expires_in value for the auth_req_id the server will return.", required=false) Integer var10, @Context HttpServletRequest var11, @Context HttpServletResponse var12, @Context SecurityContext var13);
}

