/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.authorize.ws.rs;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.jsf2.service.FacesService;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.oxauth.i18n.LanguageBean;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.util.Base64Util;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.external.ExternalAuthenticationService;
import org.gluu.service.JsonService;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@RequestScoped
@Named
public class LogoutAction {
    private static final String EXTERNAL_LOGOUT = "external_logout";
    private static final String EXTERNAL_LOGOUT_DATA = "external_logout_data";
    @Inject
    private Logger log;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private JsonService jsonService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private FacesService facesService;
    @Inject
    private FacesContext facesContext;
    @Inject
    private LanguageBean languageBean;
    private String idTokenHint;
    private String postLogoutRedirectUri;
    private SessionId sessionId;

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public void redirect() {
        ExternalLogoutResult externalLogoutResult;
        SessionId sessionId = this.sessionIdService.getSessionId();
        boolean validationResult = this.validateParameters();
        if (!validationResult) {
            try {
                this.restoreLogoutParametersFromSession(sessionId);
            }
            catch (IOException ex) {
                this.logoutFailed();
                this.log.debug("Failed to restore logout parameters from session", (Throwable)ex);
            }
            validationResult = this.validateParameters();
            if (!validationResult) {
                this.missingLogoutParameters();
                return;
            }
        }
        if (ExternalLogoutResult.FAILURE == (externalLogoutResult = this.processExternalAuthenticatorLogOut(sessionId))) {
            this.logoutFailed();
            return;
        }
        if (ExternalLogoutResult.REDIRECT == externalLogoutResult) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.idTokenHint != null && !this.idTokenHint.isEmpty()) {
            sb.append("id_token_hint=").append(this.idTokenHint);
        }
        if (sessionId != null && !this.postLogoutRedirectUri.isEmpty()) {
            sb.append("&session_id=").append(sessionId.getId());
        }
        if (this.postLogoutRedirectUri != null && !this.postLogoutRedirectUri.isEmpty()) {
            sb.append("&post_logout_redirect_uri=").append(this.postLogoutRedirectUri);
        }
        this.facesService.redirectToExternalURL("restv1/end_session?" + sb.toString());
    }

    private boolean validateParameters() {
        return (StringHelper.isNotEmpty((String)this.idTokenHint) || this.sessionId != null) && StringHelper.isNotEmpty((String)this.postLogoutRedirectUri);
    }

    private ExternalLogoutResult processExternalAuthenticatorLogOut(SessionId sessionId) {
        Boolean endSessionWithAccessToken;
        if (sessionId != null && sessionId.getSessionAttributes().containsKey(EXTERNAL_LOGOUT)) {
            this.log.debug("Detected callback from external system. Resuming logout.");
            return ExternalLogoutResult.SUCCESS;
        }
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(this.idTokenHint);
        if (authorizationGrant == null && (endSessionWithAccessToken = this.appConfiguration.getEndSessionWithAccessToken()) != null && endSessionWithAccessToken.booleanValue()) {
            authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(this.idTokenHint);
        }
        if (authorizationGrant == null && sessionId == null) {
            return ExternalLogoutResult.FAILURE;
        }
        String acrValues = authorizationGrant == null ? this.sessionIdService.getAcr(sessionId) : authorizationGrant.getAcrValues();
        boolean isExternalAuthenticatorLogoutPresent = StringHelper.isNotEmpty((String)acrValues);
        if (isExternalAuthenticatorLogoutPresent) {
            this.log.debug("Attemptinmg to execute logout method of '{}' external authenticator.", (Object)acrValues);
            CustomScriptConfiguration customScriptConfiguration = this.externalAuthenticationService.getCustomScriptConfigurationByName(acrValues);
            if (customScriptConfiguration == null) {
                this.log.error("Failed to get ExternalAuthenticatorConfiguration. acr_values: {}", (Object)acrValues);
                return ExternalLogoutResult.FAILURE;
            }
            boolean scriptExternalLogoutResult = this.externalAuthenticationService.executeExternalLogout(customScriptConfiguration, null);
            ExternalLogoutResult externalLogoutResult = scriptExternalLogoutResult ? ExternalLogoutResult.SUCCESS : ExternalLogoutResult.FAILURE;
            this.log.debug("Logout result is '{}' for session '{}', userDn: '{}'", new Object[]{externalLogoutResult, sessionId.getId(), sessionId.getUserDn()});
            int apiVersion = this.externalAuthenticationService.executeExternalGetApiVersion(customScriptConfiguration);
            if (apiVersion < 3) {
                return externalLogoutResult;
            }
            this.log.trace("According to API version script supports logout redirects");
            String logoutExternalUrl = this.externalAuthenticationService.getLogoutExternalUrl(customScriptConfiguration, null);
            this.log.debug("External logout result is '{}' for user '{}'", (Object)logoutExternalUrl, (Object)sessionId.getUserDn());
            if (StringHelper.isEmpty((String)logoutExternalUrl)) {
                return externalLogoutResult;
            }
            try {
                this.storeLogoutParametersInSession(sessionId);
            }
            catch (IOException ex) {
                this.log.debug("Failed to persist logout parameters in session", (Throwable)ex);
                return ExternalLogoutResult.FAILURE;
            }
            this.facesService.redirectToExternalURL(logoutExternalUrl);
            return ExternalLogoutResult.REDIRECT;
        }
        return ExternalLogoutResult.SUCCESS;
    }

    private void storeLogoutParametersInSession(SessionId sessionId) throws JsonGenerationException, JsonMappingException, IOException {
        Map<String, String> sessionAttributes = sessionId.getSessionAttributes();
        LogoutParameters logoutParameters = new LogoutParameters(this.idTokenHint, this.postLogoutRedirectUri);
        String logoutParametersJson = this.jsonService.objectToJson((Object)logoutParameters);
        String logoutParametersBase64 = Base64Util.base64urlencode((byte[])logoutParametersJson.getBytes("UTF-8"));
        sessionAttributes.put(EXTERNAL_LOGOUT, Boolean.toString(true));
        sessionAttributes.put(EXTERNAL_LOGOUT_DATA, logoutParametersBase64);
        this.sessionIdService.updateSessionId(sessionId);
    }

    private boolean restoreLogoutParametersFromSession(SessionId sessionId) throws IllegalArgumentException, JsonParseException, JsonMappingException, IOException {
        if (sessionId == null) {
            return false;
        }
        this.sessionId = sessionId;
        Map<String, String> sessionAttributes = sessionId.getSessionAttributes();
        boolean restoreParameters = sessionAttributes.containsKey(EXTERNAL_LOGOUT);
        if (!restoreParameters) {
            return false;
        }
        String logoutParametersBase64 = sessionAttributes.get(EXTERNAL_LOGOUT_DATA);
        String logoutParametersJson = new String(Base64Util.base64urldecode((String)logoutParametersBase64), "UTF-8");
        LogoutParameters logoutParameters = (LogoutParameters)this.jsonService.jsonToObject(logoutParametersJson, LogoutParameters.class);
        this.idTokenHint = logoutParameters.getIdTokenHint();
        this.postLogoutRedirectUri = logoutParameters.getPostLogoutRedirectUri();
        return true;
    }

    public void missingLogoutParameters() {
        String message = this.languageBean.getMessage("logout.missingParameters");
        this.facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message));
        this.facesService.redirect("/error.xhtml");
    }

    public void logoutFailed() {
        String message = this.languageBean.getMessage("logout.failedToProceed");
        this.facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message));
        this.facesService.redirect("/error.xhtml");
    }

    private static enum ExternalLogoutResult {
        SUCCESS,
        FAILURE,
        REDIRECT;

    }

    public static class LogoutParameters {
        private String idTokenHint;
        private String postLogoutRedirectUri;

        public LogoutParameters() {
        }

        public LogoutParameters(String idTokenHint, String postLogoutRedirectUri) {
            this.idTokenHint = idTokenHint;
            this.postLogoutRedirectUri = postLogoutRedirectUri;
        }

        public String getIdTokenHint() {
            return this.idTokenHint;
        }

        public void setIdTokenHint(String idTokenHint) {
            this.idTokenHint = idTokenHint;
        }

        public String getPostLogoutRedirectUri() {
            return this.postLogoutRedirectUri;
        }

        public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
            this.postLogoutRedirectUri = postLogoutRedirectUri;
        }
    }
}

