/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.authorize.ws.rs;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.wordnik.swagger.annotations.Api;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.gluu.oxauth.audit.ApplicationAuditLogger;
import org.gluu.oxauth.authorize.ws.rs.AuthorizeRestWebService;
import org.gluu.oxauth.ciba.CIBAPingCallbackProxy;
import org.gluu.oxauth.ciba.CIBAPushTokenDeliveryProxy;
import org.gluu.oxauth.ciba.CIBASupportProxy;
import org.gluu.oxauth.model.audit.Action;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.gluu.oxauth.model.authorize.AuthorizeParamsValidator;
import org.gluu.oxauth.model.authorize.Claim;
import org.gluu.oxauth.model.authorize.JwtAuthorizationRequest;
import org.gluu.oxauth.model.authorize.ScopeChecker;
import org.gluu.oxauth.model.common.AccessToken;
import org.gluu.oxauth.model.common.AuthorizationCode;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.BackchannelTokenDeliveryMode;
import org.gluu.oxauth.model.common.CIBAGrant;
import org.gluu.oxauth.model.common.ExecutionContext;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.IdToken;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.RefreshToken;
import org.gluu.oxauth.model.common.ResponseMode;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.SessionIdState;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.config.ConfigurationFactory;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.binding.TokenBindingMessage;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.exception.AcrChangedException;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.exception.InvalidSessionStateException;
import org.gluu.oxauth.model.ldap.ClientAuthorization;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.JsonWebResponse;
import org.gluu.oxauth.model.util.Base64Util;
import org.gluu.oxauth.model.util.JwtUtil;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.security.Identity;
import org.gluu.oxauth.service.AuthenticationFilterService;
import org.gluu.oxauth.service.ClientAuthorizationsService;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.RedirectionUriService;
import org.gluu.oxauth.service.RequestParameterService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.UserService;
import org.gluu.oxauth.util.QueryStringDecoder;
import org.gluu.oxauth.util.RedirectUri;
import org.gluu.oxauth.util.RedirectUtil;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.util.StringHelper;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;

@Path(value="/")
@Api(value="/oxauth/authorize", description="Authorization Endpoint")
public class AuthorizeRestWebServiceImpl
implements AuthorizeRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private RedirectionUriService redirectionUriService;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ClientService clientService;
    @Inject
    private UserService userService;
    @Inject
    private Identity identity;
    @Inject
    private AuthenticationFilterService authenticationFilterService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private ScopeChecker scopeChecker;
    @Inject
    private ClientAuthorizationsService clientAuthorizationsService;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ConfigurationFactory \u0441onfigurationFactory;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private CIBASupportProxy cibaSupportProxy;
    @Inject
    private CIBAPushTokenDeliveryProxy cibaPushTokenDeliveryProxy;
    @Inject
    private CIBAPingCallbackProxy cibaPingCallbackProxy;
    @Context
    private HttpServletRequest servletRequest;

    @Override
    public Response requestAuthorizationGet(String scope, String responseType, String clientId, String redirectUri, String state, String responseMode, String nonce, String display, String prompt, Integer maxAge, String uiLocales, String idTokenHint, String loginHint, String acrValues, String amrValues, String request, String requestUri, String requestSessionId, String sessionId, String originHeaders, String codeChallenge, String codeChallengeMethod, String customResponseHeaders, String claims, String authReqId, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        return this.requestAuthorization(scope, responseType, clientId, redirectUri, state, responseMode, nonce, display, prompt, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, requestSessionId, sessionId, "GET", originHeaders, codeChallenge, codeChallengeMethod, customResponseHeaders, claims, authReqId, httpRequest, httpResponse, securityContext);
    }

    @Override
    public Response requestAuthorizationPost(String scope, String responseType, String clientId, String redirectUri, String state, String responseMode, String nonce, String display, String prompt, Integer maxAge, String uiLocales, String idTokenHint, String loginHint, String acrValues, String amrValues, String request, String requestUri, String requestSessionId, String sessionId, String originHeaders, String codeChallenge, String codeChallengeMethod, String customResponseHeaders, String claims, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        return this.requestAuthorization(scope, responseType, clientId, redirectUri, state, responseMode, nonce, display, prompt, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, requestSessionId, sessionId, "POST", originHeaders, codeChallenge, codeChallengeMethod, customResponseHeaders, claims, null, httpRequest, httpResponse, securityContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response requestAuthorization(String scope, String responseType, String clientId, String redirectUri, String state, String respMode, String nonce, String display, String prompt, Integer maxAge, String uiLocalesStr, String idTokenHint, String loginHint, String acrValuesStr, String amrValuesStr, String request, String requestUri, String requestSessionId, String sessionId, String method, String originHeaders, String codeChallenge, String codeChallengeMethod, String customRespHeaders, String claims, String authReqId, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        Response.ResponseBuilder builder;
        OAuth2AuditLog oAuth2AuditLog;
        block82: {
            scope = ServerUtil.urlDecode(scope);
            String tokenBindingHeader = httpRequest.getHeader("Sec-Token-Binding");
            oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.USER_AUTHORIZATION);
            oAuth2AuditLog.setClientId(clientId);
            oAuth2AuditLog.setScope(scope);
            this.log.debug("Attempting to request authorization: responseType = {}, clientId = {}, scope = {}, redirectUri = {}, nonce = {}, state = {}, request = {}, isSecure = {}, requestSessionId = {}, sessionId = {}", new Object[]{responseType, clientId, scope, redirectUri, nonce, state, request, securityContext.isSecure(), requestSessionId, sessionId});
            this.log.debug("Attempting to request authorization: acrValues = {}, amrValues = {}, originHeaders = {}, codeChallenge = {}, codeChallengeMethod = {}, customRespHeaders = {}, claims = {}, tokenBindingHeader = {}", new Object[]{acrValuesStr, amrValuesStr, originHeaders, codeChallenge, codeChallengeMethod, customRespHeaders, claims, tokenBindingHeader});
            builder = Response.ok();
            List uiLocales = null;
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)uiLocalesStr)) {
                uiLocales = Util.splittedStringAsList((String)uiLocalesStr, (String)" ");
            }
            List responseTypes = ResponseType.fromString((String)responseType, (String)" ");
            List prompts = Prompt.fromString((String)prompt, (String)" ");
            ArrayList<String> acrValues = Util.splittedStringAsList((String)acrValuesStr, (String)" ");
            List amrValues = Util.splittedStringAsList((String)amrValuesStr, (String)" ");
            ResponseMode responseMode = ResponseMode.getByValue((String)respMode);
            Map<String, String> customParameters = this.requestParameterService.getCustomParameters(QueryStringDecoder.decode(httpRequest.getQueryString()));
            SessionId sessionUser = this.identity.getSessionId();
            User user = this.sessionIdService.getUser(sessionUser);
            try {
                Map customResponseHeaders;
                block81: {
                    customResponseHeaders = Util.jsonObjectArrayStringAsMap((String)customRespHeaders);
                    try {
                        this.sessionIdService.assertAuthenticatedSessionCorrespondsToNewRequest(sessionUser, acrValuesStr);
                    }
                    catch (AcrChangedException e) {
                        if (!e.isForceReAuthentication()) {
                            throw e;
                        }
                        if (prompts.contains(Prompt.LOGIN)) break block81;
                        this.log.info("ACR is changed, adding prompt=login to prompts");
                        prompts.add(Prompt.LOGIN);
                        sessionUser.setState(SessionIdState.UNAUTHENTICATED);
                        sessionUser.getSessionAttributes().put("prompt", StringUtils.implode((Collection)prompts, (String)" "));
                        this.sessionIdService.persistSessionId(sessionUser);
                    }
                }
                if (sessionUser != null) {
                    Map<String, String> sessionAttributes = sessionUser.getSessionAttributes();
                    String authorizedGrant = sessionUser.getSessionAttributes().get("authorized_grant");
                    if (StringHelper.isNotEmpty((String)authorizedGrant) && GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS == GrantType.fromString((String)authorizedGrant)) {
                        sessionAttributes.remove("authorized_grant");
                        Map<String, String> parameterMap = this.getGenericRequestMap(httpRequest);
                        Map<String, String> requestParameterMap = this.requestParameterService.getAllowedParameters(parameterMap);
                        sessionAttributes.putAll(requestParameterMap);
                        this.sessionIdService.updateSessionId(sessionUser, true, true, true);
                    }
                }
                if (!AuthorizeParamsValidator.validateParams(responseType, clientId, prompts, nonce, request, requestUri)) {
                    if (clientId != null && redirectUri != null && this.redirectionUriService.validateRedirectionUri(clientId, redirectUri) != null) {
                        RedirectUri redirectUriResponse = new RedirectUri(redirectUri, responseTypes, responseMode);
                        redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, state));
                        builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                        break block82;
                    } else {
                        builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE);
                        builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, state, "Invalid redirect uri."));
                    }
                    break block82;
                }
                Client client = this.clientService.getClient(clientId);
                if (CollectionUtils.isEmpty((Collection)acrValues) && client != null && !ArrayUtils.isEmpty((Object[])client.getDefaultAcrValues())) {
                    acrValues = new ArrayList<String>();
                    acrValues.addAll(Arrays.asList(client.getDefaultAcrValues()));
                }
                JwtAuthorizationRequest jwtAuthorizationRequest = null;
                if (client != null) {
                    boolean validRedirectUri;
                    if (client.isDisabled()) {
                        builder = Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE);
                        builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.DISABLED_CLIENT, state, "Client is disabled."));
                        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                        return builder.build();
                    }
                    ArrayList<String> scopes = new ArrayList<String>();
                    if (StringHelper.isNotEmpty((String)scope)) {
                        Set<String> grantedScopes = this.scopeChecker.checkScopesPolicy(client, scope);
                        scopes.addAll(grantedScopes);
                    }
                    boolean bl = validRedirectUri = (redirectUri = this.redirectionUriService.validateRedirectionUri(clientId, redirectUri)) != null;
                    if (AuthorizeParamsValidator.validateResponseTypes(responseTypes, client) && AuthorizeParamsValidator.validateGrantType(responseTypes, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        if (validRedirectUri) {
                            CIBAGrant cibaGrant;
                            Claim userIdClaim;
                            if (org.apache.commons.lang.StringUtils.isNotBlank((String)requestUri)) {
                                boolean validRequestUri = false;
                                try {
                                    URI reqUri = new URI(requestUri);
                                    String reqUriHash = reqUri.getFragment();
                                    String reqUriWithoutFragment = reqUri.getScheme() + ":" + reqUri.getSchemeSpecificPart();
                                    ClientRequest clientRequest = new ClientRequest(reqUriWithoutFragment);
                                    clientRequest.setHttpMethod("GET");
                                    ClientResponse clientResponse = clientRequest.get(String.class);
                                    int status = clientResponse.getStatus();
                                    if (status == 200) {
                                        request = (String)clientResponse.getEntity(String.class);
                                        if (org.apache.commons.lang.StringUtils.isBlank((String)reqUriHash)) {
                                            validRequestUri = true;
                                        } else {
                                            String hash = Base64Util.base64urlencode((byte[])JwtUtil.getMessageDigestSHA256((String)request));
                                            validRequestUri = org.apache.commons.lang.StringUtils.equals((String)reqUriHash, (String)hash);
                                        }
                                    }
                                    if (!validRequestUri) {
                                        RedirectUri redirectUriResponse = new RedirectUri(redirectUri, responseTypes, responseMode);
                                        redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_URI, state));
                                        builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                                        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                                        return builder.build();
                                    }
                                    requestUri = null;
                                }
                                catch (URISyntaxException e) {
                                    this.log.error(e.getMessage(), (Throwable)e);
                                }
                                catch (UnknownHostException e) {
                                    this.log.error(e.getMessage(), (Throwable)e);
                                }
                                catch (ConnectException e) {
                                    this.log.error(e.getMessage(), (Throwable)e);
                                }
                                catch (Exception e) {
                                    this.log.error(e.getMessage(), (Throwable)e);
                                }
                            }
                            boolean invalidOpenidRequestObject = false;
                            if (org.apache.commons.lang.StringUtils.isNotBlank((String)request)) {
                                try {
                                    jwtAuthorizationRequest = new JwtAuthorizationRequest(this.appConfiguration, this.cryptoProvider, request, client);
                                    if (!jwtAuthorizationRequest.getResponseTypes().containsAll(responseTypes) || !responseTypes.containsAll(jwtAuthorizationRequest.getResponseTypes())) {
                                        throw new InvalidJwtException("The responseType parameter is not the same in the JWT");
                                    }
                                    if (jwtAuthorizationRequest.getClientId() != null && !jwtAuthorizationRequest.getClientId().equals(clientId)) {
                                        throw new InvalidJwtException("The clientId parameter is not the same in the JWT");
                                    }
                                    if (!jwtAuthorizationRequest.getScopes().containsAll(scopes) || !scopes.containsAll(jwtAuthorizationRequest.getScopes())) {
                                        throw new InvalidJwtException("The scope parameter is not the same in the JWT");
                                    }
                                    if (jwtAuthorizationRequest.getRedirectUri() != null && !jwtAuthorizationRequest.getRedirectUri().equals(redirectUri)) {
                                        throw new InvalidJwtException("The redirectUri parameter is not the same in the JWT");
                                    }
                                    if (jwtAuthorizationRequest.getState() != null && org.apache.commons.lang.StringUtils.isNotBlank((String)state) && !jwtAuthorizationRequest.getState().equals(state)) {
                                        throw new InvalidJwtException("The state parameter is not the same in the JWT");
                                    }
                                    if (jwtAuthorizationRequest.getNonce() != null && org.apache.commons.lang.StringUtils.isNotBlank((String)nonce) && !jwtAuthorizationRequest.getNonce().equals(nonce)) {
                                        throw new InvalidJwtException("The nonce parameter is not the same in the JWT");
                                    }
                                    if (jwtAuthorizationRequest.getDisplay() != null && org.apache.commons.lang.StringUtils.isNotBlank((String)display) && !jwtAuthorizationRequest.getDisplay().getParamName().equals(display)) {
                                        throw new InvalidJwtException("The display parameter is not the same in the JWT");
                                    }
                                    if (!(jwtAuthorizationRequest.getPrompts().isEmpty() || prompts.isEmpty() || jwtAuthorizationRequest.getPrompts().containsAll(prompts))) {
                                        throw new InvalidJwtException("The prompt parameter is not the same in the JWT");
                                    }
                                    if (jwtAuthorizationRequest.getIdTokenMember() != null && jwtAuthorizationRequest.getIdTokenMember().getMaxAge() != null && maxAge != null && !jwtAuthorizationRequest.getIdTokenMember().getMaxAge().equals(maxAge)) {
                                        throw new InvalidJwtException("The maxAge parameter is not the same in the JWT");
                                    }
                                }
                                catch (InvalidJwtException e) {
                                    invalidOpenidRequestObject = true;
                                    this.log.debug("Invalid JWT authorization request. Exception = {}, Message = {}", new Object[]{e, ((Object)((Object)e)).getClass().getName(), e.getMessage()});
                                }
                                catch (Exception e) {
                                    invalidOpenidRequestObject = true;
                                    this.log.debug("Invalid JWT authorization request. Exception = {}, Message = {}", new Object[]{e, e.getClass().getName(), e.getMessage()});
                                }
                            }
                            if (invalidOpenidRequestObject) {
                                RedirectUri redirectUriResponse = new RedirectUri(redirectUri, responseTypes, responseMode);
                                redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.INVALID_OPENID_REQUEST_OBJECT, state));
                                builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                                break block82;
                            }
                            AuthorizationGrant authorizationGrant = null;
                            RedirectUri redirectUriResponse = new RedirectUri(redirectUri, responseTypes, responseMode);
                            if (jwtAuthorizationRequest != null && jwtAuthorizationRequest.getIdTokenMember() != null && (userIdClaim = jwtAuthorizationRequest.getIdTokenMember().getClaim("sub")) != null && userIdClaim.getClaimValue() != null && userIdClaim.getClaimValue().getValue() != null) {
                                String userId;
                                String userIdClaimValue = userIdClaim.getClaimValue().getValue();
                                if (user != null && !(userId = user.getUserId()).equalsIgnoreCase(userIdClaimValue)) {
                                    redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.USER_MISMATCHED, state));
                                    builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                                    this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                                    return builder.build();
                                }
                            }
                            if (user == null) {
                                this.identity.logout();
                                if (prompts.contains(Prompt.NONE)) {
                                    if (!this.authenticationFilterService.isEnabled()) {
                                        redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.LOGIN_REQUIRED, state));
                                        builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                                        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                                        return builder.build();
                                    }
                                    Map<String, String> params = method.equals("GET") ? QueryStringDecoder.decode(httpRequest.getQueryString()) : this.getGenericRequestMap(httpRequest);
                                    String userDn = this.authenticationFilterService.processAuthenticationFilters(params);
                                    if (userDn == null) {
                                        redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.LOGIN_REQUIRED, state));
                                        builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                                        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                                        return builder.build();
                                    }
                                    Map<String, String> genericRequestMap = this.getGenericRequestMap(httpRequest);
                                    HashMap parameterMap = Maps.newHashMap(genericRequestMap);
                                    Map<String, String> requestParameterMap = this.requestParameterService.getAllowedParameters(parameterMap);
                                    sessionUser = this.sessionIdService.generateAuthenticatedSessionId(httpRequest, userDn, prompt);
                                    sessionUser.setSessionAttributes(requestParameterMap);
                                    this.sessionIdService.createSessionIdCookie(sessionUser.getId(), sessionUser.getSessionState(), sessionUser.getOPBrowserState(), httpResponse, false);
                                    this.sessionIdService.updateSessionId(sessionUser);
                                    user = this.userService.getUserByDn(sessionUser.getUserDn(), new String[0]);
                                } else {
                                    if (prompts.contains(Prompt.LOGIN)) {
                                        this.endSession(sessionId, httpRequest, httpResponse);
                                        sessionId = null;
                                        prompts.remove(Prompt.LOGIN);
                                    }
                                    this.redirectToAuthorizationPage(redirectUriResponse, responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters);
                                    builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                                    this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                                    return builder.build();
                                }
                            }
                            boolean validAuthenticationMaxAge = true;
                            Integer authenticationMaxAge = null;
                            if (maxAge != null) {
                                authenticationMaxAge = maxAge;
                            } else if (!invalidOpenidRequestObject && jwtAuthorizationRequest != null && jwtAuthorizationRequest.getIdTokenMember() != null && jwtAuthorizationRequest.getIdTokenMember().getMaxAge() != null) {
                                authenticationMaxAge = jwtAuthorizationRequest.getIdTokenMember().getMaxAge();
                            }
                            GregorianCalendar now = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                            GregorianCalendar userAuthenticationTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                            if (sessionUser.getAuthenticationTime() != null) {
                                userAuthenticationTime.setTime(sessionUser.getAuthenticationTime());
                            }
                            if (authenticationMaxAge != null) {
                                userAuthenticationTime.add(13, authenticationMaxAge);
                                validAuthenticationMaxAge = userAuthenticationTime.after(now);
                            } else if (client.getDefaultMaxAge() != null) {
                                userAuthenticationTime.add(13, client.getDefaultMaxAge());
                                validAuthenticationMaxAge = userAuthenticationTime.after(now);
                            }
                            if (!validAuthenticationMaxAge) {
                                this.endSession(sessionId, httpRequest, httpResponse);
                                sessionId = null;
                                this.redirectToAuthorizationPage(redirectUriResponse, responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters);
                                builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                                this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                                return builder.build();
                            }
                            oAuth2AuditLog.setUsername(user.getUserId());
                            ClientAuthorization clientAuthorization = this.clientAuthorizationsService.find(user.getAttribute("inum"), client.getClientId(), client.getPersistClientAuthorizations());
                            if (scopes.size() > 0) {
                                if (clientAuthorization != null && clientAuthorization.getScopes() != null) {
                                    if (!Arrays.asList(clientAuthorization.getScopes()).containsAll(scopes)) {
                                        this.redirectToAuthorizationPage(redirectUriResponse, responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters);
                                        builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                                        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                                        return builder.build();
                                    }
                                    sessionUser.addPermission(clientId, true);
                                } else if (client.getTrustedClient()) {
                                    sessionUser.addPermission(clientId, true);
                                }
                            }
                            if (prompts.contains(Prompt.LOGIN)) {
                                if (this.identity.getSessionId().getState() == SessionIdState.AUTHENTICATED) {
                                    this.endSession(sessionId, httpRequest, httpResponse);
                                }
                                sessionId = null;
                                prompts.remove(Prompt.LOGIN);
                                this.redirectToAuthorizationPage(redirectUriResponse, responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters);
                                builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                                this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                                return builder.build();
                            }
                            if (prompts.contains(Prompt.CONSENT) || !sessionUser.isPermissionGrantedForClient(clientId).booleanValue()) {
                                this.clientAuthorizationsService.clearAuthorizations(clientAuthorization, client.getPersistClientAuthorizations());
                                this.redirectToAuthorizationPage(redirectUriResponse, responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters);
                                builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                                this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                                return builder.build();
                            }
                            AuthorizationCode authorizationCode = null;
                            if (responseTypes.contains(ResponseType.CODE)) {
                                authorizationGrant = this.authorizationGrantList.createAuthorizationCodeGrant(user, client, sessionUser.getAuthenticationTime());
                                authorizationGrant.setNonce(nonce);
                                authorizationGrant.setJwtAuthorizationRequest(jwtAuthorizationRequest);
                                authorizationGrant.setTokenBindingHash(TokenBindingMessage.getTokenBindingIdHashFromTokenBindingMessage((String)tokenBindingHeader, (String)client.getIdTokenTokenBindingCnf()));
                                authorizationGrant.setScopes(scopes);
                                authorizationGrant.setCodeChallenge(codeChallenge);
                                authorizationGrant.setCodeChallengeMethod(codeChallengeMethod);
                                authorizationGrant.setClaims(claims);
                                authorizationGrant.setAcrValues(acrValuesStr);
                                authorizationGrant.setSessionDn(sessionUser.getDn());
                                authorizationGrant.save();
                                authorizationCode = authorizationGrant.getAuthorizationCode();
                                redirectUriResponse.addResponseParameter("code", authorizationCode.getCode());
                            }
                            AccessToken newAccessToken = null;
                            if (responseTypes.contains(ResponseType.TOKEN)) {
                                if (authorizationGrant == null) {
                                    authorizationGrant = this.authorizationGrantList.createImplicitGrant(user, client, sessionUser.getAuthenticationTime());
                                    authorizationGrant.setNonce(nonce);
                                    authorizationGrant.setJwtAuthorizationRequest(jwtAuthorizationRequest);
                                    authorizationGrant.setScopes(scopes);
                                    authorizationGrant.setClaims(claims);
                                    authorizationGrant.setAcrValues(acrValuesStr);
                                    authorizationGrant.setSessionDn(sessionUser.getDn());
                                    authorizationGrant.save();
                                }
                                newAccessToken = authorizationGrant.createAccessToken(httpRequest.getHeader("X-ClientCert"), new ExecutionContext(httpRequest, httpResponse));
                                redirectUriResponse.addResponseParameter("access_token", newAccessToken.getCode());
                                redirectUriResponse.addResponseParameter("token_type", newAccessToken.getTokenType().toString());
                                redirectUriResponse.addResponseParameter("expires_in", newAccessToken.getExpiresIn() + "");
                            }
                            if (responseTypes.contains(ResponseType.ID_TOKEN)) {
                                boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
                                if (authorizationGrant == null) {
                                    includeIdTokenClaims = true;
                                    authorizationGrant = this.authorizationGrantList.createImplicitGrant(user, client, sessionUser.getAuthenticationTime());
                                    authorizationGrant.setNonce(nonce);
                                    authorizationGrant.setJwtAuthorizationRequest(jwtAuthorizationRequest);
                                    authorizationGrant.setScopes(scopes);
                                    authorizationGrant.setClaims(claims);
                                    authorizationGrant.setAcrValues(acrValuesStr);
                                    authorizationGrant.setSessionDn(sessionUser.getDn());
                                    authorizationGrant.save();
                                }
                                IdToken idToken = authorizationGrant.createIdToken(nonce, authorizationCode, newAccessToken, null, state, authorizationGrant, includeIdTokenClaims, (Function<JsonWebResponse, Void>)TokenBindingMessage.createIdTokenTokingBindingPreprocessing((String)tokenBindingHeader, (String)client.getIdTokenTokenBindingCnf()));
                                redirectUriResponse.addResponseParameter("id_token", idToken.getCode());
                            }
                            if (authorizationGrant != null && StringHelper.isNotEmpty((String)acrValuesStr)) {
                                redirectUriResponse.addResponseParameter("acr_values", acrValuesStr);
                            }
                            if (sessionUser.getId() == null) {
                                SessionId newSessionUser = this.sessionIdService.generateAuthenticatedSessionId(httpRequest, sessionUser.getUserDn(), prompt);
                                String newSessionId = newSessionUser.getId();
                                sessionUser.setId(newSessionId);
                                this.log.trace("newSessionId = {}", (Object)newSessionId);
                            }
                            redirectUriResponse.addResponseParameter("session_id", sessionUser.getId());
                            redirectUriResponse.addResponseParameter("session_state", this.sessionIdService.computeSessionState(sessionUser, clientId, redirectUri));
                            redirectUriResponse.addResponseParameter("state", state);
                            if (scope != null && !scope.isEmpty()) {
                                scope = authorizationGrant.checkScopesPolicy(scope);
                                redirectUriResponse.addResponseParameter("scope", scope);
                            }
                            this.clientService.updateAccessTime(client, false);
                            oAuth2AuditLog.setSuccess(true);
                            builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                            if (this.appConfiguration.getCustomHeadersWithAuthorizationResponse().booleanValue()) {
                                for (String key : customResponseHeaders.keySet()) {
                                    builder.header(key, customResponseHeaders.get(key));
                                }
                            }
                            if (!org.apache.commons.lang.StringUtils.isNotBlank((String)authReqId) || !this.cibaSupportProxy.isCIBASupported() || (cibaGrant = this.authorizationGrantList.getCIBAGrant(authReqId)) == null) break block82;
                            if (cibaGrant.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PUSH) {
                                RefreshToken refreshToken = cibaGrant.createRefreshToken();
                                this.log.debug("Issuing refresh token: {}", (Object)refreshToken.getCode());
                                AccessToken accessToken = cibaGrant.createAccessToken(httpRequest.getHeader("X-ClientCert"), new ExecutionContext(httpRequest, httpResponse));
                                this.log.debug("Issuing access token: {}", (Object)accessToken.getCode());
                                IdToken idToken = cibaGrant.createIdToken(null, null, accessToken, refreshToken, null, cibaGrant, false, null);
                                cibaGrant.setUserAuthorization(true);
                                cibaGrant.setTokensDelivered(true);
                                cibaGrant.save();
                                this.cibaPushTokenDeliveryProxy.pushTokenDelivery(cibaGrant.getCIBAAuthenticationRequestId().getCode(), cibaGrant.getClient().getBackchannelClientNotificationEndpoint(), cibaGrant.getClientNotificationToken(), accessToken.getCode(), refreshToken.getCode(), idToken.getCode(), accessToken.getExpiresIn());
                                break block82;
                            }
                            if (cibaGrant.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PING) {
                                cibaGrant.setUserAuthorization(true);
                                cibaGrant.setTokensDelivered(false);
                                cibaGrant.save();
                                this.cibaPingCallbackProxy.pingCallback(cibaGrant.getCIBAAuthenticationRequestId().getCode(), cibaGrant.getClient().getBackchannelClientNotificationEndpoint(), cibaGrant.getClientNotificationToken());
                                break block82;
                            }
                            if (cibaGrant.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.POLL) {
                                cibaGrant.setUserAuthorization(true);
                                cibaGrant.setTokensDelivered(false);
                                cibaGrant.save();
                            }
                            break block82;
                        }
                        builder = this.error(Response.Status.BAD_REQUEST, AuthorizeErrorResponseType.INVALID_REQUEST_REDIRECT_URI, state);
                        break block82;
                    }
                    builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNSUPPORTED_RESPONSE_TYPE, state, ""));
                    break block82;
                }
                builder = this.error(Response.Status.UNAUTHORIZED, AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state);
            }
            catch (AcrChangedException e) {
                this.log.error("ACR is changed, please provide a supported and enabled acr value");
                this.log.error(e.getMessage(), (Throwable)e);
                RedirectUri redirectUriResponse = new RedirectUri(redirectUri, responseTypes, responseMode);
                redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.SESSION_SELECTION_REQUIRED, state));
                redirectUriResponse.addResponseParameter("hint", "Use prompt=login in order to alter existing session.");
                this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                return RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest).build();
            }
            catch (EntryPersistenceException e) {
                builder = this.error(Response.Status.UNAUTHORIZED, AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state);
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (InvalidSessionStateException ex) {
                throw ex;
            }
            catch (Exception e) {
                builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    private void overrideUnauthenticatedSessionParameters(HttpServletRequest httpRequest, List<Prompt> prompts) {
        SessionId sessionUser = this.identity.getSessionId();
        if (sessionUser != null && sessionUser.getState() != SessionIdState.AUTHENTICATED) {
            Map<String, String> genericRequestMap = this.getGenericRequestMap(httpRequest);
            HashMap parameterMap = Maps.newHashMap(genericRequestMap);
            Map<String, String> requestParameterMap = this.requestParameterService.getAllowedParameters(parameterMap);
            sessionUser.setUserDn(null);
            sessionUser.setUser(null);
            sessionUser.setSessionAttributes(requestParameterMap);
            boolean persisted = this.sessionIdService.persistSessionId(sessionUser, !prompts.contains(Prompt.NONE));
            if (persisted) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Session '{}' persisted to LDAP", (Object)sessionUser.getId());
                }
            } else {
                this.log.error("Failed to persisted session: {}", (Object)sessionUser.getId());
            }
        }
    }

    private Map<String, String> getGenericRequestMap(HttpServletRequest httpRequest) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : httpRequest.getParameterMap().entrySet()) {
            result.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return result;
    }

    private Response.ResponseBuilder error(Response.Status p_status, AuthorizeErrorResponseType p_type, String p_state) {
        return Response.status((int)p_status.getStatusCode()).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)p_type, p_state, "")).type(MediaType.APPLICATION_JSON_TYPE);
    }

    private void redirectToAuthorizationPage(RedirectUri redirectUriResponse, List<ResponseType> responseTypes, String scope, String clientId, String redirectUri, String state, ResponseMode responseMode, String nonce, String display, List<Prompt> prompts, Integer maxAge, List<String> uiLocales, String idTokenHint, String loginHint, List<String> acrValues, List<String> amrValues, String request, String requestUri, String originHeaders, String codeChallenge, String codeChallengeMethod, String sessionId, String claims, String authReqId, Map<String, String> customParameters) {
        String amrValuesStr;
        String acrValuesStr;
        String uiLocalesStr;
        String prompt;
        URI contextUri = URI.create(this.appConfiguration.getIssuer()).resolve(this.servletRequest.getContextPath() + "/authorize" + this.\u0441onfigurationFactory.getFacesMapping());
        redirectUriResponse.setBaseRedirectUri(contextUri.toString());
        redirectUriResponse.setResponseMode(ResponseMode.QUERY);
        String responseType = StringUtils.implode(responseTypes, (String)" ");
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)responseType)) {
            redirectUriResponse.addResponseParameter("response_type", responseType);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)scope)) {
            redirectUriResponse.addResponseParameter("scope", scope);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)clientId)) {
            redirectUriResponse.addResponseParameter("client_id", clientId);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)redirectUri)) {
            redirectUriResponse.addResponseParameter("redirect_uri", redirectUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)state)) {
            redirectUriResponse.addResponseParameter("state", state);
        }
        if (responseMode != null) {
            redirectUriResponse.addResponseParameter("response_mode", responseMode.getParamName());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)nonce)) {
            redirectUriResponse.addResponseParameter("nonce", nonce);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)display)) {
            redirectUriResponse.addResponseParameter("display", display);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)(prompt = StringUtils.implode(prompts, (String)" ")))) {
            redirectUriResponse.addResponseParameter("prompt", prompt);
        }
        if (maxAge != null) {
            redirectUriResponse.addResponseParameter("max_age", maxAge.toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)(uiLocalesStr = StringUtils.implode(uiLocales, (String)" ")))) {
            redirectUriResponse.addResponseParameter("ui_locales", uiLocalesStr);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)idTokenHint)) {
            redirectUriResponse.addResponseParameter("id_token_hint", idTokenHint);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)loginHint)) {
            redirectUriResponse.addResponseParameter("login_hint", loginHint);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)(acrValuesStr = StringUtils.implode(acrValues, (String)" ")))) {
            redirectUriResponse.addResponseParameter("acr_values", acrValuesStr);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)(amrValuesStr = StringUtils.implode(amrValues, (String)" ")))) {
            redirectUriResponse.addResponseParameter("amr_values", amrValuesStr);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)request)) {
            redirectUriResponse.addResponseParameter("request", request);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)requestUri)) {
            redirectUriResponse.addResponseParameter("request_uri", requestUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)codeChallenge)) {
            redirectUriResponse.addResponseParameter("code_challenge", codeChallenge);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)codeChallengeMethod)) {
            redirectUriResponse.addResponseParameter("code_challenge_method", codeChallengeMethod);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)sessionId)) {
            redirectUriResponse.addResponseParameter("session_id", sessionId);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)claims)) {
            redirectUriResponse.addResponseParameter("claims", claims);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)authReqId)) {
            redirectUriResponse.addResponseParameter("auth_req_id", authReqId);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)originHeaders)) {
            redirectUriResponse.addResponseParameter("origin_headers", originHeaders);
        }
        if (customParameters != null && customParameters.size() > 0) {
            for (Map.Entry<String, String> entry : customParameters.entrySet()) {
                redirectUriResponse.addResponseParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    private void endSession(String sessionId, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String id;
        SessionId sessionUser = this.identity.getSessionId();
        this.identity.logout();
        if (sessionUser != null) {
            sessionUser.setUserDn(null);
            sessionUser.setUser(null);
            sessionUser.setAuthenticationTime(null);
        }
        if (StringHelper.isEmpty((String)(id = sessionId))) {
            id = this.sessionIdService.getSessionIdFromCookie(httpRequest);
        }
        if (StringHelper.isNotEmpty((String)id)) {
            SessionId ldapSessionId = this.sessionIdService.getSessionId(id);
            if (ldapSessionId != null) {
                boolean result = this.sessionIdService.remove(ldapSessionId);
                if (!result) {
                    this.log.error("Failed to remove session_id '{}' from LDAP", (Object)id);
                }
            } else {
                this.log.error("Failed to load session from LDAP by session_id: '{}'", (Object)id);
            }
        }
        this.sessionIdService.removeSessionIdCookie(httpResponse);
    }
}

