/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.authorize.ws.rs;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.util.Strings;
import org.gluu.jsf2.message.FacesMessages;
import org.gluu.jsf2.service.FacesService;
import org.gluu.model.AuthenticationScriptUsageType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.oxauth.authorize.ws.rs.ConsentGathererService;
import org.gluu.oxauth.i18n.LanguageBean;
import org.gluu.oxauth.model.auth.AuthenticationMode;
import org.gluu.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.gluu.oxauth.model.authorize.AuthorizeParamsValidator;
import org.gluu.oxauth.model.authorize.Claim;
import org.gluu.oxauth.model.authorize.JwtAuthorizationRequest;
import org.gluu.oxauth.model.authorize.ScopeChecker;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.CIBAGrant;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.SessionIdState;
import org.gluu.oxauth.model.common.SubjectType;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.exception.AcrChangedException;
import org.gluu.oxauth.model.exception.InvalidJweException;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.ldap.ClientAuthorization;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.util.Base64Util;
import org.gluu.oxauth.model.util.JwtUtil;
import org.gluu.oxauth.model.util.LocaleUtil;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.service.AuthorizeService;
import org.gluu.oxauth.service.ClientAuthorizationsService;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.ErrorHandlerService;
import org.gluu.oxauth.service.RedirectionUriService;
import org.gluu.oxauth.service.RequestParameterService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.UserService;
import org.gluu.oxauth.service.external.ExternalAuthenticationService;
import org.gluu.oxauth.service.external.ExternalConsentGatheringService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.service.net.NetworkService;
import org.gluu.util.StringHelper;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@RequestScoped
@Named
public class AuthorizeAction {
    @Inject
    private Logger log;
    @Inject
    private ClientService clientService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private UserService userService;
    @Inject
    private RedirectionUriService redirectionUriService;
    @Inject
    private ClientAuthorizationsService clientAuthorizationsService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private ExternalConsentGatheringService externalConsentGatheringService;
    @Inject
    private AuthenticationMode defaultAuthenticationMode;
    @Inject
    private LanguageBean languageBean;
    @Inject
    private NetworkService networkService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private FacesService facesService;
    @Inject
    private FacesMessages facesMessages;
    @Inject
    private FacesContext facesContext;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private ConsentGathererService consentGatherer;
    @Inject
    private AuthorizeService authorizeService;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private ScopeChecker scopeChecker;
    @Inject
    private ErrorHandlerService errorHandlerService;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    private String scope;
    private String responseType;
    private String clientId;
    private String redirectUri;
    private String state;
    private String responseMode;
    private String nonce;
    private String display;
    private String prompt;
    private Integer maxAge;
    private String uiLocales;
    private String idTokenHint;
    private String loginHint;
    private String acrValues;
    private String amrValues;
    private String request;
    private String requestUri;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String claims;
    private String authReqId;
    private String sessionId;
    private String allowedScope;

    public void checkUiLocales() {
        List uiLocalesList = null;
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.uiLocales)) {
            uiLocalesList = Util.splittedStringAsList((String)this.uiLocales, (String)" ");
            ArrayList supportedLocales = new ArrayList();
            Iterator it = this.facesContext.getApplication().getSupportedLocales();
            while (it.hasNext()) {
                supportedLocales.add(it.next());
            }
            Locale matchingLocale = LocaleUtil.localeMatch((List)uiLocalesList, supportedLocales);
            if (matchingLocale != null) {
                this.languageBean.setLocaleCode(matchingLocale.getLanguage());
            }
        } else {
            Locale defaultLocale = this.facesContext.getApplication().getDefaultLocale();
            if (defaultLocale != null) {
                this.languageBean.setLocaleCode(defaultLocale.getLanguage());
            }
        }
    }

    public void checkPermissionGranted() throws IOException {
        if (this.clientId == null || this.clientId.isEmpty()) {
            this.log.debug("Permission denied. client_id should be not empty.");
            this.permissionDenied();
            return;
        }
        Client client = null;
        try {
            client = this.clientService.getClient(this.clientId);
        }
        catch (EntryPersistenceException ex) {
            this.log.debug("Permission denied. Failed to find client by inum '{}' in LDAP.", (Object)this.clientId, (Object)ex);
            this.permissionDenied();
            return;
        }
        if (client == null) {
            this.log.debug("Permission denied. Failed to find client_id '{}' in LDAP.", (Object)this.clientId);
            this.permissionDenied();
            return;
        }
        Set<String> grantedScopes = this.scopeChecker.checkScopesPolicy(client, this.scope);
        this.allowedScope = StringUtils.implode(grantedScopes, (String)" ");
        SessionId session = this.getSession();
        List prompts = Prompt.fromString((String)this.prompt, (String)" ");
        try {
            session = this.sessionIdService.assertAuthenticatedSessionCorrespondsToNewRequest(session, this.acrValues);
        }
        catch (AcrChangedException e) {
            this.log.debug("There is already existing session which has another acr then {}, session: {}", (Object)this.acrValues, (Object)session.getId());
            if (e.isForceReAuthentication()) {
                session = this.handleAcrChange(session, prompts);
            }
            this.log.error("ACR is changed, please provide a supported and enabled acr value");
            this.permissionDenied();
            return;
        }
        if (session == null || org.apache.commons.lang.StringUtils.isBlank((String)session.getUserDn()) || SessionIdState.AUTHENTICATED != session.getState()) {
            boolean persisted;
            Map parameterMap = this.externalContext.getRequestParameterMap();
            Map<String, String> requestParameterMap = this.requestParameterService.getAllowedParameters(parameterMap);
            String redirectTo = "/login.xhtml";
            boolean useExternalAuthenticator = this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.INTERACTIVE);
            if (useExternalAuthenticator) {
                CustomScriptConfiguration customScriptConfiguration;
                List<String> acrValuesList = this.sessionIdService.acrValuesList(this.acrValues);
                if (acrValuesList.isEmpty()) {
                    acrValuesList = Arrays.asList(this.defaultAuthenticationMode.getName());
                }
                if ((customScriptConfiguration = this.externalAuthenticationService.determineCustomScriptConfiguration(AuthenticationScriptUsageType.INTERACTIVE, acrValuesList)) == null) {
                    this.log.error("Failed to get CustomScriptConfiguration. auth_step: {}, acr_values: {}", (Object)1, (Object)this.acrValues);
                    this.permissionDenied();
                    return;
                }
                String acr = customScriptConfiguration.getName();
                requestParameterMap.put("acr", acr);
                requestParameterMap.put("auth_step", Integer.toString(1));
                String string = this.externalAuthenticationService.executeExternalGetPageForStep(customScriptConfiguration, 1);
                if (StringHelper.isNotEmpty((String)string)) {
                    this.log.trace("Redirect to person authentication login page: {}", (Object)string);
                    redirectTo = string;
                }
            }
            String remoteIp = this.networkService.getRemoteIp();
            requestParameterMap.put("remote_ip", remoteIp);
            SessionId unauthenticatedSession = this.sessionIdService.generateUnauthenticatedSessionId(null, new Date(), SessionIdState.UNAUTHENTICATED, requestParameterMap, false);
            unauthenticatedSession.setSessionAttributes(requestParameterMap);
            unauthenticatedSession.addPermission(this.clientId, false);
            if (session != null && session.getPermissionGrantedMap() != null && session.getPermissionGrantedMap().getPermissionGranted() != null) {
                for (Map.Entry entry : session.getPermissionGrantedMap().getPermissionGranted().entrySet()) {
                    unauthenticatedSession.addPermission((String)entry.getKey(), (Boolean)entry.getValue());
                }
                this.sessionIdService.remove(session);
            }
            if ((persisted = this.sessionIdService.persistSessionId(unauthenticatedSession, !prompts.contains(Prompt.NONE))) && this.log.isTraceEnabled()) {
                this.log.trace("Session '{}' persisted to LDAP", (Object)unauthenticatedSession.getId());
            }
            this.sessionId = unauthenticatedSession.getId();
            this.sessionIdService.createSessionIdCookie(this.sessionId, unauthenticatedSession.getSessionState(), unauthenticatedSession.getOPBrowserState(), false);
            this.sessionIdService.creatRpOriginIdCookie(this.redirectUri);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (requestParameterMap.containsKey("login_hint")) {
                hashMap.put("login_hint", requestParameterMap.get("login_hint"));
            }
            this.facesService.redirectWithExternal(redirectTo, hashMap);
            return;
        }
        if (org.apache.commons.lang.StringUtils.isBlank((String)this.redirectionUriService.validateRedirectionUri(this.clientId, this.redirectUri))) {
            ExternalContext externalContext = this.facesContext.getExternalContext();
            externalContext.setResponseStatus(400);
            externalContext.setResponseContentType("application/json");
            externalContext.getResponseOutputWriter().write(this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_REDIRECT_URI, this.state, ""));
            this.facesContext.responseComplete();
        }
        User user = this.sessionIdService.getUser(session);
        this.log.trace("checkPermissionGranted, user = " + user);
        if (AuthorizeParamsValidator.noNonePrompt(prompts)) {
            if (this.appConfiguration.getTrustedClientEnabled().booleanValue() && client.getTrustedClient() && !prompts.contains(Prompt.CONSENT)) {
                this.permissionGranted(session);
                return;
            }
            if (ServerUtil.isTrue(this.appConfiguration.getSkipAuthorizationForOpenIdScopeAndPairwiseId()) && SubjectType.PAIRWISE.toString().equals(client.getSubjectType()) && this.hasOnlyOpenidScope()) {
                this.permissionGranted(session);
                return;
            }
            ClientAuthorization clientAuthorization = this.clientAuthorizationsService.find(user.getAttribute("inum"), client.getClientId(), client.getPersistClientAuthorizations());
            if (clientAuthorization != null && clientAuthorization.getScopes() != null && Arrays.asList(clientAuthorization.getScopes()).containsAll(StringUtils.spaceSeparatedToList((String)this.scope))) {
                this.permissionGranted(session);
                return;
            }
        } else {
            this.invalidRequest();
        }
        if (this.externalConsentGatheringService.isEnabled()) {
            if (this.consentGatherer.isConsentGathered()) {
                this.log.trace("Consent-gathered flow passed successfully");
                this.permissionGranted(session);
                return;
            }
            this.log.trace("Starting external consent-gathering flow");
            boolean result = this.consentGatherer.configure(session.getUserDn(), this.clientId, this.state);
            if (!result) {
                this.log.error("Failed to initialize external consent-gathering flow.");
                this.permissionDenied();
                return;
            }
        }
    }

    private SessionId handleAcrChange(SessionId session, List<Prompt> prompts) {
        if (session != null && session.getState() == SessionIdState.AUTHENTICATED) {
            if (!prompts.contains(Prompt.LOGIN)) {
                prompts.add(Prompt.LOGIN);
            }
            session.getSessionAttributes().put("prompt", StringUtils.implode(prompts, (String)" "));
            session.setState(SessionIdState.UNAUTHENTICATED);
            String remoteIp = this.networkService.getRemoteIp();
            session.getSessionAttributes().put("remote_ip", remoteIp);
            this.sessionIdService.updateSessionId(session);
            this.sessionIdService.reinitLogin(session, false);
        }
        return session;
    }

    private SessionId getSession() {
        return this.authorizeService.getSession(this.sessionId);
    }

    public List<Scope> getScopes() {
        return this.authorizeService.getScopes(this.allowedScope);
    }

    public List<String> getRequestedClaims() {
        HashSet<String> result = new HashSet<String>();
        String requestJwt = this.request;
        if (org.apache.commons.lang.StringUtils.isBlank((String)requestJwt) && org.apache.commons.lang.StringUtils.isNotBlank((String)this.requestUri)) {
            try {
                URI reqUri = new URI(this.requestUri);
                String reqUriHash = reqUri.getFragment();
                String reqUriWithoutFragment = reqUri.getScheme() + ":" + reqUri.getSchemeSpecificPart();
                ClientRequest clientRequest = new ClientRequest(reqUriWithoutFragment);
                clientRequest.setHttpMethod("GET");
                ClientResponse clientResponse = clientRequest.get(String.class);
                int status = clientResponse.getStatus();
                if (status == 200) {
                    String entity = (String)clientResponse.getEntity(String.class);
                    if (org.apache.commons.lang.StringUtils.isBlank((String)reqUriHash)) {
                        requestJwt = entity;
                    } else {
                        String hash = Base64Util.base64urlencode((byte[])JwtUtil.getMessageDigestSHA256((String)entity));
                        if (org.apache.commons.lang.StringUtils.equals((String)reqUriHash, (String)hash)) {
                            requestJwt = entity;
                        }
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (URISyntaxException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (NoSuchProviderException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)requestJwt)) {
            try {
                Client client = this.clientService.getClient(this.clientId);
                if (client != null) {
                    JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(this.appConfiguration, this.cryptoProvider, this.request, client);
                    if (jwtAuthorizationRequest.getUserInfoMember() != null) {
                        for (Claim claim : jwtAuthorizationRequest.getUserInfoMember().getClaims()) {
                            result.add(claim.getName());
                        }
                    }
                    if (jwtAuthorizationRequest.getIdTokenMember() != null) {
                        for (Claim claim : jwtAuthorizationRequest.getIdTokenMember().getClaims()) {
                            result.add(claim.getName());
                        }
                    }
                }
            }
            catch (EntryPersistenceException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (InvalidJwtException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (InvalidJweException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<String>(result);
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(String responseMode) {
        this.responseMode = responseMode;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public String getUiLocales() {
        return this.uiLocales;
    }

    public void setUiLocales(String uiLocales) {
        this.uiLocales = uiLocales;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = loginHint;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    public String getAmrValues() {
        return this.amrValues;
    }

    public void setAmrValues(String amrValues) {
        this.amrValues = amrValues;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String p_sessionId) {
        this.sessionId = p_sessionId;
    }

    public void permissionGranted() {
        SessionId session = this.getSession();
        this.permissionGranted(session);
    }

    public void permissionGranted(SessionId session) {
        HttpServletRequest httpRequest = (HttpServletRequest)this.externalContext.getRequest();
        this.authorizeService.permissionGranted(httpRequest, session);
    }

    public void permissionDenied() {
        SessionId session = this.getSession();
        this.authorizeService.permissionDenied(session);
    }

    private void authenticationFailedSessionInvalid() {
        this.facesMessages.add(FacesMessage.SEVERITY_ERROR, "login.errorSessionInvalidMessage");
        this.facesService.redirect("/error.xhtml");
    }

    public void invalidRequest() {
        this.log.trace("invalidRequest");
        StringBuilder sb = new StringBuilder();
        sb.append(this.redirectUri);
        if (this.redirectUri != null && this.redirectUri.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, this.getState()));
        this.facesService.redirectToExternalURL(sb.toString());
    }

    public void consentRequired() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.redirectUri);
        if (this.redirectUri != null && this.redirectUri.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.CONSENT_REQUIRED, this.getState()));
        this.facesService.redirectToExternalURL(sb.toString());
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getClaims() {
        return this.claims;
    }

    public void setClaims(String claims) {
        this.claims = claims;
    }

    public String getAuthReqId() {
        return this.authReqId;
    }

    public void setAuthReqId(String authReqId) {
        this.authReqId = authReqId;
    }

    public String getBindingMessage() {
        CIBAGrant cibaGrant;
        String bindingMessage = null;
        if (Strings.isNotBlank((String)this.getAuthReqId()) && (cibaGrant = this.authorizationGrantList.getCIBAGrant(this.authReqId)) != null) {
            bindingMessage = cibaGrant.getBindingMessage();
        }
        return bindingMessage;
    }

    public String encodeParameters(String url, Map<String, Object> parameters) {
        if (parameters.isEmpty()) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        for (Map.Entry<String, Object> param : parameters.entrySet()) {
            String parameterName = param.getKey();
            if (this.containsParameter(url, parameterName)) continue;
            Object parameterValue = param.getValue();
            if (parameterValue instanceof Iterable) {
                for (Object value : (Iterable)parameterValue) {
                    builder.append('&').append(parameterName).append('=');
                    if (value == null) continue;
                    builder.append(this.encode(value));
                }
                continue;
            }
            builder.append('&').append(parameterName).append('=');
            if (parameterValue == null) continue;
            builder.append(this.encode(parameterValue));
        }
        if (url.indexOf(63) < 0) {
            builder.setCharAt(url.length(), '?');
        }
        return builder.toString();
    }

    private boolean containsParameter(String url, String parameterName) {
        return url.indexOf('?' + parameterName + '=') > 0 || url.indexOf('&' + parameterName + '=') > 0;
    }

    private String encode(Object value) {
        try {
            return URLEncoder.encode(String.valueOf(value), "UTF-8");
        }
        catch (UnsupportedEncodingException iee) {
            throw new RuntimeException(iee);
        }
    }

    private boolean hasOnlyOpenidScope() {
        return this.getScopes() != null && this.getScopes().size() == 1 && this.getScopes().get(0).getId().equals("openid");
    }

    protected void handleSessionInvalid() {
        this.errorHandlerService.handleError("login.errorSessionInvalidMessage", (IErrorType)AuthorizeErrorResponseType.AUTHENTICATION_SESSION_INVALID, "Create authorization request to start new authentication session.");
    }

    protected void handleScriptError(String facesMessageId) {
        this.errorHandlerService.handleError("login.failedToAuthenticate", (IErrorType)AuthorizeErrorResponseType.INVALID_AUTHENTICATION_METHOD, "Contact administrator to fix specific ACR method issue.");
    }
}

