/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.client.AuthorizationRequest;
import org.gluu.oxauth.client.QueryStringDecoder;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.client.TokenRequest;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.register.ApplicationType;
import org.gluu.oxauth.model.register.RegisterRequestParam;
import org.gluu.oxauth.model.register.RegisterResponseParam;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.util.ServerUtil;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class ResponseTypesRestrictionEmbeddedTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static String clientId1;
    private static String clientSecret1;
    private static String registrationAccessToken1;
    private static String registrationClientUri1;
    private static String authorizationCode1;
    private static String clientId2;
    private static String clientSecret2;
    private static String registrationAccessToken2;
    private static String registrationClientUri2;
    private static String authorizationCode2;
    private static String clientId3;
    private static String registrationAccessToken3;
    private static String registrationClientUri3;

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void omittedResponseTypesStep1(String registerPath, String redirectUris) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        ResponseTypesRestrictionEmbeddedTest.showResponse("omittedResponseTypesStep1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId1 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret1 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
            registrationAccessToken1 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
            registrationClientUri1 = jsonObj.getString(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath"})
    @Test(dependsOnMethods={"omittedResponseTypesStep1"})
    public void omittedResponseTypesStep2(String registerPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath + "?" + registrationClientUri1.substring(registrationClientUri1.indexOf("?") + 1)).request();
        request.header("Authorization", (Object)("Bearer " + registrationAccessToken1));
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        ResponseTypesRestrictionEmbeddedTest.showResponse("omittedResponseTypesStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.RESPONSE_TYPES.toString()));
            Assert.assertNotNull((Object)jsonObj.optJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()));
            Assert.assertEquals((String)jsonObj.getJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()).getString(0), (String)ResponseType.CODE.toString());
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.REDIRECT_URIS.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.APPLICATION_TYPE.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.CLIENT_NAME.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.SCOPE.toString()));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"omittedResponseTypesStep2"})
    public void omittedResponseTypesStep3a(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        ResponseTypesRestrictionEmbeddedTest.showResponse("omittedResponseTypesStep3a", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        if (response.getLocation() != null) {
            try {
                URI uri = new URI(response.getLocation().toString());
                Assert.assertNotNull((Object)uri.getQuery(), (String)"The query string is null");
                Map params = QueryStringDecoder.decode((String)uri.getQuery());
                Assert.assertNotNull(params.get("code"), (String)"The code is null");
                Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                Assert.assertNotNull(params.get("state"), (String)"The state is null");
                Assert.assertFalse((boolean)params.containsKey("id_token"));
                Assert.assertFalse((boolean)params.containsKey("access_token"));
                authorizationCode1 = (String)params.get("code");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                Assert.fail((String)"Response URI is not well formed");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @Parameters(value={"tokenPath", "redirectUri"})
    @Test(dependsOnMethods={"omittedResponseTypesStep3a"})
    public void omittedResponseTypesStep3b(String tokenPath, String redirectUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode1);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId1);
        tokenRequest.setAuthPassword(clientSecret1);
        request.header("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        ResponseTypesRestrictionEmbeddedTest.showResponse("omittedResponseTypesStep3b", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
            Assert.assertTrue((boolean)jsonObj.has("id_token"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @DataProvider(name="omittedResponseTypesStep4DataProvider")
    public Object[][] omittedResponseTypesStep4DataProvider(ITestContext context) {
        String authorizePath = context.getCurrentXmlTest().getParameter("authorizePath");
        String userId = context.getCurrentXmlTest().getParameter("userId");
        String userSecret = context.getCurrentXmlTest().getParameter("userSecret");
        String redirectUri = context.getCurrentXmlTest().getParameter("redirectUri");
        return new Object[][]{{authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.ID_TOKEN)}};
    }

    @Test(dependsOnMethods={"omittedResponseTypesStep3b"}, dataProvider="omittedResponseTypesStep4DataProvider")
    public void omittedResponseTypesStep4(String authorizePath, String userId, String userSecret, String redirectUri, List<ResponseType> responseTypes) throws Exception {
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, nonce);
        authorizationRequest.setState("af0ifjsldkj");
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        ResponseTypesRestrictionEmbeddedTest.showResponse("omittedResponseTypesStep4", response, entity);
        if (response.getStatus() == 400) {
            Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
            try {
                JSONObject jsonObj = new JSONObject(entity);
                Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
            }
            catch (JSONException e) {
                e.printStackTrace();
                Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
            }
        } else {
            Assert.fail((String)("Unexpected response code: " + response.getStatus()));
        }
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void responseTypesCodeIdTokenStep1(String registerPath, String redirectUris) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        ResponseTypesRestrictionEmbeddedTest.showResponse("responseTypesCodeIdTokenStep1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId2 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret2 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
            registrationAccessToken2 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
            registrationClientUri2 = jsonObj.getString(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath"})
    @Test(dependsOnMethods={"responseTypesCodeIdTokenStep1"})
    public void responseTypesCodeIdTokenStep2(String registerPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath + "?" + registrationClientUri2.substring(registrationClientUri2.indexOf("?") + 1)).request();
        request.header("Authorization", (Object)("Bearer " + registrationAccessToken2));
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        ResponseTypesRestrictionEmbeddedTest.showResponse("responseTypesCodeIdTokenStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.RESPONSE_TYPES.toString()));
            Assert.assertNotNull((Object)jsonObj.optJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()));
            HashSet<String> responseTypes = new HashSet<String>();
            for (int i = 0; i < jsonObj.getJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()).length(); ++i) {
                responseTypes.add(jsonObj.getJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()).getString(i));
            }
            Assert.assertTrue((boolean)responseTypes.containsAll(Arrays.asList(ResponseType.CODE.toString(), ResponseType.ID_TOKEN.toString())));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.REDIRECT_URIS.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.APPLICATION_TYPE.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.CLIENT_NAME.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.SCOPE.toString()));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"responseTypesCodeIdTokenStep2"})
    public void responseTypesCodeIdTokenStep3a(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId2, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        ResponseTypesRestrictionEmbeddedTest.showResponse("responseTypesCodeIdTokenStep3a", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        if (response.getLocation() != null) {
            try {
                URI uri = new URI(response.getLocation().toString());
                Assert.assertNotNull((Object)uri.getFragment(), (String)"The fragment is null");
                Map params = QueryStringDecoder.decode((String)uri.getFragment());
                Assert.assertTrue((boolean)params.containsKey("code"));
                Assert.assertTrue((boolean)params.containsKey("scope"));
                Assert.assertTrue((boolean)params.containsKey("state"));
                Assert.assertTrue((boolean)params.containsKey("id_token"));
                Assert.assertFalse((boolean)params.containsKey("access_token"));
                authorizationCode2 = (String)params.get("code");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                Assert.fail((String)"Response URI is not well formed");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @Parameters(value={"tokenPath", "redirectUri"})
    @Test(dependsOnMethods={"responseTypesCodeIdTokenStep3a"})
    public void responseTypesCodeIdTokenStep3b(String tokenPath, String redirectUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode2);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId2);
        tokenRequest.setAuthPassword(clientSecret2);
        request.header("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        ResponseTypesRestrictionEmbeddedTest.showResponse("responseTypesCodeIdTokenStep3b", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
            Assert.assertTrue((boolean)jsonObj.has("id_token"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @DataProvider(name="responseTypesCodeIdTokenStep4DataProvider")
    public Object[][] responseTypesCodeIdTokenStep4DataProvider(ITestContext context) {
        String authorizePath = context.getCurrentXmlTest().getParameter("authorizePath");
        String userId = context.getCurrentXmlTest().getParameter("userId");
        String userSecret = context.getCurrentXmlTest().getParameter("userSecret");
        String redirectUri = context.getCurrentXmlTest().getParameter("redirectUri");
        return new Object[][]{{authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.ID_TOKEN)}};
    }

    @Test(dependsOnMethods={"omittedResponseTypesStep3b"}, dataProvider="responseTypesCodeIdTokenStep4DataProvider")
    public void responseTypesCodeIdTokenStep4(String authorizePath, String userId, String userSecret, String redirectUri, List<ResponseType> responseTypes) throws Exception {
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, nonce);
        authorizationRequest.setState("af0ifjsldkj");
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        ResponseTypesRestrictionEmbeddedTest.showResponse("responseTypesCodeIdTokenStep4", response, entity);
        if (response.getStatus() == 400) {
            Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
            try {
                JSONObject jsonObj = new JSONObject(entity);
                Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
            }
            catch (JSONException e) {
                e.printStackTrace();
                Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
            }
        } else {
            Assert.fail((String)("Unexpected response code: " + response.getStatus()));
        }
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void responseTypesTokenIdTokenStep1(String registerPath, String redirectUris) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        ResponseTypesRestrictionEmbeddedTest.showResponse("responseTypesTokenIdTokenStep1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId3 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            registrationAccessToken3 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
            registrationClientUri3 = jsonObj.getString(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath"})
    @Test(dependsOnMethods={"responseTypesTokenIdTokenStep1"})
    public void responseTypesTokenIdTokenStep2(String registerPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath + "?" + registrationClientUri3.substring(registrationClientUri3.indexOf("?") + 1)).request();
        request.header("Authorization", (Object)("Bearer " + registrationAccessToken3));
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        ResponseTypesRestrictionEmbeddedTest.showResponse("responseTypesTokenIdTokenStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.RESPONSE_TYPES.toString()));
            Assert.assertNotNull((Object)jsonObj.optJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()));
            HashSet<String> responseTypes = new HashSet<String>();
            for (int i = 0; i < jsonObj.getJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()).length(); ++i) {
                responseTypes.add(jsonObj.getJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()).getString(i));
            }
            Assert.assertTrue((boolean)responseTypes.containsAll(Arrays.asList(ResponseType.TOKEN.toString(), ResponseType.ID_TOKEN.toString())));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.REDIRECT_URIS.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.APPLICATION_TYPE.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.CLIENT_NAME.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.SCOPE.toString()));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"responseTypesTokenIdTokenStep2"})
    public void responseTypesTokenIdTokenStep3(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId3, scopes, redirectUri, nonce);
        authorizationRequest.setState("af0ifjsldkj");
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        ResponseTypesRestrictionEmbeddedTest.showResponse("responseTypesTokenIdTokenStep3", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        if (response.getLocation() != null) {
            try {
                URI uri = new URI(response.getLocation().toString());
                Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                Map params = QueryStringDecoder.decode((String)uri.getFragment());
                Assert.assertNotNull(params.get("access_token"), (String)"The access token is null");
                Assert.assertNotNull(params.get("token_type"), (String)"The token type is null");
                Assert.assertNotNull(params.get("id_token"), (String)"The id token is null");
                Assert.assertNotNull(params.get("state"), (String)"The state is null");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                Assert.fail((String)"Response URI is not well formed");
            }
        }
    }

    @DataProvider(name="responseTypesTokenIdTokenStep4DataProvider")
    public Object[][] responseTypesTokenIdTokenStep4DataProvider(ITestContext context) {
        String authorizePath = context.getCurrentXmlTest().getParameter("authorizePath");
        String userId = context.getCurrentXmlTest().getParameter("userId");
        String userSecret = context.getCurrentXmlTest().getParameter("userSecret");
        String redirectUri = context.getCurrentXmlTest().getParameter("redirectUri");
        return new Object[][]{{authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN)}};
    }

    @Test(dependsOnMethods={"responseTypesTokenIdTokenStep3"}, dataProvider="responseTypesTokenIdTokenStep4DataProvider")
    public void responseTypesTokenIdTokenStep4(String authorizePath, String userId, String userSecret, String redirectUri, List<ResponseType> responseTypes) throws Exception {
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId3, scopes, redirectUri, nonce);
        authorizationRequest.setState("af0ifjsldkj");
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        ResponseTypesRestrictionEmbeddedTest.showResponse("responseTypesTokenIdTokenStep4", response, entity);
        if (response.getStatus() == 400) {
            Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
            try {
                JSONObject jsonObj = new JSONObject(entity);
                Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
            }
            catch (JSONException e) {
                e.printStackTrace();
                Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
            }
        } else {
            Assert.fail((String)("Unexpected response code: " + response.getStatus()));
        }
    }
}

