/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.client.AuthorizationRequest;
import org.gluu.oxauth.client.QueryStringDecoder;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.client.model.authorize.Claim;
import org.gluu.oxauth.client.model.authorize.ClaimValue;
import org.gluu.oxauth.client.model.authorize.JwtAuthorizationRequest;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.OxAuthCryptoProvider;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.register.ApplicationType;
import org.gluu.oxauth.model.register.RegisterRequestParam;
import org.gluu.oxauth.model.register.RegisterResponseParam;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.util.ServerUtil;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class RequestObjectSigningAlgRestrictionEmbeddedTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static String clientId1;
    private static String clientSecret1;
    private static String registrationAccessToken1;
    private static String registrationClientUri1;
    private static String clientId2;
    private static String clientSecret2;
    private static String registrationAccessToken2;
    private static String registrationClientUri2;
    private static String clientId3;
    private static String clientSecret3;
    private static String registrationAccessToken3;
    private static String clientId4;
    private static String clientSecret4;
    private static String registrationAccessToken4;
    private static String clientId5;
    private static String clientSecret5;
    private static String registrationAccessToken5;
    private static String clientId6;
    private static String clientSecret6;
    private static String registrationAccessToken6;
    private static String clientId7;
    private static String clientSecret7;
    private static String registrationAccessToken7;
    private static String clientId8;
    private static String clientSecret8;
    private static String registrationAccessToken8;
    private static String clientId9;
    private static String clientSecret9;
    private static String registrationAccessToken9;
    private static String clientId10;
    private static String clientSecret10;
    private static String registrationAccessToken10;
    private static String clientId11;
    private static String clientSecret11;
    private static String registrationAccessToken11;

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void omittedRequestObjectSigningAlgStep1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("omittedRequestObjectSigningAlgStep1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId1 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret1 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
            registrationAccessToken1 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
            registrationClientUri1 = jsonObj.getString(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath"})
    @Test(dependsOnMethods={"omittedRequestObjectSigningAlgStep1"})
    public void omittedRequestObjectSigningAlgStep2(String registerPath) throws Exception {
        RegisterRequest registerRequest = new RegisterRequest(null);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath + "?" + registrationClientUri1.substring(registrationClientUri1.indexOf("?") + 1)).request();
        request.header("Authorization", (Object)("Bearer " + registrationAccessToken1));
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("omittedRequestObjectSigningAlgStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            Assert.assertFalse((boolean)jsonObj.has(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.APPLICATION_TYPE.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.RESPONSE_TYPES.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.REDIRECT_URIS.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.APPLICATION_TYPE.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.CLIENT_NAME.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.SCOPE.toString()));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"omittedRequestObjectSigningAlgStep2"})
    public void omittedRequestObjectSigningAlgStep3NONE(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        Invocation.Builder request = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.NONE, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("omittedRequestObjectSigningAlgStep3NONE", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("id_token"), (String)"The idToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"omittedRequestObjectSigningAlgStep2"})
    public void omittedRequestObjectSigningAlgStep3HS256(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        Invocation.Builder request = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret1, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("omittedRequestObjectSigningAlgStep3HS256", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("id_token"), (String)"The idToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"omittedRequestObjectSigningAlgStep2"})
    public void omittedRequestObjectSigningAlgStep3HS384(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        Invocation.Builder request = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS384, clientSecret1, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("omittedRequestObjectSigningAlgStep3HS384", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("id_token"), (String)"The idToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"omittedRequestObjectSigningAlgStep2"})
    public void omittedRequestObjectSigningAlgStep3HS512(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        Invocation.Builder request = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS512, clientSecret1, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("omittedRequestObjectSigningAlgStep3HS512", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("id_token"), (String)"The idToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"omittedRequestObjectSigningAlgStep2"})
    public void omittedRequestObjectSigningAlgStep3RS256(String authorizePath, String userId, String userSecret, String redirectUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = null;
        try {
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            List<String> scopes = Arrays.asList("openid");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.RS256, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("omittedRequestObjectSigningAlgStep3RS256", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "RS384_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"omittedRequestObjectSigningAlgStep2"})
    public void omittedRequestObjectSigningAlgStep3RS384(String authorizePath, String userId, String userSecret, String redirectUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = null;
        try {
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            List<String> scopes = Arrays.asList("openid");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.RS384, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("omittedRequestObjectSigningAlgStep3RS384", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "RS512_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"omittedRequestObjectSigningAlgStep2"})
    public void omittedRequestObjectSigningAlgStep3RS512(String authorizePath, String userId, String userSecret, String redirectUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = null;
        try {
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            List<String> scopes = Arrays.asList("openid");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.RS512, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("omittedRequestObjectSigningAlgStep3RS512", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"omittedRequestObjectSigningAlgStep2"})
    public void omittedRequestObjectSigningAlgStep3ES256(String authorizePath, String userId, String userSecret, String redirectUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = null;
        try {
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            List<String> scopes = Arrays.asList("openid");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.ES256, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("omittedRequestObjectSigningAlgStep3ES256", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "ES384_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"omittedRequestObjectSigningAlgStep2"})
    public void omittedRequestObjectSigningAlgStep3ES384(String authorizePath, String userId, String userSecret, String redirectUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = null;
        try {
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            List<String> scopes = Arrays.asList("openid");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.ES384, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("omittedRequestObjectSigningAlgStep3ES384", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "ES512_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"omittedRequestObjectSigningAlgStep2"})
    public void omittedRequestObjectSigningAlgStep3ES512(String authorizePath, String userId, String userSecret, String redirectUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = null;
        try {
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            List<String> scopes = Arrays.asList("openid");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.ES512, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("omittedRequestObjectSigningAlgStep3ES512", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestObjectSigningAlgNoneStep1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.NONE);
            registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("requestObjectSigningAlgNoneStep1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId2 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret2 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
            registrationAccessToken2 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
            registrationClientUri2 = jsonObj.getString(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath"})
    @Test(dependsOnMethods={"requestObjectSigningAlgNoneStep1"})
    public void requestObjectSigningAlgNoneStep2(String registerPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath + "?" + registrationClientUri2.substring(registrationClientUri2.indexOf("?") + 1)).request();
        request.header("Authorization", (Object)("Bearer " + registrationAccessToken2));
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("requestObjectSigningAlgNoneStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString()));
            Assert.assertEquals((Object)SignatureAlgorithm.fromString((String)jsonObj.getString(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString())), (Object)SignatureAlgorithm.NONE);
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.APPLICATION_TYPE.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.RESPONSE_TYPES.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.REDIRECT_URIS.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.APPLICATION_TYPE.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.CLIENT_NAME.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.SCOPE.toString()));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestObjectSigningAlgNoneStep2"})
    public void requestObjectSigningAlgNoneStep3(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        Invocation.Builder request = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId2, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.NONE, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("requestObjectSigningAlgNoneStep3", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("id_token"), (String)"The idToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestObjectSigningAlgHS256Step1(String registerPath, String redirectUris) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.HS256);
            registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("requestObjectSigningAlgHS256Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId3 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret3 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
            registrationAccessToken3 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestObjectSigningAlgHS384Step1(String registerPath, String redirectUris) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.HS384);
            registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("requestObjectSigningAlgHS384Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId4 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret4 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
            registrationAccessToken4 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestObjectSigningAlgHS512Step1(String registerPath, String redirectUris) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.HS512);
            registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("requestObjectSigningAlgHS512Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId5 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret5 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
            registrationAccessToken5 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestObjectSigningAlgRS256Step1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS256);
            registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("requestObjectSigningAlgRS256Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId6 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret6 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
            registrationAccessToken6 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestObjectSigningAlgRS384Step1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS384);
            registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("requestObjectSigningAlgRS384Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId7 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret7 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
            registrationAccessToken7 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestObjectSigningAlgRS512Step1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS512);
            registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("requestObjectSigningAlgRS512Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId8 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret8 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
            registrationAccessToken8 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestObjectSigningAlgES256Step1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.ES256);
            registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("requestObjectSigningAlgES256Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId9 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret9 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
            registrationAccessToken9 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestObjectSigningAlgES384Step1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.ES384);
            registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RequestObjectSigningAlgRestrictionEmbeddedTest.showResponse("requestObjectSigningAlgES256Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId10 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret10 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
            registrationAccessToken10 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }
}

