/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.client.RegisterResponse;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.common.SubjectType;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.register.ApplicationType;
import org.gluu.oxauth.model.register.RegisterRequestParam;
import org.gluu.oxauth.model.register.RegisterResponseParam;
import org.gluu.oxauth.model.uma.TestUtil;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.oxauth.ws.rs.ClientTestUtil;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class RegistrationRestWebServiceEmbeddedTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static String registrationAccessToken1;
    private static String registrationClientUri1;

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestClientAssociate1(String registerPath, String redirectUris) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setClaimsRedirectUris(StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RegistrationRestWebServiceEmbeddedTest.showResponse("requestClientAssociate1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            RegisterResponse registerResponse = RegisterResponse.valueOf((String)entity);
            ClientTestUtil.assert_((RegisterResponse)registerResponse);
            registrationAccessToken1 = registerResponse.getRegistrationAccessToken();
            registrationClientUri1 = registerResponse.getRegistrationClientUri();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "sectorIdentifierUri", "contactEmail1", "contactEmail2"})
    @Test
    public void requestClientAssociate2(String registerPath, String redirectUris, String sectorIdentifierUri, String contactEmail1, String contactEmail2) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            List<String> contacts = Arrays.asList(contactEmail1, contactEmail2);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setContacts(contacts);
            registerRequest.setScope(Arrays.asList("openid", "clientinfo", "profile", "email", "invalid_scope"));
            registerRequest.setLogoUri("http://www.gluu.org/wp-content/themes/gluursn/images/logo.png");
            registerRequest.setClientUri("http://www.gluu.org/company/team");
            registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
            registerRequest.setPolicyUri("http://www.gluu.org/policy");
            registerRequest.setJwksUri("http://www.gluu.org/jwks");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            registerRequest.setSubjectType(SubjectType.PAIRWISE);
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS256);
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RegistrationRestWebServiceEmbeddedTest.showResponse("requestClientAssociate2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            RegisterResponse registerResponse = RegisterResponse.valueOf((String)entity);
            ClientTestUtil.assert_((RegisterResponse)registerResponse);
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.SCOPE.toString()));
            JSONArray scopesJsonArray = new JSONArray((Collection)StringUtils.spaceSeparatedToList((String)jsonObj.getString(RegisterRequestParam.SCOPE.toString())));
            ArrayList<String> scopes = new ArrayList<String>();
            for (int i = 0; i < scopesJsonArray.length(); ++i) {
                scopes.add(scopesJsonArray.get(i).toString());
            }
            Assert.assertTrue((boolean)scopes.contains("openid"));
            Assert.assertTrue((boolean)scopes.contains("email"));
            Assert.assertTrue((boolean)scopes.contains("profile"));
            Assert.assertTrue((boolean)scopes.contains("clientinfo"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath"})
    @Test(dependsOnMethods={"requestClientAssociate1"})
    public void requestClientRead(String registerPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath + "?" + registrationClientUri1.substring(registrationClientUri1.indexOf("?") + 1)).request();
        request.header("Authorization", (Object)("Bearer " + registrationAccessToken1));
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        RegistrationRestWebServiceEmbeddedTest.showResponse("requestClientRead", response, entity);
        RegistrationRestWebServiceEmbeddedTest.readResponseAssert(response, entity);
    }

    public static void readResponseAssert(Response response, String entity) {
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.REDIRECT_URIS.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.CLAIMS_REDIRECT_URIS.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.APPLICATION_TYPE.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.CLIENT_NAME.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.SCOPE.toString()));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "contactEmail1", "contactEmail2"})
    @Test(dependsOnMethods={"requestClientAssociate1"})
    public void requestClientUpdate(String registerPath, String redirectUris, String contactEmail1, String contactEmail2) throws Exception {
        String contactEmailNewValue = contactEmail2;
        String logoUriNewValue = "http://www.gluu.org/test/yuriy/logo.png";
        String clientUriNewValue = "http://www.gluu.org/company/yuriy";
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath + "?" + registrationClientUri1.substring(registrationClientUri1.indexOf("?") + 1)).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setContacts(Arrays.asList(contactEmail1, contactEmailNewValue));
            registerRequest.setLogoUri("http://www.gluu.org/test/yuriy/logo.png");
            registerRequest.setClientUri("http://www.gluu.org/company/yuriy");
            request.header("Authorization", (Object)("Bearer " + registrationAccessToken1));
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        Response response = request.put(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RegistrationRestWebServiceEmbeddedTest.showResponse("requestClientRead", response, entity);
        RegistrationRestWebServiceEmbeddedTest.readResponseAssert(response, entity);
        try {
            RegisterRequest r = RegisterRequest.fromJson((String)entity, (boolean)true);
            Assert.assertTrue((r.getContacts() != null && r.getContacts().contains(contactEmailNewValue) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)r.getClientUri().equals("http://www.gluu.org/company/yuriy"));
            Assert.assertTrue((boolean)r.getLogoUri().equals("http://www.gluu.org/test/yuriy/logo.png"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath"})
    @Test
    public void requestClientRegistrationFail1(String registerPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(null, null, null);
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RegistrationRestWebServiceEmbeddedTest.showResponse("requestClientRegistrationFail 1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code. " + entity));
        TestUtil.assertErrorResponse((String)entity);
    }

    @Parameters(value={"registerPath"})
    @Test
    public void requestClientRegistrationFail2(String registerPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", null);
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RegistrationRestWebServiceEmbeddedTest.showResponse("requestClientRegistrationFail 2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code. " + entity));
        TestUtil.assertErrorResponse((String)entity);
    }

    @Parameters(value={"registerPath"})
    @Test
    public void requestClientRegistrationFail3(String registerPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", Arrays.asList("https://client.example.com/cb#fail_fragment"));
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        RegistrationRestWebServiceEmbeddedTest.showResponse("requestClientRegistrationFail3", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code. " + entity));
        TestUtil.assertErrorResponse((String)entity);
    }
}

