/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.client.AuthorizationRequest;
import org.gluu.oxauth.client.QueryStringDecoder;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.client.ResponseAsserter;
import org.gluu.oxauth.client.TokenRequest;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.register.ApplicationType;
import org.gluu.oxauth.model.register.RegisterResponseParam;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.util.ServerUtil;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class ClientAuthenticationFilterEmbeddedTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static String clientId;
    private static String authorizationCode1;
    private static String customAttrValue1;

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestClientRegistrationWithCustomAttributes(String registerPath, String redirectUris) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN);
            customAttrValue1 = UUID.randomUUID().toString();
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.addCustomAttribute("myCustomAttr1", customAttrValue1);
            List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
            registerRequest.setGrantTypes(grantTypes);
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        ClientAuthenticationFilterEmbeddedTest.showResponse("requestClientRegistrationWithCustomAttributes", response, entity);
        ResponseAsserter responseAsserter = ResponseAsserter.of((int)response.getStatus(), (String)entity);
        responseAsserter.assertRegisterResponse();
        clientId = responseAsserter.getJson().getJson().getString(RegisterResponseParam.CLIENT_ID.toString());
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestClientRegistrationWithCustomAttributes"})
    public void requestAccessTokenCustomClientAuth1Step1(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        String state = UUID.randomUUID().toString();
        String nonce = UUID.randomUUID().toString();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        ClientAuthenticationFilterEmbeddedTest.showResponse("requestAccessTokenCustomClientAuth1Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("code"), (String)"The code is null");
            Assert.assertNotNull(params.get("id_token"), (String)"The id token is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
            Assert.assertEquals((String)((String)params.get("state")), (String)state);
            authorizationCode1 = (String)params.get("code");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Parameters(value={"tokenPath", "redirectUri"})
    @Test(dependsOnMethods={"requestAccessTokenCustomClientAuth1Step1"})
    public void requestAccessTokenCustomClientAuth1Step2(String tokenPath, String redirectUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode1);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        tokenRequest.addCustomParameter("myCustomAttr1", customAttrValue1);
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        ClientAuthenticationFilterEmbeddedTest.showResponse("requestAccessTokenCustomClientAuth1Step2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
            Assert.assertTrue((boolean)jsonObj.has("id_token"), (String)"Unexpected result: id_token not found");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Parameters(value={"tokenPath", "userId", "userSecret"})
    @Test(dependsOnMethods={"requestClientRegistrationWithCustomAttributes"})
    public void requestAccessTokenCustomClientAuth2(String tokenPath, String userId, String userSecret) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setUsername(userId);
        tokenRequest.setPassword(userSecret);
        tokenRequest.setScope("profile email");
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        tokenRequest.addCustomParameter("myCustomAttr1", customAttrValue1);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        ClientAuthenticationFilterEmbeddedTest.showResponse("requestAccessTokenCustomClientAuth2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertTrue((!entity.equals(null) ? 1 : 0) != 0, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
            Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }
}

