/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.client.AuthorizationRequest;
import org.gluu.oxauth.client.QueryStringDecoder;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.client.RegisterResponse;
import org.gluu.oxauth.client.TokenRequest;
import org.gluu.oxauth.client.UserInfoRequest;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.register.ApplicationType;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.oxauth.ws.rs.ClientTestUtil;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class AuthorizationCodeFlowEmbeddedTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static String clientId;
    private static String clientSecret;
    private static String authorizationCode1;
    private static String authorizationCode2;
    private static String authorizationCode3;
    private static String authorizationCode4;
    private static String accessToken1;
    private static String refreshToken1;

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void dynamicClientRegistration(String registerPath, String redirectUris) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        AuthorizationCodeFlowEmbeddedTest.showResponse("dynamicClientRegistration", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            RegisterResponse registerResponse = RegisterResponse.valueOf((String)entity);
            ClientTestUtil.assert_((RegisterResponse)registerResponse);
            clientId = registerResponse.getClientId();
            clientSecret = registerResponse.getClientSecret();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void completeFlowStep1(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        String state = UUID.randomUUID().toString();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        AuthorizationCodeFlowEmbeddedTest.showResponse("completeFlowStep1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        if (response.getLocation() != null) {
            try {
                URI uri = new URI(response.getLocation().toString());
                Assert.assertNotNull((Object)uri.getQuery(), (String)"The query string is null");
                Map params = QueryStringDecoder.decode((String)uri.getQuery());
                Assert.assertNotNull(params.get("code"), (String)"The code is null");
                Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                Assert.assertNotNull(params.get("state"), (String)"The state is null");
                Assert.assertEquals((String)((String)params.get("state")), (String)state);
                authorizationCode1 = (String)params.get("code");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                Assert.fail((String)"Response URI is not well formed");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @Parameters(value={"tokenPath", "validateTokenPath", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration", "completeFlowStep1"})
    public void completeFlowStep2(String tokenPath, String validateTokenPath, String redirectUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode1);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        request.header("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        AuthorizationCodeFlowEmbeddedTest.showResponse("completeFlowStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
            Assert.assertTrue((boolean)jsonObj.has("id_token"), (String)"Unexpected result: id_token not found");
            String accessToken = jsonObj.getString("access_token");
            String refreshToken = jsonObj.getString("refresh_token");
            this.completeFlowStep3(tokenPath, refreshToken);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public void completeFlowStep3(String tokenPath, String refreshToken) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        TokenRequest tokenRequest = new TokenRequest(GrantType.REFRESH_TOKEN);
        tokenRequest.setRefreshToken(refreshToken);
        tokenRequest.setScope("email read_stream manage_pages");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        request.header("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        AuthorizationCodeFlowEmbeddedTest.showResponse("completeFlowStep3", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void completeFlowWithOptionalNonceStep1(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        String state = UUID.randomUUID().toString();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        AuthorizationCodeFlowEmbeddedTest.showResponse("completeFlowWithOptionalNonceStep1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        if (response.getLocation() != null) {
            try {
                URI uri = new URI(response.getLocation().toString());
                Assert.assertNotNull((Object)uri.getQuery(), (String)"The query string is null");
                Map params = QueryStringDecoder.decode((String)uri.getQuery());
                Assert.assertNotNull(params.get("code"), (String)"The code is null");
                Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                Assert.assertNotNull(params.get("state"), (String)"The state is null");
                Assert.assertEquals((String)((String)params.get("state")), (String)state);
                authorizationCode4 = (String)params.get("code");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                Assert.fail((String)"Response URI is not well formed");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @Parameters(value={"tokenPath", "validateTokenPath", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration", "completeFlowWithOptionalNonceStep1"})
    public void completeFlowWithOptionalNonceStep2(String tokenPath, String validateTokenPath, String redirectUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode4);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        request.header("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        AuthorizationCodeFlowEmbeddedTest.showResponse("completeFlowWithOptionalNonceStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
            Assert.assertTrue((boolean)jsonObj.has("id_token"), (String)"Unexpected result: id_token not found");
            String accessToken = jsonObj.getString("access_token");
            String refreshToken = jsonObj.getString("refresh_token");
            String idToken = jsonObj.getString("id_token");
            Jwt jwt = Jwt.parse((String)idToken);
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("nonce"));
            this.completeFlowWithOptionalNonceStep3(tokenPath, refreshToken);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public void completeFlowWithOptionalNonceStep3(String tokenPath, String refreshToken) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        TokenRequest tokenRequest = new TokenRequest(GrantType.REFRESH_TOKEN);
        tokenRequest.setRefreshToken(refreshToken);
        tokenRequest.setScope("email read_stream manage_pages");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        request.header("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        AuthorizationCodeFlowEmbeddedTest.showResponse("completeFlowWithOptionalNonceStep3", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void revokeTokensStep1(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        String state = UUID.randomUUID().toString();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.setState(state);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        AuthorizationCodeFlowEmbeddedTest.showResponse("revokeTokensStep1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        if (response.getLocation() != null) {
            try {
                URI uri = new URI(response.getLocation().toString());
                Assert.assertNotNull((Object)uri.getQuery(), (String)"The query string is null");
                Map params = QueryStringDecoder.decode((String)uri.getQuery());
                Assert.assertNotNull(params.get("code"), (String)"The code is null");
                Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                Assert.assertNotNull(params.get("state"), (String)"The state is null");
                Assert.assertEquals((String)((String)params.get("state")), (String)state);
                authorizationCode2 = (String)params.get("code");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                Assert.fail((String)"Response URI is not well formed");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @Parameters(value={"tokenPath", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration", "revokeTokensStep1"})
    public void revokeTokensStep2n3(String tokenPath, String redirectUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode2);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        request.header("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        AuthorizationCodeFlowEmbeddedTest.showResponse("revokeTokensStep2n3", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
            Assert.assertTrue((boolean)jsonObj.has("id_token"), (String)"Unexpected result: id_token not found");
            accessToken1 = jsonObj.getString("access_token");
            refreshToken1 = jsonObj.getString("refresh_token");
            Invocation.Builder request2 = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
            TokenRequest tokenRequest2 = new TokenRequest(GrantType.AUTHORIZATION_CODE);
            tokenRequest2.setCode(authorizationCode2);
            tokenRequest2.setRedirectUri(redirectUri);
            tokenRequest2.setAuthUsername(clientId);
            tokenRequest2.setAuthPassword(clientSecret);
            request2.header("Authorization", (Object)("Basic " + tokenRequest2.getEncodedCredentials()));
            Response response2 = request2.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest2.getParameters())));
            String entity2 = (String)response2.readEntity(String.class);
            AuthorizationCodeFlowEmbeddedTest.showResponse("revokeTokens step 3", response2, entity2);
            Assert.assertEquals((int)response2.getStatus(), (int)400, (String)"Unexpected response code.");
            Assert.assertNotNull((Object)entity2, (String)("Unexpected result: " + entity2));
            try {
                JSONObject jsonObj2 = new JSONObject(entity2);
                Assert.assertTrue((boolean)jsonObj2.has("error"), (String)"The error type is null");
                Assert.assertTrue((boolean)jsonObj2.has("error_description"), (String)"The error description is null");
            }
            catch (JSONException e) {
                e.printStackTrace();
                Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity2));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Parameters(value={"tokenPath"})
    @Test(dependsOnMethods={"dynamicClientRegistration", "revokeTokensStep2n3"})
    public void revokeTokensStep4(String tokenPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        TokenRequest tokenRequest = new TokenRequest(GrantType.REFRESH_TOKEN);
        tokenRequest.setRefreshToken(refreshToken1);
        tokenRequest.setScope("email read_stream manage_pages");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        request.header("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        AuthorizationCodeFlowEmbeddedTest.showResponse("revokeTokensStep4", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)401, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
            Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"revokeTokensStep4"})
    public void revokeTokensStep5(String userInfoPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + userInfoPath).request();
        request.header("Authorization", (Object)("Bearer " + accessToken1));
        UserInfoRequest userInfoRequest = new UserInfoRequest(null);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(userInfoRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        AuthorizationCodeFlowEmbeddedTest.showResponse("revokeTokensStep5", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)401, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
            Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void tokenExpirationStep1(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        String state = UUID.randomUUID().toString();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.setState(state);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        AuthorizationCodeFlowEmbeddedTest.showResponse("tokenExpirationStep1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        if (response.getLocation() != null) {
            try {
                URI uri = new URI(response.getLocation().toString());
                Assert.assertNotNull((Object)uri.getQuery(), (String)"The query string is null");
                Map params = QueryStringDecoder.decode((String)uri.getQuery());
                Assert.assertNotNull(params.get("code"), (String)"The code is null");
                Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                Assert.assertNotNull(params.get("state"), (String)"The state is null");
                Assert.assertEquals((String)((String)params.get("state")), (String)state);
                authorizationCode3 = (String)params.get("code");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                Assert.fail((String)"Response URI is not well formed");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @Parameters(value={"tokenPath", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration", "tokenExpirationStep1"})
    public void tokenExpirationStep2(String tokenPath, String redirectUri) throws Exception {
        System.out.println("Sleeping for 20 seconds .....");
        Thread.sleep(20000L);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode3);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        request.header("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        AuthorizationCodeFlowEmbeddedTest.showResponse("tokenExpirationStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
            Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }
}

