/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.comp;

import java.util.Date;
import java.util.HashMap;
import javax.inject.Inject;
import org.gluu.oxauth.BaseComponentTest;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.SessionIdState;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.UserService;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class SessionIdServiceTest
extends BaseComponentTest {
    @Inject
    private SessionIdService m_service;
    @Inject
    private UserService userService;

    private SessionId generateSession(String userInum) {
        String userDn = this.userService.getDnForUser(userInum);
        return this.m_service.generateUnauthenticatedSessionId(userDn, new Date(), SessionIdState.UNAUTHENTICATED, new HashMap(), true);
    }

    @Parameters(value={"userInum"})
    @Test
    public void statePersistence(String userInum) {
        String userDn = this.userService.getDnForUser(userInum);
        SessionId newId = this.m_service.generateAuthenticatedSessionId(null, userDn);
        Assert.assertEquals((Object)newId.getState(), (Object)SessionIdState.AUTHENTICATED);
        HashMap<String, String> sessionAttributes = new HashMap<String, String>();
        sessionAttributes.put("k1", "v1");
        newId.setSessionAttributes(sessionAttributes);
        this.m_service.updateSessionId(newId);
        SessionId fresh = this.m_service.getSessionById(newId.getId());
        Assert.assertEquals((Object)fresh.getState(), (Object)SessionIdState.AUTHENTICATED);
        Assert.assertTrue((boolean)fresh.getSessionAttributes().containsKey("k1"));
        Assert.assertTrue((boolean)fresh.getSessionAttributes().containsValue("v1"));
    }

    @Parameters(value={"userInum"})
    @Test
    public void testUpdateLastUsedDate(String userInum) {
        SessionId m_sessionId = this.generateSession(userInum);
        SessionId fromLdap1 = this.m_service.getSessionById(m_sessionId.getId());
        Date createdDate = m_sessionId.getLastUsedAt();
        System.out.println("Created date = " + createdDate);
        Assert.assertEquals((Object)createdDate, (Object)fromLdap1.getLastUsedAt());
        SessionIdServiceTest.sleepSeconds(1);
        this.m_service.updateSessionId(m_sessionId);
        SessionId fromLdap2 = this.m_service.getSessionById(m_sessionId.getId());
        System.out.println("Updated date = " + fromLdap2.getLastUsedAt());
        Assert.assertTrue((boolean)createdDate.before(fromLdap2.getLastUsedAt()));
    }

    @Parameters(value={"userInum"})
    @Test
    public void testUpdateAttributes(String userInum) {
        SessionId m_sessionId = this.generateSession(userInum);
        String clientId = "testClientId";
        SessionId fromLdap1 = this.m_service.getSessionById(m_sessionId.getId());
        Date createdDate = m_sessionId.getLastUsedAt();
        Assert.assertEquals((Object)createdDate, (Object)fromLdap1.getLastUsedAt());
        Assert.assertFalse((boolean)fromLdap1.isPermissionGrantedForClient("testClientId"));
        SessionIdServiceTest.sleepSeconds(1);
        m_sessionId.setAuthenticationTime(new Date());
        m_sessionId.addPermission("testClientId", Boolean.valueOf(true));
        this.m_service.updateSessionId(m_sessionId);
        SessionId fromLdap2 = this.m_service.getSessionById(m_sessionId.getId());
        Assert.assertTrue((boolean)createdDate.before(fromLdap2.getLastUsedAt()));
        Assert.assertNotNull((Object)fromLdap2.getAuthenticationTime());
        Assert.assertTrue((boolean)fromLdap2.isPermissionGrantedForClient("testClientId"));
    }
}

