/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.comp;

import java.util.Date;
import java.util.UUID;
import javax.inject.Inject;
import org.gluu.oxauth.BaseComponentTest;
import org.gluu.oxauth.model.ldap.TokenLdap;
import org.gluu.oxauth.model.ldap.TokenType;
import org.gluu.oxauth.service.GrantService;
import org.gluu.oxauth.util.TokenHashUtil;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class GrantServiceTest
extends BaseComponentTest {
    private static final String TEST_TOKEN_CODE = UUID.randomUUID().toString();
    @Inject
    private GrantService grantService;
    private static String m_clientId;
    private static TokenLdap m_tokenLdap;

    @Parameters(value={"clientId"})
    @Test
    public void createTestToken(String clientId) {
        m_clientId = clientId;
        m_tokenLdap = this.createTestToken();
        this.grantService.persist(m_tokenLdap);
    }

    @Test(dependsOnMethods={"createTestToken"})
    public void removeTestTokens() {
        TokenLdap t = this.grantService.getGrantByCode(TEST_TOKEN_CODE);
        if (t != null) {
            this.grantService.remove(t);
        }
    }

    private TokenLdap createTestToken() {
        String grantId = GrantService.generateGrantId();
        String dn = this.grantService.buildDn(TokenHashUtil.hash((String)TEST_TOKEN_CODE));
        TokenLdap t = new TokenLdap();
        t.setDn(dn);
        t.setGrantId(grantId);
        t.setClientId(m_clientId);
        t.setTokenCode(TokenHashUtil.hash((String)TEST_TOKEN_CODE));
        t.setTokenType(TokenType.ACCESS_TOKEN.getValue());
        t.setCreationDate(new Date());
        t.setExpirationDate(new Date());
        return t;
    }
}

