/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.comp;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.gluu.oxauth.ConfigurableTest;
import org.gluu.oxauth.model.config.Conf;
import org.gluu.oxauth.model.config.ConfigurationFactory;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.config.WebKeysConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorMessages;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.PersistenceEntryManager;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigurationTest
extends ConfigurableTest {
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private PersistenceEntryManager ldapEntryManager;

    @Test
    public void configurationPresence() {
        Assert.assertTrue((this.configurationFactory != null && this.configurationFactory.getBaseConfiguration() != null && this.configurationFactory.getPersistenceConfiguration().getConfiguration() != null && this.configurationFactory.getAppConfiguration() != null && this.configurationFactory.getErrorResponseFactory() != null && this.configurationFactory.getStaticConfiguration() != null && this.configurationFactory.getWebKeysConfiguration() != null ? 1 : 0) != 0);
    }

    public void createLatestTestConfInLdapFromFiles() throws Exception {
        String prefix = "U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf";
        String errorsFile = "U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-errors.json";
        String staticFile = "U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-static-conf.json";
        String webKeysFile = "U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-web-keys.json";
        String configFile = "U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-config.xml";
        String errorsJson = IOUtils.toString((InputStream)new FileInputStream("U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-errors.json"));
        String staticConfJson = IOUtils.toString((InputStream)new FileInputStream("U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-static-conf.json"));
        String webKeysJson = IOUtils.toString((InputStream)new FileInputStream("U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-web-keys.json"));
        StaticConfiguration staticConf = (StaticConfiguration)ServerUtil.createJsonMapper().readValue(staticConfJson, StaticConfiguration.class);
        ErrorMessages errorConf = (ErrorMessages)ServerUtil.createJsonMapper().readValue(errorsJson, ErrorMessages.class);
        WebKeysConfiguration webKeys = (WebKeysConfiguration)ServerUtil.createJsonMapper().readValue(webKeysJson, WebKeysConfiguration.class);
        AppConfiguration configJson = ConfigurationTest.loadConfFromFile("U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-config.xml");
        Conf c = new Conf();
        c.setDn("ou=testconfiguration,o=gluu");
        c.setDynamic(configJson);
        c.setErrors(errorConf);
        c.setStatics(staticConf);
        c.setWebKeys(webKeys);
        this.ldapEntryManager.persist((Object)c);
    }

    private static AppConfiguration loadConfFromFile(String p_filePath) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{AppConfiguration.class});
        Unmarshaller u = jc.createUnmarshaller();
        return (AppConfiguration)u.unmarshal(new File(p_filePath));
    }
}

