/*
 * Decompiled with CFR 0.152.
 */
package org.oxauth.persistence.model;

import java.io.Serializable;
import java.util.List;
import org.gluu.oxauth.model.common.ScopeType;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.JsonObject;
import org.gluu.persist.annotation.ObjectClass;
import org.gluu.persist.model.base.DeletableEntity;
import org.oxauth.persistence.model.ScopeAttributes;

@DataEntry
@ObjectClass(value="oxAuthCustomScope")
public class Scope
extends DeletableEntity
implements Serializable {
    private static final long serialVersionUID = 4308826784917052508L;
    @AttributeName(ignoreDuringUpdate=true)
    private String inum;
    @AttributeName
    private String displayName;
    @AttributeName(name="oxId", consistency=true)
    private String id;
    @AttributeName(name="oxIconUrl")
    private String iconUrl;
    @AttributeName
    private String description;
    @AttributeName(name="oxScopeType")
    private ScopeType scopeType;
    @AttributeName(name="oxAuthClaim")
    private List<String> oxAuthClaims;
    @AttributeName(name="defaultScope")
    private Boolean defaultScope;
    @AttributeName(name="oxAuthGroupClaims")
    private Boolean oxAuthGroupClaims;
    @AttributeName(name="oxScriptDn")
    private List<String> dynamicScopeScripts;
    @AttributeName(name="oxUmaPolicyScriptDn")
    private List<String> umaAuthorizationPolicies;
    @AttributeName(name="oxAttributes")
    @JsonObject
    private ScopeAttributes attributes;

    public ScopeAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ScopeAttributes();
        }
        return this.attributes;
    }

    public void setAttributes(ScopeAttributes attributes) {
        this.attributes = attributes;
    }

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ScopeType getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(ScopeType scopeType) {
        this.scopeType = scopeType;
    }

    public List<String> getOxAuthClaims() {
        return this.oxAuthClaims;
    }

    public void setOxAuthClaims(List<String> oxAuthClaims) {
        this.oxAuthClaims = oxAuthClaims;
    }

    public Boolean isDefaultScope() {
        return this.defaultScope;
    }

    public void setDefaultScope(Boolean defaultScope) {
        this.defaultScope = defaultScope;
    }

    public Boolean isOxAuthGroupClaims() {
        return this.oxAuthGroupClaims;
    }

    public void setOxAuthGroupClaims(boolean oxAuthGroupClaims) {
        this.oxAuthGroupClaims = oxAuthGroupClaims;
    }

    public List<String> getDynamicScopeScripts() {
        return this.dynamicScopeScripts;
    }

    public void setDynamicScopeScripts(List<String> dynamicScopeScripts) {
        this.dynamicScopeScripts = dynamicScopeScripts;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public List<String> getUmaAuthorizationPolicies() {
        return this.umaAuthorizationPolicies;
    }

    public void setUmaAuthorizationPolicies(List<String> umaAuthorizationPolicies) {
        this.umaAuthorizationPolicies = umaAuthorizationPolicies;
    }

    public Boolean getOxAuthGroupClaims() {
        return this.oxAuthGroupClaims;
    }

    public Boolean getDefaultScope() {
        return this.defaultScope;
    }

    public boolean isUmaType() {
        return this.scopeType != null && ScopeType.UMA.getValue().equalsIgnoreCase(this.scopeType.getValue());
    }

    public String toString() {
        return "Scope{dn='" + this.getDn() + '\'' + ", inum='" + this.inum + '\'' + ", displayName='" + this.displayName + '\'' + ", id='" + this.id + '\'' + ", iconUrl='" + this.iconUrl + '\'' + ", description='" + this.description + '\'' + ", scopeType=" + this.scopeType + ", oxAuthClaims=" + this.oxAuthClaims + ", defaultScope=" + this.defaultScope + ", oxAuthGroupClaims=" + this.oxAuthGroupClaims + ", dynamicScopeScripts=" + this.dynamicScopeScripts + ", umaAuthorizationPolicies=" + this.umaAuthorizationPolicies + ", deletable=" + this.isDeletable() + ", expirationDate=" + this.getExpirationDate() + ", attributes=" + this.attributes + '}';
    }
}

