/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.gluu.oxauth.fido2.client.AssertionService;
import org.gluu.oxauth.fido2.client.AttestationService;
import org.gluu.oxauth.fido2.client.ConfigurationService;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;

public class Fido2ClientFactory {
    private static final Fido2ClientFactory instance = new Fido2ClientFactory();
    private ApacheHttpClient4Engine engine = this.createEngine();
    private ObjectMapper objectMapper = new ObjectMapper();

    private Fido2ClientFactory() {
    }

    public static Fido2ClientFactory instance() {
        return instance;
    }

    public ConfigurationService createMetaDataConfigurationService(String metadataUri) {
        ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)this.engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)metadataUri));
        ConfigurationService proxy = (ConfigurationService)target.proxy(ConfigurationService.class);
        return proxy;
    }

    public AttestationService createAttestationService(String metadata) throws IOException {
        JsonNode metadataJson = this.objectMapper.readTree(metadata);
        String basePath = metadataJson.get("attestation").get("base_path").asText();
        ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)this.engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)basePath));
        AttestationService proxy = (AttestationService)target.proxy(AttestationService.class);
        return proxy;
    }

    public AssertionService createAssertionService(String metadata) throws IOException {
        JsonNode metadataJson = this.objectMapper.readTree(metadata);
        String basePath = metadataJson.get("assertion").get("base_path").asText();
        ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)this.engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)basePath));
        AssertionService proxy = (AssertionService)target.proxy(AssertionService.class);
        return proxy;
    }

    private ApacheHttpClient4Engine createEngine() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)cm).build();
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(20);
        ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine((HttpClient)httpClient);
        engine.setFollowRedirects(true);
        return engine;
    }
}

