/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.cert.validation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.gluu.oxauth.cert.validation.CertificateVerifier;
import org.gluu.oxauth.cert.validation.model.ValidationStatus;
import org.gluu.util.security.SecurityProviderUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPCertificateVerifier
implements CertificateVerifier {
    private static final Logger log = LoggerFactory.getLogger(OCSPCertificateVerifier.class);

    public OCSPCertificateVerifier() {
        SecurityProviderUtility.installBCProvider((boolean)true);
    }

    @Override
    public ValidationStatus validate(X509Certificate certificate, List<X509Certificate> issuers, Date validationDate) {
        X509Certificate issuer = issuers.get(0);
        ValidationStatus status = new ValidationStatus(certificate, issuer, validationDate, ValidationStatus.ValidatorSourceType.OCSP, ValidationStatus.CertificateValidity.UNKNOWN);
        try {
            SingleResp[] singleResps;
            X500Principal subjectX500Principal = certificate.getSubjectX500Principal();
            String ocspUrl = this.getOCSPUrl(certificate);
            if (ocspUrl == null) {
                log.error("OCSP URL for '" + subjectX500Principal + "' is empty");
                return status;
            }
            log.debug("OCSP URL for '" + subjectX500Principal + "' is '" + ocspUrl + "'");
            DigestCalculator digestCalculator = new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1);
            CertificateID certificateId = new CertificateID(digestCalculator, (X509CertificateHolder)new JcaX509CertificateHolder(certificate), certificate.getSerialNumber());
            OCSPReq ocspReq = this.generateOCSPRequest(certificateId);
            OCSPResp ocspResp = this.requestOCSPResponse(ocspUrl, ocspReq);
            if (ocspResp.getStatus() != 0) {
                log.error("OCSP response is invalid!");
                status.setValidity(ValidationStatus.CertificateValidity.INVALID);
                return status;
            }
            boolean foundResponse = false;
            BasicOCSPResp basicOCSPResp = (BasicOCSPResp)ocspResp.getResponseObject();
            for (SingleResp singleResp : singleResps = basicOCSPResp.getResponses()) {
                CertificateID responseCertificateId = singleResp.getCertID();
                if (!certificateId.equals((Object)responseCertificateId)) continue;
                foundResponse = true;
                log.debug("OCSP validationDate: " + validationDate);
                log.debug("OCSP thisUpdate: " + singleResp.getThisUpdate());
                log.debug("OCSP nextUpdate: " + singleResp.getNextUpdate());
                status.setRevocationObjectIssuingTime(basicOCSPResp.getProducedAt());
                CertificateStatus certStatus = singleResp.getCertStatus();
                if (certStatus == CertificateStatus.GOOD) {
                    log.debug("OCSP status is valid for '" + certificate.getSubjectX500Principal() + "'");
                    status.setValidity(ValidationStatus.CertificateValidity.VALID);
                    continue;
                }
                if (!(singleResp.getCertStatus() instanceof RevokedStatus)) continue;
                log.warn("OCSP status is revoked for: " + subjectX500Principal);
                if (validationDate.before(((RevokedStatus)singleResp.getCertStatus()).getRevocationTime())) {
                    log.warn("OCSP revocation time after the validation date, the certificate '" + subjectX500Principal + "' was valid at " + validationDate);
                    status.setValidity(ValidationStatus.CertificateValidity.VALID);
                    continue;
                }
                Date revocationDate = ((RevokedStatus)singleResp.getCertStatus()).getRevocationTime();
                log.info("OCSP for certificate '" + subjectX500Principal + "' is revoked since " + revocationDate);
                status.setRevocationDate(revocationDate);
                status.setRevocationObjectIssuingTime(singleResp.getThisUpdate());
                status.setValidity(ValidationStatus.CertificateValidity.REVOKED);
            }
            if (!foundResponse) {
                log.error("There is no matching OCSP response entries");
            }
        }
        catch (Exception ex) {
            log.error("OCSP exception: ", (Throwable)ex);
        }
        return status;
    }

    private OCSPReq generateOCSPRequest(CertificateID certificateId) throws OCSPException, OperatorCreationException, CertificateEncodingException {
        OCSPReqBuilder ocspReqGenerator = new OCSPReqBuilder();
        ocspReqGenerator.addRequest(certificateId);
        OCSPReq ocspReq = ocspReqGenerator.build();
        return ocspReq;
    }

    private String getOCSPUrl(X509Certificate certificate) throws IOException {
        AccessDescription[] accessDescriptions;
        ASN1Primitive obj;
        try {
            obj = OCSPCertificateVerifier.getExtensionValue(certificate, Extension.authorityInfoAccess.getId());
        }
        catch (IOException ex) {
            log.error("Failed to get OCSP URL", (Throwable)ex);
            return null;
        }
        if (obj == null) {
            return null;
        }
        AuthorityInformationAccess authorityInformationAccess = AuthorityInformationAccess.getInstance((Object)obj);
        for (AccessDescription accessDescription : accessDescriptions = authorityInformationAccess.getAccessDescriptions()) {
            GeneralName name;
            boolean correctAccessMethod = accessDescription.getAccessMethod().equals((ASN1Primitive)X509ObjectIdentifiers.ocspAccessMethod);
            if (!correctAccessMethod || (name = accessDescription.getAccessLocation()).getTagNo() != 6) continue;
            DERIA5String derStr = DERIA5String.getInstance((ASN1TaggedObject)((ASN1TaggedObject)name.toASN1Primitive()), (boolean)false);
            return derStr.getString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCSPResp requestOCSPResponse(String url, OCSPReq ocspReq) throws IOException, MalformedURLException {
        byte[] ocspReqData = ocspReq.getEncoded();
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
        try {
            OCSPResp ocspResp;
            con.setRequestProperty("Content-Type", "application/ocsp-request");
            con.setRequestProperty("Accept", "application/ocsp-response");
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            OutputStream out = con.getOutputStream();
            try {
                IOUtils.write((byte[])ocspReqData, (OutputStream)out);
                out.flush();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
            byte[] responseBytes = IOUtils.toByteArray((InputStream)con.getInputStream());
            OCSPResp oCSPResp = ocspResp = new OCSPResp(responseBytes);
            return oCSPResp;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    private static ASN1Primitive getExtensionValue(X509Certificate certificate, String oid) throws IOException {
        byte[] bytes = certificate.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(bytes));
        ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
        aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(octs.getOctets()));
        return aIn.readObject();
    }

    @Override
    public void destroy() {
    }
}

