/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.claims;

import com.google.common.collect.Lists;
import java.util.List;
import org.gluu.oxauth.claims.Audience;
import org.gluu.oxauth.model.jwt.JwtClaims;
import org.gluu.oxauth.model.registration.Client;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AudienceTest {
    @Test
    public void addAudience_callItTwiceWithSameValue_shouldResultInSingleAudValue() {
        JwtClaims claims = new JwtClaims();
        claims.addAudience("aud1");
        claims.addAudience("aud1");
        Assert.assertEquals((String)claims.getClaimAsString("aud"), (String)"aud1");
    }

    @Test
    public void addAudience_callItTwiceWithDifferentValues_shouldResultInSingleAudValue() {
        JwtClaims claims = new JwtClaims();
        claims.addAudience("aud1");
        claims.addAudience("aud2");
        Assert.assertEquals((Object)claims.getClaim("aud"), (Object)Lists.newArrayList((Object[])new String[]{"aud1", "aud2"}));
    }

    @Test
    public void setAudience_withAdditionalClaims_shouldResultInAdditionalClaimsPresentinAud() {
        JwtClaims claims = new JwtClaims();
        Client client = new Client();
        client.setClientId("clientId");
        client.getAttributes().setAdditionalAudience((List)Lists.newArrayList((Object[])new String[]{"aud1", "aud2"}));
        Audience.setAudience((JwtClaims)claims, (Client)client);
        Assert.assertEquals((Object)claims.getClaim("aud"), (Object)Lists.newArrayList((Object[])new String[]{"clientId", "aud1", "aud2"}));
    }
}

