/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.registration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.common.BackchannelTokenDeliveryMode;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.crypto.signature.AsymmetricSignatureAlgorithm;
import org.gluu.oxauth.model.ref.ClientReference;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.AttributesList;
import org.gluu.persist.annotation.CustomObjectClass;
import org.gluu.persist.annotation.DN;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.JsonObject;
import org.gluu.persist.annotation.ObjectClass;
import org.gluu.persist.model.base.CustomAttribute;
import org.gluu.persist.model.base.DeletableEntity;
import org.oxauth.persistence.model.ClientAttributes;

@DataEntry
@ObjectClass(value="oxAuthClient")
public class Client
extends DeletableEntity
implements Serializable,
ClientReference {
    private static final long serialVersionUID = -6832496019942067970L;
    @DN
    private String dn;
    @AttributeName(name="inum")
    private String clientId;
    @AttributeName(name="oxAuthClientSecret")
    private String clientSecret;
    @AttributeName(name="oxAuthLogoutURI")
    private String[] frontChannelLogoutUri;
    @AttributeName(name="oxAuthLogoutSessionRequired")
    private Boolean frontChannelLogoutSessionRequired;
    @AttributeName(name="oxAuthRegistrationAccessToken")
    private String registrationAccessToken;
    @AttributeName(name="oxAuthClientIdIssuedAt")
    private Date clientIdIssuedAt;
    @AttributeName(name="oxAuthClientSecretExpiresAt")
    private Date clientSecretExpiresAt;
    @AttributeName(name="oxAuthRedirectURI")
    private String[] redirectUris;
    @AttributeName(name="oxClaimRedirectURI")
    private String[] claimRedirectUris;
    @AttributeName(name="oxAuthResponseType")
    private ResponseType[] responseTypes;
    @AttributeName(name="oxAuthGrantType")
    private GrantType[] grantTypes;
    @AttributeName(name="oxAuthAppType")
    private String applicationType;
    @AttributeName(name="oxAuthContact")
    private String[] contacts;
    @AttributeName(name="displayName")
    private String clientName;
    @AttributeName(name="tknBndCnf")
    private String idTokenTokenBindingCnf;
    @AttributeName(name="oxAuthLogoURI")
    private String logoUri;
    @AttributeName(name="oxAuthClientURI")
    private String clientUri;
    @AttributeName(name="oxAuthPolicyURI")
    private String policyUri;
    @AttributeName(name="oxAuthTosURI")
    private String tosUri;
    @AttributeName(name="oxAuthJwksURI")
    private String jwksUri;
    @AttributeName(name="oxAuthJwks")
    private String jwks;
    @AttributeName(name="oxAuthSectorIdentifierURI")
    private String sectorIdentifierUri;
    @AttributeName(name="oxAuthSubjectType")
    private String subjectType;
    @AttributeName(name="oxAuthIdTokenSignedResponseAlg")
    private String idTokenSignedResponseAlg;
    @AttributeName(name="oxAuthIdTokenEncryptedResponseAlg")
    private String idTokenEncryptedResponseAlg;
    @AttributeName(name="oxAuthIdTokenEncryptedResponseEnc")
    private String idTokenEncryptedResponseEnc;
    @AttributeName(name="oxAuthSignedResponseAlg")
    private String userInfoSignedResponseAlg;
    @AttributeName(name="oxAuthUserInfoEncryptedResponseAlg")
    private String userInfoEncryptedResponseAlg;
    @AttributeName(name="oxAuthUserInfoEncryptedResponseEnc")
    private String userInfoEncryptedResponseEnc;
    @AttributeName(name="oxAuthRequestObjectSigningAlg")
    private String requestObjectSigningAlg;
    @AttributeName(name="oxAuthRequestObjectEncryptionAlg")
    private String requestObjectEncryptionAlg;
    @AttributeName(name="oxAuthRequestObjectEncryptionEnc")
    private String requestObjectEncryptionEnc;
    @AttributeName(name="oxAuthTokenEndpointAuthMethod")
    private String tokenEndpointAuthMethod;
    @AttributeName(name="oxAuthTokenEndpointAuthSigningAlg")
    private String tokenEndpointAuthSigningAlg;
    @AttributeName(name="oxAuthDefaultMaxAge")
    private Integer defaultMaxAge;
    @AttributeName(name="oxAuthRequireAuthTime")
    private boolean requireAuthTime;
    @AttributeName(name="oxAuthDefaultAcrValues")
    private String[] defaultAcrValues;
    @AttributeName(name="oxAuthInitiateLoginURI")
    private String initiateLoginUri;
    @AttributeName(name="oxAuthPostLogoutRedirectURI")
    private String[] postLogoutRedirectUris;
    @AttributeName(name="oxAuthRequestURI")
    private String[] requestUris;
    @AttributeName(name="oxAuthScope")
    private String[] scopes;
    @AttributeName(name="oxAuthClaim")
    private String[] claims;
    @AttributeName(name="oxAuthTrustedClient")
    private boolean trustedClient;
    @AttributeName(name="oxLastAccessTime")
    private Date lastAccessTime;
    @AttributeName(name="oxLastLogonTime")
    private Date lastLogonTime;
    @AttributeName(name="oxPersistClientAuthorizations")
    private boolean persistClientAuthorizations;
    @AttributeName(name="oxIncludeClaimsInIdToken")
    private boolean includeClaimsInIdToken;
    @AttributeName(name="oxRefreshTokenLifetime")
    private Integer refreshTokenLifetime;
    @AttributeName(name="oxAccessTokenLifetime")
    private Integer accessTokenLifetime;
    @AttributesList(name="name", value="values", sortByName=true)
    private List<CustomAttribute> customAttributes = new ArrayList<CustomAttribute>();
    @CustomObjectClass
    private String[] customObjectClasses;
    @AttributeName(name="oxRptAsJwt")
    private boolean rptAsJwt = false;
    @AttributeName(name="oxAccessTokenAsJwt")
    private boolean accessTokenAsJwt = false;
    @AttributeName(name="oxAccessTokenSigningAlg")
    private String accessTokenSigningAlg;
    @AttributeName(name="oxDisabled")
    private boolean disabled;
    @AttributeName(name="oxAuthAuthorizedOrigins")
    private String[] authorizedOrigins;
    @AttributeName(name="oxSoftwareId")
    private String softwareId;
    @AttributeName(name="oxSoftwareVersion")
    private String softwareVersion;
    @AttributeName(name="oxSoftwareStatement")
    private String softwareStatement;
    @AttributeName(name="oxAttributes")
    @JsonObject
    private ClientAttributes attributes;
    @AttributeName(name="oxAuthBackchannelTokenDeliveryMode")
    private BackchannelTokenDeliveryMode backchannelTokenDeliveryMode;
    @AttributeName(name="oxAuthBackchannelClientNotificationEndpoint")
    private String backchannelClientNotificationEndpoint;
    @AttributeName(name="oxAuthBackchannelAuthenticationRequestSigningAlg")
    private AsymmetricSignatureAlgorithm backchannelAuthenticationRequestSigningAlg;
    @AttributeName(name="oxAuthBackchannelUserCodeParameter")
    private Boolean backchannelUserCodeParameter;

    @Override
    public ClientAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ClientAttributes();
        }
        return this.attributes;
    }

    public void setAttributes(ClientAttributes attributes) {
        this.attributes = attributes;
    }

    public boolean isRptAsJwt() {
        return this.rptAsJwt;
    }

    public void setRptAsJwt(boolean rptAsJwt) {
        this.rptAsJwt = rptAsJwt;
    }

    public boolean isAccessTokenAsJwt() {
        return this.accessTokenAsJwt;
    }

    public void setAccessTokenAsJwt(boolean accessTokenAsJwt) {
        this.accessTokenAsJwt = accessTokenAsJwt;
    }

    public String getAccessTokenSigningAlg() {
        return this.accessTokenSigningAlg;
    }

    public void setAccessTokenSigningAlg(String accessTokenSigningAlg) {
        this.accessTokenSigningAlg = accessTokenSigningAlg;
    }

    @Override
    public AuthenticationMethod getAuthenticationMethod() {
        return AuthenticationMethod.fromString((String)this.tokenEndpointAuthMethod);
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public Boolean getFrontChannelLogoutSessionRequired() {
        return this.frontChannelLogoutSessionRequired;
    }

    public void setFrontChannelLogoutSessionRequired(Boolean frontChannelLogoutSessionRequired) {
        this.frontChannelLogoutSessionRequired = frontChannelLogoutSessionRequired;
    }

    public String[] getFrontChannelLogoutUri() {
        return this.frontChannelLogoutUri;
    }

    public void setFrontChannelLogoutUri(String[] frontChannelLogoutUri) {
        this.frontChannelLogoutUri = frontChannelLogoutUri;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getRegistrationAccessToken() {
        return this.registrationAccessToken;
    }

    public void setRegistrationAccessToken(String registrationAccessToken) {
        this.registrationAccessToken = registrationAccessToken;
    }

    public Date getClientIdIssuedAt() {
        return this.clientIdIssuedAt;
    }

    public void setClientIdIssuedAt(Date clientIdIssuedAt) {
        this.clientIdIssuedAt = clientIdIssuedAt;
    }

    public Date getClientSecretExpiresAt() {
        return this.clientSecretExpiresAt != null ? new Date(this.clientSecretExpiresAt.getTime()) : null;
    }

    public void setClientSecretExpiresAt(Date clientSecretExpiresAt) {
        this.clientSecretExpiresAt = clientSecretExpiresAt != null ? new Date(clientSecretExpiresAt.getTime()) : null;
    }

    public String[] getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(String[] redirectUris) {
        this.redirectUris = redirectUris;
    }

    public String[] getClaimRedirectUris() {
        return this.claimRedirectUris;
    }

    public void setClaimRedirectUris(String[] claimRedirectUris) {
        this.claimRedirectUris = claimRedirectUris;
    }

    public ResponseType[] getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(ResponseType[] responseTypes) {
        this.responseTypes = responseTypes;
    }

    public GrantType[] getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(GrantType[] grantTypes) {
        this.grantTypes = grantTypes;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String[] getContacts() {
        return this.contacts;
    }

    public void setContacts(String[] contacts) {
        this.contacts = contacts;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getIdTokenTokenBindingCnf() {
        return this.idTokenTokenBindingCnf;
    }

    public void setIdTokenTokenBindingCnf(String idTokenTokenBindingCnf) {
        this.idTokenTokenBindingCnf = idTokenTokenBindingCnf;
    }

    public boolean isTokenBindingSupported() {
        return StringUtils.isNotBlank((String)this.idTokenTokenBindingCnf);
    }

    public String getLogoUri() {
        return this.logoUri;
    }

    public void setLogoUri(String logoUri) {
        this.logoUri = logoUri;
    }

    public String getClientUri() {
        return this.clientUri;
    }

    public void setClientUri(String clientUri) {
        this.clientUri = clientUri;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
    }

    public String getTosUri() {
        return this.tosUri;
    }

    public void setTosUri(String tosUri) {
        this.tosUri = tosUri;
    }

    @Override
    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    @Override
    public String getJwks() {
        return this.jwks;
    }

    public void setJwks(String jwks) {
        this.jwks = jwks;
    }

    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    public String getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public String getIdTokenSignedResponseAlg() {
        return this.idTokenSignedResponseAlg;
    }

    public void setIdTokenSignedResponseAlg(String idTokenSignedResponseAlg) {
        this.idTokenSignedResponseAlg = idTokenSignedResponseAlg;
    }

    public String getIdTokenEncryptedResponseAlg() {
        return this.idTokenEncryptedResponseAlg;
    }

    public void setIdTokenEncryptedResponseAlg(String idTokenEncryptedResponseAlg) {
        this.idTokenEncryptedResponseAlg = idTokenEncryptedResponseAlg;
    }

    public String getIdTokenEncryptedResponseEnc() {
        return this.idTokenEncryptedResponseEnc;
    }

    public void setIdTokenEncryptedResponseEnc(String idTokenEncryptedResponseEnc) {
        this.idTokenEncryptedResponseEnc = idTokenEncryptedResponseEnc;
    }

    public String getUserInfoSignedResponseAlg() {
        return this.userInfoSignedResponseAlg;
    }

    public void setUserInfoSignedResponseAlg(String userInfoSignedResponseAlg) {
        this.userInfoSignedResponseAlg = userInfoSignedResponseAlg;
    }

    public String getUserInfoEncryptedResponseAlg() {
        return this.userInfoEncryptedResponseAlg;
    }

    public void setUserInfoEncryptedResponseAlg(String userInfoEncryptedResponseAlg) {
        this.userInfoEncryptedResponseAlg = userInfoEncryptedResponseAlg;
    }

    public String getUserInfoEncryptedResponseEnc() {
        return this.userInfoEncryptedResponseEnc;
    }

    public void setUserInfoEncryptedResponseEnc(String userInfoEncryptedResponseEnc) {
        this.userInfoEncryptedResponseEnc = userInfoEncryptedResponseEnc;
    }

    public String getRequestObjectSigningAlg() {
        return this.requestObjectSigningAlg;
    }

    public void setRequestObjectSigningAlg(String requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    public String getRequestObjectEncryptionAlg() {
        return this.requestObjectEncryptionAlg;
    }

    public void setRequestObjectEncryptionAlg(String requestObjectEncryptionAlg) {
        this.requestObjectEncryptionAlg = requestObjectEncryptionAlg;
    }

    public String getRequestObjectEncryptionEnc() {
        return this.requestObjectEncryptionEnc;
    }

    public void setRequestObjectEncryptionEnc(String requestObjectEncryptionEnc) {
        this.requestObjectEncryptionEnc = requestObjectEncryptionEnc;
    }

    public String getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    public void setTokenEndpointAuthMethod(String tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    public String getTokenEndpointAuthSigningAlg() {
        return this.tokenEndpointAuthSigningAlg;
    }

    public void setTokenEndpointAuthSigningAlg(String tokenEndpointAuthSigningAlg) {
        this.tokenEndpointAuthSigningAlg = tokenEndpointAuthSigningAlg;
    }

    public Integer getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(Integer defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    public boolean getRequireAuthTime() {
        return this.requireAuthTime;
    }

    public void setRequireAuthTime(boolean requireAuthTime) {
        this.requireAuthTime = requireAuthTime;
    }

    public String[] getDefaultAcrValues() {
        return this.defaultAcrValues;
    }

    public void setDefaultAcrValues(String[] defaultAcrValues) {
        this.defaultAcrValues = defaultAcrValues;
    }

    public String getInitiateLoginUri() {
        return this.initiateLoginUri;
    }

    public void setInitiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public String[] getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(String[] postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public String[] getRequestUris() {
        return this.requestUris;
    }

    public void setRequestUris(String[] requestUris) {
        this.requestUris = requestUris;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public void setScopes(String[] scopes) {
        this.scopes = scopes;
    }

    public String[] getClaims() {
        return this.claims;
    }

    public void setClaims(String[] claims) {
        this.claims = claims;
    }

    public boolean getTrustedClient() {
        return this.trustedClient;
    }

    public void setTrustedClient(boolean trustedClient) {
        this.trustedClient = trustedClient;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public Date getLastLogonTime() {
        return this.lastLogonTime;
    }

    public void setLastLogonTime(Date lastLogonTime) {
        this.lastLogonTime = lastLogonTime;
    }

    public boolean getPersistClientAuthorizations() {
        return this.persistClientAuthorizations;
    }

    public void setPersistClientAuthorizations(boolean persistClientAuthorizations) {
        this.persistClientAuthorizations = persistClientAuthorizations;
    }

    public boolean isIncludeClaimsInIdToken() {
        return this.includeClaimsInIdToken;
    }

    public void setIncludeClaimsInIdToken(boolean includeClaimsInIdToken) {
        this.includeClaimsInIdToken = includeClaimsInIdToken;
    }

    public Integer getRefreshTokenLifetime() {
        return this.refreshTokenLifetime;
    }

    public void setRefreshTokenLifetime(Integer refreshTokenLifetime) {
        this.refreshTokenLifetime = refreshTokenLifetime;
    }

    public Integer getAccessTokenLifetime() {
        return this.accessTokenLifetime;
    }

    public void setAccessTokenLifetime(Integer accessTokenLifetime) {
        this.accessTokenLifetime = accessTokenLifetime;
    }

    public List<CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] p_customObjectClasses) {
        this.customObjectClasses = p_customObjectClasses;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String[] getAuthorizedOrigins() {
        return this.authorizedOrigins;
    }

    public void setAuthorizedOrigins(String[] authorizedOrigins) {
        this.authorizedOrigins = authorizedOrigins;
    }

    public String getSoftwareId() {
        return this.softwareId;
    }

    public void setSoftwareId(String softwareId) {
        this.softwareId = softwareId;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public String getSoftwareStatement() {
        return this.softwareStatement;
    }

    public void setSoftwareStatement(String softwareStatement) {
        this.softwareStatement = softwareStatement;
    }

    public static Client instance() {
        return new Client();
    }

    public BackchannelTokenDeliveryMode getBackchannelTokenDeliveryMode() {
        return this.backchannelTokenDeliveryMode;
    }

    public void setBackchannelTokenDeliveryMode(BackchannelTokenDeliveryMode backchannelTokenDeliveryMode) {
        this.backchannelTokenDeliveryMode = backchannelTokenDeliveryMode;
    }

    public String getBackchannelClientNotificationEndpoint() {
        return this.backchannelClientNotificationEndpoint;
    }

    public void setBackchannelClientNotificationEndpoint(String backchannelClientNotificationEndpoint) {
        this.backchannelClientNotificationEndpoint = backchannelClientNotificationEndpoint;
    }

    public AsymmetricSignatureAlgorithm getBackchannelAuthenticationRequestSigningAlg() {
        return this.backchannelAuthenticationRequestSigningAlg;
    }

    public void setBackchannelAuthenticationRequestSigningAlg(AsymmetricSignatureAlgorithm backchannelAuthenticationRequestSigningAlg) {
        this.backchannelAuthenticationRequestSigningAlg = backchannelAuthenticationRequestSigningAlg;
    }

    public Boolean getBackchannelUserCodeParameter() {
        return this.backchannelUserCodeParameter;
    }

    public void setBackchannelUserCodeParameter(Boolean backchannelUserCodeParameter) {
        this.backchannelUserCodeParameter = backchannelUserCodeParameter;
    }
}

