/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.ldap;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.persistence.Transient;
import org.apache.commons.collections.map.HashedMap;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapJsonObject;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;

@LdapEntry
@LdapObjectClass(values={"top", "oxAuthSessionId"})
public class SimpleSessionState
implements Serializable {
    private static final long serialVersionUID = -237476411915686378L;
    @LdapDN
    private String dn;
    @LdapAttribute(name="uniqueIdentifier")
    private String id;
    @LdapAttribute(name="oxLastAccessTime")
    private Date lastUsedAt;
    @LdapAttribute(name="oxAuthUserDN")
    private String userDn;
    @LdapAttribute(name="oxAuthAuthenticationTime")
    private Date authenticationTime;
    @LdapAttribute(name="oxAuthSessionState")
    private Boolean permissionGranted;
    @LdapAttribute(name="oxAsJwt")
    private Boolean isJwt = false;
    @LdapAttribute(name="oxJwt")
    private String jwt;
    @LdapJsonObject
    @LdapAttribute(name="oxAuthSessionAttribute")
    private Map<String, String> sessionAttributes;
    @Transient
    private transient boolean persisted;

    public String getDn() {
        return this.dn;
    }

    public void setDn(String p_dn) {
        this.dn = p_dn;
    }

    public String getJwt() {
        return this.jwt;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public Boolean getIsJwt() {
        return this.isJwt;
    }

    public void setIsJwt(Boolean isJwt) {
        this.isJwt = isJwt;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String p_id) {
        this.id = p_id;
    }

    public Date getLastUsedAt() {
        return this.lastUsedAt != null ? new Date(this.lastUsedAt.getTime()) : null;
    }

    public void setLastUsedAt(Date p_lastUsedAt) {
        this.lastUsedAt = p_lastUsedAt != null ? new Date(p_lastUsedAt.getTime()) : null;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String p_userDn) {
        this.userDn = p_userDn != null ? p_userDn : "";
    }

    public Date getAuthenticationTime() {
        return this.authenticationTime != null ? new Date(this.authenticationTime.getTime()) : null;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime != null ? new Date(authenticationTime.getTime()) : null;
    }

    public Boolean getPermissionGranted() {
        return this.permissionGranted;
    }

    public void setPermissionGranted(Boolean permissionGranted) {
        this.permissionGranted = permissionGranted;
    }

    public Map<String, String> getSessionAttributes() {
        if (this.sessionAttributes == null) {
            this.sessionAttributes = new HashedMap();
        }
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSessionState id1 = (SimpleSessionState)o;
        return !(this.id == null ? id1.id != null : !this.id.equals(id1.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionState");
        sb.append(", dn='").append(this.dn).append('\'');
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", isJwt=").append(this.isJwt);
        sb.append(", lastUsedAt=").append(this.lastUsedAt);
        sb.append(", userDn='").append(this.userDn).append('\'');
        sb.append(", authenticationTime=").append(this.authenticationTime);
        sb.append(", permissionGranted=").append(this.permissionGranted);
        sb.append(", sessionAttributes=").append(this.sessionAttributes);
        sb.append(", persisted=").append(this.persisted);
        sb.append('}');
        return sb.toString();
    }
}

