/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.ldap;

import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;
import org.gluu.ldap.LdapSampleEntryManager;
import org.gluu.ldap.SimpleSessionState;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.xdi.log.LoggingHelper;

public class LdapSampleSimpleSessionSample {
    private static final Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        LdapSampleEntryManager ldapSampleEntryManager = new LdapSampleEntryManager();
        final LdapEntryManager ldapEntryManager = ldapSampleEntryManager.createLdapEntryManager();
        try {
            String sessionId = "xyzcyzxy-a41a-45ad-8a83-61485dbad561";
            final String sessionDn = "uniqueIdentifier=" + sessionId + ",ou=session,o=@!E8F2.853B.1E7B.ACE2!0001!39A4.C163,o=gluu";
            String userDn = "inum=@!E8F2.853B.1E7B.ACE2!0001!39A4.C163!0000!A8F2.DE1E.D7FB,ou=people,o=@!E8F2.853B.1E7B.ACE2!0001!39A4.C163,o=gluu";
            SimpleSessionState simpleSessionState = new SimpleSessionState();
            simpleSessionState.setDn(sessionDn);
            simpleSessionState.setId(sessionId);
            simpleSessionState.setLastUsedAt(new Date());
            ldapEntryManager.persist((Object)simpleSessionState);
            System.out.println("Persisted");
            int threadCount = 500;
            ExecutorService executorService = Executors.newFixedThreadPool(threadCount, LdapSampleSimpleSessionSample.daemonThreadFactory());
            int i = 0;
            while (i < threadCount) {
                final int count = i++;
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        SimpleSessionState simpleSessionStateFromLdap = (SimpleSessionState)ldapEntryManager.find(SimpleSessionState.class, (Object)sessionDn);
                        String beforeUserDn = simpleSessionStateFromLdap.getUserDn();
                        String randomUserDn = count % 2 == 0 ? "inum=@!E8F2.853B.1E7B.ACE2!0001!39A4.C163!0000!A8F2.DE1E.D7FB,ou=people,o=@!E8F2.853B.1E7B.ACE2!0001!39A4.C163,o=gluu" : "";
                        try {
                            simpleSessionStateFromLdap.setUserDn(randomUserDn);
                            simpleSessionStateFromLdap.setLastUsedAt(new Date());
                            ldapEntryManager.merge((Object)simpleSessionStateFromLdap);
                            System.out.println("Merged thread: " + count + ", userDn: " + randomUserDn + ", before userDn: " + beforeUserDn);
                        }
                        catch (Throwable e) {
                            System.out.println("ERROR !!!, thread: " + count + ", userDn: " + randomUserDn + ", before userDn: " + beforeUserDn + ", error:" + e.getMessage());
                        }
                    }
                });
            }
            Thread.sleep(5000L);
        }
        finally {
            ldapEntryManager.getLdapOperationService().getConnectionPool().close();
        }
    }

    public static ThreadFactory daemonThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable p_r) {
                Thread thread = new Thread(p_r);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        log = Logger.getLogger(LdapSampleSimpleSessionSample.class);
    }
}

