/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.ldap;

import com.unboundid.ldap.sdk.ResultCode;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.gluu.site.ldap.LDAPConnectionProvider;
import org.gluu.site.ldap.OperationsFacade;
import org.gluu.site.ldap.persistence.LdapEntryManager;

public class LdapSampleEntryManager {
    private static final Logger log = Logger.getLogger(LdapSampleEntryManager.class);

    private Properties getSampleConnectionProperties() {
        Properties connectionProperties = new Properties();
        connectionProperties.put("bindDN", "cn=directory manager");
        connectionProperties.put("bindPassword", "9lQoXSINUsnP");
        connectionProperties.put("servers", "xeon.gluu.info:11636");
        connectionProperties.put("useSSL", "true");
        connectionProperties.put("maxconnections", "3");
        return connectionProperties;
    }

    private LDAPConnectionProvider createConnectionProvider(Properties connectionProperties) {
        LDAPConnectionProvider connectionProvider = new LDAPConnectionProvider(connectionProperties);
        return connectionProvider;
    }

    private LDAPConnectionProvider createBindConnectionProvider(Properties bindConnectionProperties, Properties connectionProperties) {
        LDAPConnectionProvider bindConnectionProvider = this.createConnectionProvider(bindConnectionProperties);
        if (ResultCode.INAPPROPRIATE_AUTHENTICATION.equals((Object)bindConnectionProvider.getCreationResultCode())) {
            log.warn((Object)"It's not possible to create authentication LDAP connection pool using anonymous bind. Attempting to create it using binDN/bindPassword");
            bindConnectionProvider = this.createConnectionProvider(connectionProperties);
        }
        return bindConnectionProvider;
    }

    private Properties prepareBindConnectionProperties(Properties connectionProperties) {
        Properties bindProperties = (Properties)connectionProperties.clone();
        bindProperties.remove("bindDN");
        bindProperties.remove("bindPassword");
        return bindProperties;
    }

    public LdapEntryManager createLdapEntryManager() {
        Properties connectionProperties = this.getSampleConnectionProperties();
        LDAPConnectionProvider connectionProvider = this.createConnectionProvider(connectionProperties);
        Properties bindConnectionProperties = this.prepareBindConnectionProperties(connectionProperties);
        LDAPConnectionProvider bindConnectionProvider = this.createBindConnectionProvider(bindConnectionProperties, connectionProperties);
        LdapEntryManager ldapEntryManager = new LdapEntryManager(new OperationsFacade(connectionProvider, bindConnectionProvider));
        log.debug((Object)("Created LdapEntryManager: " + ldapEntryManager));
        return ldapEntryManager;
    }
}

