/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.ldap;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.util.StaticUtils;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;
import org.gluu.ldap.LdapSample;
import org.gluu.ldap.LdapSampleEntryManager;
import org.gluu.ldap.SimpleSession;
import org.gluu.ldap.SimpleTokenLdap;
import org.gluu.site.ldap.persistence.BatchOperation;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.xdi.ldap.model.CustomAttribute;
import org.xdi.ldap.model.SearchScope;
import org.xdi.log.LoggingHelper;

public class LdapSampleBatchJob {
    private static final Logger log;

    public static void main(String[] args) {
        LdapSampleEntryManager ldapSampleEntryManager = new LdapSampleEntryManager();
        final LdapEntryManager ldapEntryManager = ldapSampleEntryManager.createLdapEntryManager();
        BatchOperation<SimpleTokenLdap> tokenLdapBatchOperation = new BatchOperation<SimpleTokenLdap>(ldapEntryManager){
            private int processedCount;
            {
                super(x0);
                this.processedCount = 0;
            }

            protected List<SimpleTokenLdap> getChunkOrNull(int batchSize) {
                log.info((Object)("Processed: " + this.processedCount));
                Filter filter = Filter.createPresenceFilter((String)"oxAuthExpiration");
                return ldapEntryManager.findEntries("o=gluu", SimpleTokenLdap.class, filter, SearchScope.SUB, new String[]{"oxAuthExpiration"}, (BatchOperation)this, 0, batchSize, batchSize);
            }

            protected void performAction(List<SimpleTokenLdap> objects) {
                for (SimpleTokenLdap simpleTokenLdap : objects) {
                    try {
                        CustomAttribute customAttribute = LdapSampleBatchJob.getUpdatedAttribute("oxAuthExpiration", simpleTokenLdap.getAttribute("oxAuthExpiration"));
                        simpleTokenLdap.setCustomAttributes(Arrays.asList(customAttribute));
                        ldapEntryManager.merge((Object)simpleTokenLdap);
                        ++this.processedCount;
                    }
                    catch (EntryPersistenceException ex) {
                        log.error((Object)"Failed to update entry", (Throwable)ex);
                    }
                }
            }
        };
        tokenLdapBatchOperation.iterateAllByChunks(100);
        BatchOperation<SimpleSession> sessionBatchOperation = new BatchOperation<SimpleSession>(ldapEntryManager){
            private int processedCount;
            {
                super(x0);
                this.processedCount = 0;
            }

            protected List<SimpleSession> getChunkOrNull(int batchSize) {
                log.info((Object)("Processed: " + this.processedCount));
                Filter filter = Filter.createPresenceFilter((String)"oxLastAccessTime");
                return ldapEntryManager.findEntries("o=gluu", SimpleSession.class, filter, SearchScope.SUB, new String[]{"oxLastAccessTime"}, (BatchOperation)this, 0, batchSize, batchSize);
            }

            protected void performAction(List<SimpleSession> objects) {
                for (SimpleSession simpleSession : objects) {
                    try {
                        CustomAttribute customAttribute = LdapSampleBatchJob.getUpdatedAttribute("oxLastAccessTime", simpleSession.getAttribute("oxLastAccessTime"));
                        simpleSession.setCustomAttributes(Arrays.asList(customAttribute));
                        ldapEntryManager.merge((Object)simpleSession);
                        ++this.processedCount;
                    }
                    catch (EntryPersistenceException ex) {
                        log.error((Object)"Failed to update entry", (Throwable)ex);
                    }
                }
            }
        };
        sessionBatchOperation.iterateAllByChunks(100);
    }

    private static CustomAttribute getUpdatedAttribute(String attributeName, String attributeValue) {
        try {
            Calendar calendar = Calendar.getInstance();
            Date oxLastAccessTimeDate = StaticUtils.decodeGeneralizedTime((String)attributeValue);
            calendar.setTime(oxLastAccessTimeDate);
            calendar.add(13, -1);
            CustomAttribute customAttribute = new CustomAttribute();
            customAttribute.setName(attributeName);
            customAttribute.setDate(calendar.getTime());
            return customAttribute;
        }
        catch (ParseException e) {
            log.error((Object)"Can't parse attribute", (Throwable)e);
            return null;
        }
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        log = Logger.getLogger(LdapSample.class);
    }
}

