/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.ldap;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.SearchResult;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;
import org.gluu.ldap.LdapSampleEntryManager;
import org.gluu.ldap.SimpleAttribute;
import org.gluu.ldap.SimpleGrant;
import org.gluu.ldap.SimpleSession;
import org.gluu.ldap.SimpleUser;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.xdi.ldap.model.CustomAttribute;
import org.xdi.ldap.model.SearchScope;
import org.xdi.ldap.model.VirtualListViewResponse;
import org.xdi.log.LoggingHelper;

public class LdapSample {
    private static final Logger log;

    public static void main(String[] args) {
        LdapSampleEntryManager ldapSampleEntryManager = new LdapSampleEntryManager();
        LdapEntryManager ldapEntryManager = ldapSampleEntryManager.createLdapEntryManager();
        List users = ldapEntryManager.findEntries("o=gluu", SimpleUser.class, null);
        for (SimpleUser user : users) {
            log.debug((Object)("User with uid: " + user.getUserId()));
        }
        if (users.size() > 0) {
            SimpleUser user = (SimpleUser)users.get(0);
            user.getCustomAttributes().add(new CustomAttribute("streetAddress", "Somewhere: " + System.currentTimeMillis()));
            ldapEntryManager.merge((Object)user);
        }
        Filter filter = Filter.createEqualityFilter((String)"gluuStatus", (String)"active");
        List attributes = ldapEntryManager.findEntries("o=gluu", SimpleAttribute.class, filter, SearchScope.SUB, null, null, 10, 0, 0);
        for (SimpleAttribute attribute : attributes) {
            log.debug((Object)("Attribute with displayName: " + attribute.getCustomAttributes().get(1)));
        }
        List sessions = ldapEntryManager.findEntries("o=gluu", SimpleSession.class, filter, SearchScope.SUB, null, null, 10, 0, 0);
        log.debug((Object)("Found sessions: " + sessions.size()));
        List grants = ldapEntryManager.findEntries("o=gluu", SimpleGrant.class, null, SearchScope.SUB, new String[]{"oxAuthGrantId"}, null, 10, 0, 0);
        log.debug((Object)("Found grants: " + grants.size()));
        try {
            VirtualListViewResponse virtualListViewResponse = new VirtualListViewResponse();
            SearchResult searchResult = ldapEntryManager.getLdapOperationService().searchSearchResult("o=gluu", Filter.createEqualityFilter((String)"objectClass", (String)"gluuPerson"), SearchScope.SUB, 10, 100, 100000, "displayName", null, virtualListViewResponse, new String[]{"uid", "displayName", "gluuStatus"});
            log.debug((Object)("Found persons: " + virtualListViewResponse.getTotalResults()));
            System.out.println(searchResult.getSearchEntries());
        }
        catch (Exception ex) {
            log.error((Object)"Failed to search", (Throwable)ex);
        }
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        log = Logger.getLogger(LdapSample.class);
    }
}

