/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.orm.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.gluu.orm.util.StringHelper;

public final class ArrayHelper {
    private ArrayHelper() {
    }

    public static <T> T[] arrayMerge(T[] ... arrays) {
        int count = 0;
        for (T[] array : arrays) {
            count += array.length;
        }
        if (count == 0) {
            return (Object[])Array.newInstance(arrays.getClass().getComponentType().getComponentType(), 0);
        }
        Object[] mergedArray = (Object[])Array.newInstance(arrays[0][0].getClass(), count);
        int start = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, mergedArray, start, array.length);
            start += array.length;
        }
        return mergedArray;
    }

    public static <T> boolean isEmpty(T[] objects) {
        return objects == null || objects.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] objects) {
        return objects != null && objects.length > 0;
    }

    public static <T> T[] arrayClone(T[] array) {
        if (array == null) {
            return array;
        }
        if (array.length == 0) {
            return (Object[])Array.newInstance(array.getClass().getComponentType(), 0);
        }
        Object[] clonedArray = (Object[])Array.newInstance(array[0].getClass(), array.length);
        System.arraycopy(array, 0, clonedArray, 0, array.length);
        return clonedArray;
    }

    public static <T> T[] sortAndClone(T[] array) {
        if (array == null) {
            return array;
        }
        Object[] clonedArray = ArrayHelper.arrayClone(array);
        Arrays.sort(clonedArray);
        return clonedArray;
    }

    public static <T> boolean equalsIgnoreOrder(T[] values1, T[] values2) {
        Object[] valuesSorted1 = ArrayHelper.sortAndClone(values1);
        Object[] valuesSorted2 = ArrayHelper.sortAndClone(values2);
        return Arrays.equals(valuesSorted1, valuesSorted2);
    }

    public static String[] addItemToStringArray(String[] array, String item) {
        String[] array2 = new String[]{item};
        if (array == null) {
            return array2;
        }
        return ArrayHelper.arrayMerge(array, array2);
    }

    public static String toString(Object[] array) {
        return StringHelper.toString(array);
    }
}

