/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.orm.util.init;

import java.util.concurrent.locks.ReentrantLock;

public abstract class Initializable {
    private final ReentrantLock lock = new ReentrantLock();
    private boolean initialized = false;

    public void init() {
        if (!this.initialized) {
            this.lock.lock();
            try {
                if (!this.initialized) {
                    this.initInternal();
                    this.initialized = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public synchronized void reinit() {
        this.initInternal();
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected abstract void initInternal();

    protected void resetInitialized() {
        this.initialized = false;
    }
}

