/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.service;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.gluu.persist.PersistenceEntryManagerFactory;
import org.gluu.persist.exception.PropertyNotFoundException;
import org.gluu.persist.exception.operation.ConfigurationException;
import org.gluu.persist.model.PersistenceConfiguration;
import org.gluu.persist.reflect.util.ReflectHelper;
import org.gluu.persist.service.BaseFactoryService;
import org.gluu.persist.service.PersistanceFactoryService;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class StandalonePersistanceFactoryService
extends PersistanceFactoryService {
    private HashMap<String, PersistenceEntryManagerFactory> persistenceEntryManagerFactoryNames;
    private HashMap<Class<? extends PersistenceEntryManagerFactory>, PersistenceEntryManagerFactory> persistenceEntryManagerFactoryTypes;

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory(PersistenceConfiguration persistenceConfiguration) {
        return this.getPersistenceEntryManagerFactory(persistenceConfiguration.getEntryManagerFactoryType());
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory(Class<? extends PersistenceEntryManagerFactory> persistenceEntryManagerFactoryClass) {
        if (this.persistenceEntryManagerFactoryTypes == null) {
            this.initPersistenceManagerMaps();
        }
        PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.persistenceEntryManagerFactoryTypes.get(persistenceEntryManagerFactoryClass);
        return persistenceEntryManagerFactory;
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory(String persistenceType) {
        if (this.persistenceEntryManagerFactoryNames == null) {
            this.initPersistenceManagerMaps();
        }
        PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.persistenceEntryManagerFactoryNames.get(persistenceType);
        return persistenceEntryManagerFactory;
    }

    private void initPersistenceManagerMaps() {
        this.persistenceEntryManagerFactoryNames = new HashMap();
        this.persistenceEntryManagerFactoryTypes = new HashMap();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)"org.gluu.persist", (ClassLoader[])new ClassLoader[0])).addUrls(ClasspathHelper.forPackage((String)"org.gluu.orm", (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{Scanners.SubTypes}));
        Set classes = reflections.getSubTypesOf(PersistenceEntryManagerFactory.class);
        this.getLog().info("Found '{}' PersistenceEntryManagerFactory", (Object)classes.size());
        ArrayList classesList = new ArrayList(classes);
        for (Class clazz : classesList) {
            this.getLog().info("Found PersistenceEntryManagerFactory '{}'", (Object)clazz);
            PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.createPersistenceEntryManagerFactoryImpl(clazz);
            this.persistenceEntryManagerFactoryNames.put(persistenceEntryManagerFactory.getPersistenceType(), persistenceEntryManagerFactory);
            this.persistenceEntryManagerFactoryTypes.put(clazz, persistenceEntryManagerFactory);
        }
    }

    private PersistenceEntryManagerFactory createPersistenceEntryManagerFactoryImpl(Class<? extends PersistenceEntryManagerFactory> persistenceEntryManagerFactoryClass) {
        PersistenceEntryManagerFactory persistenceEntryManagerFactory;
        try {
            persistenceEntryManagerFactory = (PersistenceEntryManagerFactory)ReflectHelper.createObjectByDefaultConstructor(persistenceEntryManagerFactoryClass);
            persistenceEntryManagerFactory.initStandalone((BaseFactoryService)this);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException | PropertyNotFoundException e) {
            throw new ConfigurationException(String.format("Failed to create PersistenceEntryManagerFactory by type '%s'!", persistenceEntryManagerFactoryClass));
        }
        return persistenceEntryManagerFactory;
    }
}

