/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.cloud.spanner.util;

import com.google.cloud.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.gluu.orm.util.ValueHelper;

public class SpannerValueHelper
extends ValueHelper {
    private static final Date[] EMPTY_GOOGLE_DATE_ARRAY = new Date[0];
    private static final com.google.cloud.Timestamp[] EMPTY_GOOGLE_TIMESTAMP_ARRAY = new com.google.cloud.Timestamp[0];
    private static final java.util.Date[] EMPTY_DATE_ARRAY = new java.util.Date[0];

    public static Date toGoogleDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof java.util.Date) {
            return Date.fromJavaUtilDate((java.util.Date)((java.util.Date)value));
        }
        try {
            return Date.parseDate((String)value.toString());
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public static Date[] toGoogleDateArray(Object values) {
        if (values == null) {
            return null;
        }
        if (values instanceof List) {
            List valuesList = (List)values;
            if (valuesList.size() == 0) {
                return EMPTY_GOOGLE_DATE_ARRAY;
            }
            Date[] result = new Date[valuesList.size()];
            int idx = 0;
            for (Object value : valuesList) {
                result[idx++] = SpannerValueHelper.toGoogleDate(value);
            }
            return result;
        }
        if (values.getClass().isArray()) {
            Object[] valuesArray = (Object[])values;
            if (valuesArray.length == 0) {
                return EMPTY_GOOGLE_DATE_ARRAY;
            }
            Date[] result = new Date[valuesArray.length];
            for (int i = 0; i < valuesArray.length; ++i) {
                result[i] = SpannerValueHelper.toGoogleDate(valuesArray[i]);
            }
            return result;
        }
        return new Date[]{SpannerValueHelper.toGoogleDate(values)};
    }

    public static List<Date> toGoogleDateList(Object[] values) {
        if (values == null) {
            return null;
        }
        return Arrays.asList(SpannerValueHelper.toGoogleDateArray(values));
    }

    public static java.util.Date[] toJavaDateArrayFromSpannerDateList(List<Date> dates) {
        if (dates == null) {
            return EMPTY_DATE_ARRAY;
        }
        java.util.Date[] result = new java.util.Date[dates.size()];
        int idx = 0;
        for (Date date : dates) {
            result[idx++] = Date.toJavaUtilDate((Date)date);
        }
        return result;
    }

    public static com.google.cloud.Timestamp toGoogleTimestamp(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof com.google.cloud.Timestamp) {
            return (com.google.cloud.Timestamp)value;
        }
        if (value instanceof java.util.Date) {
            return com.google.cloud.Timestamp.of((java.util.Date)((java.util.Date)value));
        }
        if (value instanceof Timestamp) {
            return com.google.cloud.Timestamp.of((Timestamp)((Timestamp)value));
        }
        try {
            return com.google.cloud.Timestamp.parseTimestamp((String)value.toString());
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public static com.google.cloud.Timestamp[] toGoogleTimestampArray(Object values) {
        if (values == null) {
            return null;
        }
        if (values instanceof List) {
            List valuesList = (List)values;
            if (valuesList.size() == 0) {
                return EMPTY_GOOGLE_TIMESTAMP_ARRAY;
            }
            com.google.cloud.Timestamp[] result = new com.google.cloud.Timestamp[valuesList.size()];
            int idx = 0;
            for (Object value : valuesList) {
                result[idx++] = SpannerValueHelper.toGoogleTimestamp(value);
            }
            return result;
        }
        if (values.getClass().isArray()) {
            Object[] valuesArray = (Object[])values;
            if (valuesArray.length == 0) {
                return EMPTY_GOOGLE_TIMESTAMP_ARRAY;
            }
            com.google.cloud.Timestamp[] result = new com.google.cloud.Timestamp[valuesArray.length];
            for (int i = 0; i < valuesArray.length; ++i) {
                result[i] = SpannerValueHelper.toGoogleTimestamp(valuesArray[i]);
            }
            return result;
        }
        return new com.google.cloud.Timestamp[]{SpannerValueHelper.toGoogleTimestamp(values)};
    }

    public static List<com.google.cloud.Timestamp> toGoogleTimestampList(Object[] values) {
        if (values == null) {
            return null;
        }
        return Arrays.asList(SpannerValueHelper.toGoogleTimestampArray(values));
    }

    public static java.util.Date[] toJavaDateArrayFromSpannerTimestampList(List<com.google.cloud.Timestamp> dates) {
        if (dates == null) {
            return EMPTY_DATE_ARRAY;
        }
        java.util.Date[] result = new java.util.Date[dates.size()];
        int idx = 0;
        for (com.google.cloud.Timestamp date : dates) {
            result[idx++] = new java.util.Date(date.toSqlTimestamp().getTime());
        }
        return result;
    }
}

