/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.cloud.spanner.operation.impl;

import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.ValueBinder;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.Offset;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.codec.binary.Hex;
import org.gluu.orm.util.ArrayHelper;
import org.gluu.orm.util.StringHelper;
import org.gluu.persist.cloud.spanner.impl.SpannerBatchOperationWraper;
import org.gluu.persist.cloud.spanner.model.ConvertedExpression;
import org.gluu.persist.cloud.spanner.model.SearchReturnDataType;
import org.gluu.persist.cloud.spanner.model.TableMapping;
import org.gluu.persist.cloud.spanner.model.ValueWithStructField;
import org.gluu.persist.cloud.spanner.operation.SpannerOperationService;
import org.gluu.persist.cloud.spanner.operation.impl.SpannerConnectionProvider;
import org.gluu.persist.cloud.spanner.operation.watch.OperationDurationUtil;
import org.gluu.persist.cloud.spanner.util.SpannerValueHelper;
import org.gluu.persist.exception.extension.PersistenceExtension;
import org.gluu.persist.exception.operation.DeleteException;
import org.gluu.persist.exception.operation.DuplicateEntryException;
import org.gluu.persist.exception.operation.EntryConvertationException;
import org.gluu.persist.exception.operation.EntryNotFoundException;
import org.gluu.persist.exception.operation.IncompatibleTypeException;
import org.gluu.persist.exception.operation.PersistenceException;
import org.gluu.persist.exception.operation.SearchException;
import org.gluu.persist.model.AttributeData;
import org.gluu.persist.model.AttributeDataModification;
import org.gluu.persist.model.BatchOperation;
import org.gluu.persist.model.EntryData;
import org.gluu.persist.model.PagedResult;
import org.gluu.persist.model.SearchScope;
import org.gluu.persist.model.Sort;
import org.gluu.persist.model.SortOrder;
import org.gluu.persist.operation.auth.PasswordEncryptionHelper;
import org.gluu.persist.operation.auth.PasswordEncryptionMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpannerOperationServiceImpl
implements SpannerOperationService {
    private static final Logger LOG = LoggerFactory.getLogger(SpannerOperationServiceImpl.class);
    public static final Object[] NO_OBJECTS = new Object[0];
    private Properties props;
    private SpannerConnectionProvider connectionProvider;
    private boolean disableAttributeMapping = false;
    private PersistenceExtension persistenceExtension;
    private DatabaseClient databaseClient;
    private Table tableAlias = new Table("doc");

    private SpannerOperationServiceImpl() {
    }

    public SpannerOperationServiceImpl(Properties props, SpannerConnectionProvider connectionProvider) {
        this.props = props;
        this.connectionProvider = connectionProvider;
        this.init();
    }

    private void init() {
        this.databaseClient = this.connectionProvider.getClient();
    }

    @Override
    public SpannerConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public boolean authenticate(String key, String password, String objectClass) throws SearchException {
        return this.authenticateImpl(key, password, objectClass);
    }

    private boolean authenticateImpl(String key, String password, String objectClass) throws SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        boolean result = false;
        if (password != null) {
            try {
                List<AttributeData> attributes = this.lookup(key, objectClass, "userPassword");
                Object userPasswordObj = null;
                for (AttributeData attribute : attributes) {
                    if (!StringHelper.equalsIgnoreCase((String)attribute.getName(), (String)"userPassword")) continue;
                    userPasswordObj = attribute.getValue();
                }
                String userPassword = null;
                if (userPasswordObj instanceof String) {
                    userPassword = (String)userPasswordObj;
                }
                if (userPassword != null) {
                    result = this.persistenceExtension == null ? PasswordEncryptionHelper.compareCredentials((String)password, (String)userPassword) : this.persistenceExtension.compareHashedPasswords(password, userPassword);
                }
            }
            catch (EntryConvertationException ex) {
                throw new SearchException(String.format("Failed to get '%s' attribute", "userPassword"), (Throwable)ex);
            }
        }
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        OperationDurationUtil.instance().logDebug("Spanner operation: bind, duration: {}, table: {}, key: {}", new Object[]{duration, tableMapping.getTableName(), key});
        return result;
    }

    @Override
    public boolean addEntry(String key, String objectClass, Collection<AttributeData> attributes) throws DuplicateEntryException, PersistenceException {
        Instant startTime = OperationDurationUtil.instance().now();
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        boolean result = this.addEntryImpl(tableMapping, key, attributes);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("SQL operation: add, duration: {}, table: {}, key: {}, attributes: {}", new Object[]{duration, tableMapping.getTableName(), key, attributes});
        return result;
    }

    private boolean addEntryImpl(TableMapping tableMapping, String key, Collection<AttributeData> attributes) throws PersistenceException {
        try {
            MessageDigest messageDigest = SpannerOperationServiceImpl.getMessageDigestInstance();
            Map<String, Type.StructField> columTypes = tableMapping.getColumTypes();
            Mutation.WriteBuilder mutationBuilder = Mutation.newInsertOrUpdateBuilder((String)tableMapping.getTableName());
            LinkedList<Mutation> mutations = new LinkedList<Mutation>();
            for (AttributeData attribute : attributes) {
                String attributeName = attribute.getName();
                Type.StructField attributeType = columTypes.get(attributeName.toLowerCase());
                if (attributeType == null) {
                    TableMapping childTableMapping = this.connectionProvider.getChildTableMappingByKey(key, tableMapping, attributeName);
                    if (childTableMapping == null) {
                        throw new PersistenceException(String.format("Failed to add entry. Column '%s' is undefined", attributeName));
                    }
                    Map<String, Type.StructField> childColumTypes = childTableMapping.getColumTypes();
                    if (childColumTypes == null) {
                        throw new PersistenceException(String.format("Failed to add entry. Column '%s' is undefined", attributeName));
                    }
                    Type.StructField childAttributeType = childColumTypes.get(attributeName.toLowerCase());
                    for (Object value : attribute.getValues()) {
                        String dictDocId = this.getStringUniqueKey(messageDigest, value);
                        Mutation.WriteBuilder childMutationBuilder = Mutation.newInsertOrUpdateBuilder((String)childTableMapping.getTableName());
                        ((Mutation.WriteBuilder)childMutationBuilder.set("doc_id").to(key)).set("dict_doc_id").to(dictDocId);
                        this.setMutationBuilderValue(childMutationBuilder, childAttributeType, value);
                        mutations.add(childMutationBuilder.build());
                    }
                    continue;
                }
                this.setMutationBuilderValue(mutationBuilder, attributeType, attribute.getValues());
            }
            mutations.add(0, mutationBuilder.build());
            this.databaseClient.write(mutations);
            return true;
        }
        catch (SpannerException | IllegalStateException ex) {
            throw new PersistenceException("Failed to add entry", ex);
        }
    }

    @Override
    public boolean updateEntry(String key, String objectClass, List<AttributeDataModification> mods) throws UnsupportedOperationException, PersistenceException {
        Instant startTime = OperationDurationUtil.instance().now();
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        boolean result = this.updateEntryImpl(tableMapping, key, mods);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("SQL operation: modify, duration: {}, table: {}, key: {}, mods: {}", new Object[]{duration, tableMapping.getTableName(), key, mods});
        return result;
    }

    private boolean updateEntryImpl(TableMapping tableMapping, String key, List<AttributeDataModification> mods) throws PersistenceException {
        try {
            MessageDigest messageDigest = SpannerOperationServiceImpl.getMessageDigestInstance();
            Map<String, Type.StructField> columTypes = tableMapping.getColumTypes();
            Mutation.WriteBuilder mutationBuilder = (Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)tableMapping.getTableName()).set("doc_id").to(key);
            LinkedList<Mutation> mutations = new LinkedList<Mutation>();
            for (AttributeDataModification attributeMod : mods) {
                AttributeData attribute = attributeMod.getAttribute();
                AttributeDataModification.AttributeModificationType type = attributeMod.getModificationType();
                String attributeName = attribute.getName();
                Type.StructField attributeType = columTypes.get(attributeName.toLowerCase());
                if (attributeType == null) {
                    KeySet.Builder keySetBuilder;
                    String dictDocId;
                    TableMapping childTableMapping = this.connectionProvider.getChildTableMappingByKey(key, tableMapping, attributeName);
                    if (childTableMapping == null) {
                        throw new PersistenceException(String.format("Failed to update entry. Column '%s' is undefined", attributeName));
                    }
                    Map<String, Type.StructField> childColumTypes = childTableMapping.getColumTypes();
                    Type.StructField childAttributeType = childColumTypes.get(attributeName.toLowerCase());
                    HashMap<String, Object> oldValues = null;
                    if (attributeMod.getOldAttribute() != null && attributeMod.getOldAttribute().getValues() != null) {
                        oldValues = new HashMap<String, Object>();
                        for (Object oldValue : attributeMod.getOldAttribute().getValues()) {
                            String dictDocId2 = this.getStringUniqueKey(messageDigest, oldValue);
                            oldValues.put(dictDocId2, oldValue);
                        }
                    }
                    if (AttributeDataModification.AttributeModificationType.ADD == type || AttributeDataModification.AttributeModificationType.FORCE_UPDATE == type || AttributeDataModification.AttributeModificationType.REPLACE == type) {
                        for (Object value : attribute.getValues()) {
                            Mutation.WriteBuilder childMutationBuilder = Mutation.newInsertOrUpdateBuilder((String)childTableMapping.getTableName());
                            dictDocId = this.getStringUniqueKey(messageDigest, value);
                            ((Mutation.WriteBuilder)childMutationBuilder.set("doc_id").to(key)).set("dict_doc_id").to(dictDocId);
                            this.setMutationBuilderValue(childMutationBuilder, childAttributeType, value);
                            mutations.add(childMutationBuilder.build());
                            if (oldValues == null) continue;
                            oldValues.remove(dictDocId);
                        }
                    } else if (AttributeDataModification.AttributeModificationType.REMOVE == type) {
                        keySetBuilder = KeySet.newBuilder();
                        for (Object value : attribute.getValues()) {
                            dictDocId = this.getStringUniqueKey(messageDigest, value);
                            keySetBuilder.addKey(Key.of((Object[])new Object[]{key, dictDocId}));
                        }
                        Mutation childMutation = Mutation.delete((String)childTableMapping.getTableName(), (KeySet)keySetBuilder.build());
                        mutations.add(childMutation);
                    } else {
                        throw new UnsupportedOperationException("Operation type '" + type + "' is not implemented");
                    }
                    if (oldValues == null || oldValues.size() <= 0) continue;
                    keySetBuilder = KeySet.newBuilder();
                    for (String removeDictDocId : oldValues.keySet()) {
                        keySetBuilder.addKey(Key.of((Object[])new Object[]{key, removeDictDocId}));
                    }
                    Mutation childMutation = Mutation.delete((String)childTableMapping.getTableName(), (KeySet)keySetBuilder.build());
                    mutations.add(childMutation);
                    continue;
                }
                if (AttributeDataModification.AttributeModificationType.ADD == type || AttributeDataModification.AttributeModificationType.FORCE_UPDATE == type || AttributeDataModification.AttributeModificationType.REPLACE == type) {
                    this.setMutationBuilderValue(mutationBuilder, attributeType, attribute.getValues());
                    continue;
                }
                if (AttributeDataModification.AttributeModificationType.REMOVE == type) {
                    this.removeMutationBuilderValue(mutationBuilder, attribute, attributeType);
                    continue;
                }
                throw new UnsupportedOperationException("Operation type '" + type + "' is not implemented");
            }
            mutations.add(0, mutationBuilder.build());
            this.databaseClient.write(mutations);
            return true;
        }
        catch (SpannerException | IllegalStateException ex) {
            throw new PersistenceException("Failed to update entry", ex);
        }
    }

    @Override
    public boolean delete(String key, String objectClass) throws EntryNotFoundException {
        Instant startTime = OperationDurationUtil.instance().now();
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        boolean result = this.deleteImpl(tableMapping, key);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("SQL operation: delete, duration: {}, table: {}, key: {}", new Object[]{duration, tableMapping.getTableName(), key});
        return result;
    }

    private boolean deleteImpl(TableMapping tableMapping, String key) throws EntryNotFoundException {
        try {
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(Mutation.delete((String)tableMapping.getTableName(), (Key)Key.of((Object[])new Object[]{key})));
            this.databaseClient.write(mutations);
            return true;
        }
        catch (SpannerException ex) {
            throw new EntryNotFoundException("Failed to delete entry", (Throwable)ex);
        }
    }

    @Override
    public long delete(String key, String objectClass, ConvertedExpression expression, int count) throws DeleteException {
        Instant startTime = OperationDurationUtil.instance().now();
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        long result = this.deleteImpl(tableMapping, expression, count);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("SQL operation: delete_search, duration: {}, table: {}, key: {}, expression: {}, count: {}", new Object[]{duration, tableMapping.getTableName(), key, expression, count});
        return result;
    }

    private long deleteImpl(TableMapping tableMapping, ConvertedExpression expression, int count) throws DeleteException {
        try {
            Table table = this.buildTable(tableMapping);
            PlainSelect sqlSelectQuery = new PlainSelect();
            sqlSelectQuery.setFromItem((FromItem)table);
            Column selectDocIdColumn = new Column(this.tableAlias, "doc_id");
            SelectExpressionItem selectDocIdItem = new SelectExpressionItem((Expression)selectDocIdColumn);
            sqlSelectQuery.addSelectItems(new SelectItem[]{selectDocIdItem});
            this.applyWhereExpression(sqlSelectQuery, expression);
            long useCount = this.connectionProvider.getMaximumResultDeleteSize();
            if (count > 0) {
                useCount = Math.min((long)count, useCount);
            }
            Limit limit = new Limit();
            limit.setRowCount((Expression)new LongValue(useCount));
            sqlSelectQuery.setLimit(limit);
            SubSelect subSelect = new SubSelect();
            subSelect.setSelectBody((SelectBody)sqlSelectQuery);
            subSelect.withUseBrackets(true);
            InExpression inExpression = new InExpression((Expression)selectDocIdColumn, (ItemsList)subSelect);
            Delete sqlDeleteQuery = new Delete();
            sqlDeleteQuery.setTable(table);
            sqlDeleteQuery.setWhere((Expression)inExpression);
            Statement.Builder statementBuilder = Statement.newBuilder((String)sqlDeleteQuery.toString());
            this.applyParametersBinding(statementBuilder, expression);
            final Statement statement = statementBuilder.build();
            LOG.debug("Executing delete query: '{}'", (Object)statement);
            Long rowDeleted = (Long)this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

                public Long run(TransactionContext transaction) throws Exception {
                    long rowCount = transaction.executeUpdate(statement, new Options.UpdateOption[0]);
                    return rowCount;
                }
            });
            return rowDeleted;
        }
        catch (SpannerException | IncompatibleTypeException ex) {
            throw new DeleteException(String.format("Failed to delete entries. Expression: '%s'", expression.expression()), ex);
        }
    }

    @Override
    public boolean deleteRecursively(String key, String objectClass) throws EntryNotFoundException, SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        boolean result = this.deleteRecursivelyImpl(tableMapping, key);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("SQL operation: delete_tree, duration: {}, table: {}, key: {}", new Object[]{duration, tableMapping.getTableName(), key});
        return result;
    }

    private boolean deleteRecursivelyImpl(TableMapping tableMapping, String key) throws SearchException, EntryNotFoundException {
        LOG.warn("Removing only base key without sub-tree. Table: {}, Key: {}", (Object)tableMapping.getTableName(), (Object)key);
        return this.deleteImpl(tableMapping, key);
    }

    @Override
    public List<AttributeData> lookup(String key, String objectClass, String ... attributes) throws SearchException, EntryConvertationException {
        Instant startTime = OperationDurationUtil.instance().now();
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        List<AttributeData> result = this.lookupImpl(tableMapping, key, attributes);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("SQL operation: lookup, duration: {}, table: {}, key: {}, attributes: {}", new Object[]{duration, tableMapping.getTableName(), key, attributes});
        return result;
    }

    private List<AttributeData> lookupImpl(TableMapping tableMapping, String key, String ... attributes) throws SearchException, EntryConvertationException {
        try {
            String tableName = tableMapping.getTableName();
            Set<String> childTables = this.connectionProvider.getTableChildAttributes(tableName);
            List<AttributeData> result = null;
            if (childTables == null) {
                if (attributes == null) {
                    try (ResultSet resultSet = this.databaseClient.singleUse().read(tableName, KeySet.singleKey((Key)Key.of((Object[])new Object[]{key})), tableMapping.getColumTypes().keySet(), new Options.ReadOption[0]);){
                        result = this.getAttributeDataList(tableMapping.getObjectClass(), resultSet, true);
                    }
                } else {
                    try (ResultSet resultSet = this.databaseClient.singleUse().read(tableName, KeySet.singleKey((Key)Key.of((Object[])new Object[]{key})), Arrays.asList(attributes), new Options.ReadOption[0]);){
                        result = this.getAttributeDataList(tableMapping.getObjectClass(), resultSet, true);
                    }
                }
            } else {
                Table table = this.buildTable(tableMapping);
                PlainSelect sqlSelectQuery = new PlainSelect();
                sqlSelectQuery.setFromItem((FromItem)table);
                List<SelectItem> selectItems = this.buildSelectAttributes(tableMapping, key, attributes);
                sqlSelectQuery.addSelectItems(selectItems);
                Column leftColumn = new Column(this.tableAlias, "doc_id");
                UserVariable rightValue = new UserVariable("doc_id");
                EqualsTo whereExp = new EqualsTo((Expression)leftColumn, (Expression)rightValue);
                sqlSelectQuery.setWhere((Expression)whereExp);
                Limit limit = new Limit();
                limit.setRowCount((Expression)new LongValue(1L));
                sqlSelectQuery.setLimit(limit);
                Statement statement = ((Statement.Builder)Statement.newBuilder((String)sqlSelectQuery.toString()).bind("doc_id").to(key)).build();
                LOG.debug("Executing lookup query: '{}'", (Object)statement);
                try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
                    result = this.getAttributeDataList(tableMapping.getObjectClass(), resultSet, true);
                }
            }
            if (result != null) {
                return result;
            }
        }
        catch (SpannerException ex) {
            throw new SearchException(String.format("Failed to lookup query by key: '%s'", key), (Throwable)ex);
        }
        throw new SearchException(String.format("Failed to lookup entry by key: '%s'", key));
    }

    @Override
    public <O> PagedResult<EntryData> search(String key, String objectClass, ConvertedExpression expression, SearchScope scope, String[] attributes, Sort[] orderBy, SpannerBatchOperationWraper<O> batchOperationWraper, SearchReturnDataType returnDataType, int start, int count, int pageSize) throws SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        PagedResult<EntryData> result = this.searchImpl(tableMapping, key, expression, scope, attributes, orderBy, batchOperationWraper, returnDataType, start, count, pageSize);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("SQL operation: search, duration: {}, table: {}, key: {}, expression: {}, scope: {}, attributes: {}, orderBy: {}, batchOperationWraper: {}, returnDataType: {}, start: {}, count: {}, pageSize: {}", new Object[]{duration, tableMapping.getTableName(), key, expression, scope, attributes, orderBy, batchOperationWraper, returnDataType, start, count, pageSize});
        return result;
    }

    private <O> PagedResult<EntryData> searchImpl(TableMapping tableMapping, String key, ConvertedExpression expression, SearchScope scope, String[] attributes, Sort[] orderBy, SpannerBatchOperationWraper<O> batchOperationWraper, SearchReturnDataType returnDataType, int start, int count, int pageSize) throws SearchException {
        BatchOperation<O> batchOperation = null;
        if (batchOperationWraper != null) {
            batchOperation = batchOperationWraper.getBatchOperation();
        }
        Table table = this.buildTable(tableMapping);
        PlainSelect sqlSelectQuery = new PlainSelect();
        sqlSelectQuery.setFromItem((FromItem)table);
        List<SelectItem> selectItems = this.buildSelectAttributes(tableMapping, key, attributes);
        sqlSelectQuery.addSelectItems(selectItems);
        if (expression != null) {
            this.applyWhereExpression(sqlSelectQuery, expression);
        }
        if (orderBy != null) {
            OrderByElement[] orderByElements = new OrderByElement[orderBy.length];
            for (int i = 0; i < orderBy.length; ++i) {
                Column column = new Column(orderBy[i].getName());
                orderByElements[i] = new OrderByElement();
                orderByElements[i].setExpression((Expression)column);
                if (orderBy[i].getSortOrder() == null) continue;
                orderByElements[i].setAscDescPresent(true);
                orderByElements[i].setAsc(SortOrder.ASCENDING == orderBy[i].getSortOrder());
            }
            sqlSelectQuery.withOrderByElements(Arrays.asList(orderByElements));
        }
        LinkedList<EntryData> searchResultList = new LinkedList<EntryData>();
        if (SearchReturnDataType.SEARCH == returnDataType || SearchReturnDataType.SEARCH_COUNT == returnDataType) {
            List<EntryData> lastResult = null;
            if (pageSize > 0) {
                Limit limit = new Limit();
                sqlSelectQuery.setLimit(limit);
                Offset offset = new Offset();
                sqlSelectQuery.setOffset(offset);
                try {
                    int resultCount = 0;
                    int lastCountRows = 0;
                    do {
                        boolean collectSearchResult = true;
                        int currentLimit = pageSize;
                        if (count > 0) {
                            currentLimit = Math.min(pageSize, count - resultCount);
                        }
                        limit.setRowCount((Expression)new LongValue((long)currentLimit));
                        offset.setOffset((long)(start + resultCount));
                        Statement.Builder statementBuilder = Statement.newBuilder((String)sqlSelectQuery.toString());
                        this.applyParametersBinding(statementBuilder, expression);
                        Statement statement = statementBuilder.build();
                        LOG.debug("Executing query: '{}'", (Object)statement);
                        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
                            lastResult = this.getEntryDataList(tableMapping.getObjectClass(), resultSet);
                        }
                        lastCountRows = lastResult.size();
                        if (batchOperation != null) {
                            collectSearchResult = batchOperation.collectSearchResult(lastCountRows);
                        }
                        if (collectSearchResult) {
                            searchResultList.addAll(lastResult);
                        }
                        if (batchOperation == null) continue;
                        List<O> entries = batchOperationWraper.createEntities(lastResult);
                        batchOperation.performAction(entries);
                    } while ((count <= 0 || (resultCount += lastCountRows) < count) && lastCountRows > 0);
                }
                catch (SpannerException | EntryConvertationException | IncompatibleTypeException ex) {
                    LOG.error("Failed to execute query with expression: '{}'", (Object)expression);
                    throw new SearchException(String.format("Failed to execute query '%s'  with key: '%s'", sqlSelectQuery, key), ex);
                }
            }
            try {
                long currentLimit = count;
                if (currentLimit <= 0L) {
                    currentLimit = this.connectionProvider.getDefaultMaximumResultSize();
                }
                Limit limit = new Limit();
                limit.setRowCount((Expression)new LongValue(currentLimit));
                sqlSelectQuery.setLimit(limit);
                if (start > 0) {
                    Offset offset = new Offset();
                    offset.setOffset((long)start);
                    sqlSelectQuery.setOffset(offset);
                }
                Statement.Builder statementBuilder = Statement.newBuilder((String)sqlSelectQuery.toString());
                this.applyParametersBinding(statementBuilder, expression);
                Statement statement = statementBuilder.build();
                LOG.debug("Executing query: '{}'", (Object)statement);
                try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
                    lastResult = this.getEntryDataList(tableMapping.getObjectClass(), resultSet);
                    searchResultList.addAll(lastResult);
                }
            }
            catch (SpannerException | EntryConvertationException | IncompatibleTypeException ex) {
                LOG.error("Failed to execute query with expression: '{}'", (Object)expression);
                throw new SearchException(String.format("Failed to execute query '%s'  with key: '%s'", sqlSelectQuery, key), ex);
            }
        }
        PagedResult result = new PagedResult();
        result.setEntries(searchResultList);
        result.setEntriesCount(searchResultList.size());
        result.setStart(start);
        if (SearchReturnDataType.COUNT == returnDataType || SearchReturnDataType.SEARCH_COUNT == returnDataType) {
            PlainSelect sqlCountSelectQuery = new PlainSelect();
            sqlCountSelectQuery.setFromItem((FromItem)table);
            Function countFunction = new Function();
            countFunction.setName("COUNT");
            countFunction.setAllColumns(true);
            SelectExpressionItem selectCountItem = new SelectExpressionItem((Expression)countFunction);
            selectCountItem.setAlias(new Alias("TOTAL", false));
            sqlCountSelectQuery.addSelectItems(new SelectItem[]{selectCountItem});
            if (expression != null) {
                this.applyWhereExpression(sqlCountSelectQuery, expression);
            }
            try {
                Statement.Builder statementBuilder = Statement.newBuilder((String)sqlCountSelectQuery.toString());
                this.applyParametersBinding(statementBuilder, expression);
                Statement statement = statementBuilder.build();
                LOG.debug("Calculating count. Executing query: '{}'", (Object)statement);
                try (ResultSet countResult = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
                    if (!countResult.next()) {
                        throw new SearchException(String.format("Failed to calculate count entries. Query: '%s'", statement));
                    }
                    result.setTotalEntriesCount((int)countResult.getLong("TOTAL"));
                }
            }
            catch (SpannerException | IncompatibleTypeException ex) {
                LOG.error("Failed to execute query with expression: '{}'", (Object)expression);
                throw new SearchException(String.format("Failed to build count search entries query. Key: '%s', expression: '%s'", key, expression.expression()), ex);
            }
        }
        return result;
    }

    @Override
    public String[] createStoragePassword(String[] passwords) {
        if (ArrayHelper.isEmpty((Object[])passwords)) {
            return passwords;
        }
        String[] results = new String[passwords.length];
        for (int i = 0; i < passwords.length; ++i) {
            results[i] = this.persistenceExtension == null ? PasswordEncryptionHelper.createStoragePassword((String)passwords[i], (PasswordEncryptionMethod)this.connectionProvider.getPasswordEncryptionMethod()) : this.persistenceExtension.createHashedPassword(passwords[i]);
        }
        return results;
    }

    private List<AttributeData> getAttributeDataList(String objectClass, ResultSet resultSet, boolean skipDn) throws EntryConvertationException {
        try {
            if (resultSet == null) {
                return null;
            }
            if (!resultSet.next()) {
                return null;
            }
            ArrayList<AttributeData> result = new ArrayList<AttributeData>();
            Set<String> nullableColumns = this.connectionProvider.getTableNullableColumns(objectClass);
            List structFields = resultSet.getType().getStructFields();
            int columnsCount = resultSet.getColumnCount();
            for (int i = 0; i < columnsCount; ++i) {
                Object[] attributeValueObjects;
                Type.StructField structField = (Type.StructField)structFields.get(i);
                String attributeName = structField.getName();
                Type.Code columnTypeCode = structField.getType().getCode();
                boolean isNullable = nullableColumns.contains(attributeName.toLowerCase());
                if ("doc_id".equalsIgnoreCase(attributeName) || "id".equalsIgnoreCase(attributeName) || skipDn && "dn".equalsIgnoreCase(attributeName)) continue;
                Boolean multiValued = Boolean.FALSE;
                if (resultSet.isNull(i)) {
                    attributeValueObjects = NO_OBJECTS;
                    if (isNullable) {
                        continue;
                    }
                } else if (Type.Code.ARRAY == columnTypeCode) {
                    attributeValueObjects = this.convertDbArrayToValue(resultSet, structField.getType().getArrayElementType(), i, attributeName);
                    multiValued = Boolean.TRUE;
                } else if (Type.Code.BOOL == columnTypeCode) {
                    attributeValueObjects = new Object[]{resultSet.getBoolean(i)};
                } else if (Type.Code.DATE == columnTypeCode) {
                    attributeValueObjects = new Object[]{Date.toJavaUtilDate((Date)resultSet.getDate(i))};
                } else if (Type.Code.TIMESTAMP == columnTypeCode) {
                    attributeValueObjects = new Object[]{resultSet.getTimestamp(i).toDate()};
                } else if (Type.Code.INT64 == columnTypeCode) {
                    attributeValueObjects = new Object[]{resultSet.getLong(i)};
                } else if (Type.Code.NUMERIC == columnTypeCode) {
                    attributeValueObjects = new Object[]{resultSet.getBigDecimal(i).longValue()};
                } else if (Type.Code.STRING == columnTypeCode) {
                    String value = resultSet.getString(i);
                    try {
                        value = Timestamp.parseTimestamp((String)value.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    attributeValueObjects = new Object[]{value};
                } else {
                    throw new EntryConvertationException(String.format("Column with name '%s' does not contain unsupported type '%s'", attributeName, columnTypeCode));
                }
                this.unescapeValues(attributeValueObjects);
                AttributeData tmpAttribute = new AttributeData(attributeName, attributeValueObjects, multiValued);
                if (multiValued != null) {
                    tmpAttribute.setMultiValued(multiValued);
                }
                result.add(tmpAttribute);
            }
            return result;
        }
        catch (SpannerException ex) {
            throw new EntryConvertationException("Failed to convert entry!", (Throwable)ex);
        }
    }

    private List<EntryData> getEntryDataList(String objectClass, ResultSet resultSet) throws EntryConvertationException {
        LinkedList<EntryData> entryDataList = new LinkedList<EntryData>();
        List<AttributeData> attributeDataList = null;
        do {
            if ((attributeDataList = this.getAttributeDataList(objectClass, resultSet, false)) == null) continue;
            EntryData entryData = new EntryData(attributeDataList);
            entryDataList.add(entryData);
        } while (attributeDataList != null);
        return entryDataList;
    }

    @Override
    public boolean isBinaryAttribute(String attribute) {
        return this.connectionProvider.isBinaryAttribute(attribute);
    }

    @Override
    public boolean isCertificateAttribute(String attribute) {
        return this.connectionProvider.isCertificateAttribute(attribute);
    }

    public boolean isDisableAttributeMapping() {
        return this.disableAttributeMapping;
    }

    @Override
    public boolean destroy() {
        boolean result = true;
        if (this.connectionProvider != null) {
            try {
                this.connectionProvider.destroy();
            }
            catch (Exception ex) {
                LOG.error("Failed to destroy provider correctly");
                result = false;
            }
        }
        return result;
    }

    public boolean isConnected() {
        return this.connectionProvider.isConnected();
    }

    @Override
    public DatabaseClient getConnection() {
        return this.connectionProvider.getClient();
    }

    @Override
    public Map<String, Map<String, Type.StructField>> getMetadata() {
        return this.connectionProvider.getDatabaseMetaData();
    }

    @Override
    public TableMapping getTabeMapping(String key, String objectClass) {
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        Map<String, TableMapping> childTableMapping = this.connectionProvider.getChildTablesMapping(key, tableMapping);
        tableMapping.setChildTableMapping(childTableMapping);
        return tableMapping;
    }

    @Override
    public Set<String> getTabeChildAttributes(String objectClass) {
        return this.connectionProvider.getTableChildAttributes(objectClass);
    }

    public void setPersistenceExtension(PersistenceExtension persistenceExtension) {
        this.persistenceExtension = persistenceExtension;
    }

    public boolean isSupportObjectClass(String objectClass) {
        return this.connectionProvider.getDatabaseMetaData().containsKey(objectClass);
    }

    private List<SelectItem> buildSelectAttributes(TableMapping tableMapping, String key, String ... attributes) throws SearchException {
        String tableName = tableMapping.getTableName();
        Map<String, Type.StructField> columTypes = tableMapping.getColumTypes();
        Column selectDnColumn = new Column(this.tableAlias, "dn");
        SelectExpressionItem selectDnItem = new SelectExpressionItem((Expression)selectDnColumn);
        Column selectDocIdColumn = new Column(this.tableAlias, "doc_id");
        SelectExpressionItem selectDocIdItem = new SelectExpressionItem((Expression)selectDocIdColumn);
        if (ArrayHelper.isEmpty((Object[])attributes)) {
            AllTableColumns allColumns = new AllTableColumns(this.tableAlias);
            ArrayList<SelectItem> selectColumns = new ArrayList<SelectItem>();
            selectColumns.add((SelectItem)allColumns);
            List<SelectExpressionItem> selectChildColumns = this.buildSelectAttributeFromChildTables(tableName);
            selectColumns.addAll(selectChildColumns);
            return selectColumns;
        }
        if (attributes.length == 1 && StringHelper.isEmpty((String)attributes[0])) {
            List<SelectItem> selectColumns = Arrays.asList(selectDnItem, selectDocIdItem);
            List<SelectExpressionItem> selectChildColumns = this.buildSelectAttributeFromChildTables(tableName);
            selectColumns.addAll(selectChildColumns);
            return selectColumns;
        }
        ArrayList<SelectItem> expresisons = new ArrayList<SelectItem>(attributes.length + 2);
        boolean hasDn = false;
        for (String attributeName : attributes) {
            SelectExpressionItem selectExpressionItem;
            Type.StructField attributeType = columTypes.get(attributeName.toLowerCase());
            if (attributeType == null) {
                TableMapping childTableMapping = this.connectionProvider.getChildTableMappingByKey(key, tableMapping, attributeName);
                if (childTableMapping == null) {
                    throw new SearchException(String.format("Failed to build select attributes. Column '%s' is undefined", attributeName));
                }
                selectExpressionItem = this.buildSelectAttributeFromChildTable(tableName, attributeName);
            } else {
                Column selectColumn = new Column(this.tableAlias, attributeName);
                selectExpressionItem = new SelectExpressionItem((Expression)selectColumn);
            }
            expresisons.add((SelectItem)selectExpressionItem);
            hasDn |= StringHelper.equals((String)attributeName, (String)"dn");
        }
        if (!hasDn) {
            expresisons.add((SelectItem)selectDnItem);
        }
        expresisons.add((SelectItem)selectDocIdItem);
        return expresisons;
    }

    private Table buildTable(TableMapping tableMapping) {
        Table tableRelationalPath = new Table(tableMapping.getTableName());
        tableRelationalPath.setAlias(new Alias("doc", false));
        return tableRelationalPath;
    }

    private List<SelectExpressionItem> buildSelectAttributeFromChildTables(String tableName) {
        ArrayList<Object> selectChildColumns = new ArrayList<SelectExpressionItem>();
        Set<String> childAttributes = this.connectionProvider.getTableChildAttributes(tableName);
        if (childAttributes != null) {
            selectChildColumns = new ArrayList();
            for (String childAttribute : childAttributes) {
                SelectExpressionItem selectChildColumn = this.buildSelectAttributeFromChildTable(tableName, childAttribute);
                selectChildColumns.add(selectChildColumn);
            }
        }
        return selectChildColumns;
    }

    private SelectExpressionItem buildSelectAttributeFromChildTable(String tableName, String childAttribute) {
        Function arrayFunction = new Function();
        arrayFunction.setName("ARRAY");
        arrayFunction.setAllColumns(false);
        SelectExpressionItem arraySelectItem = new SelectExpressionItem((Expression)arrayFunction);
        arraySelectItem.setAlias(new Alias(childAttribute, false));
        PlainSelect attrSelect = new PlainSelect();
        SubSelect attrSubSelect = new SubSelect();
        attrSubSelect.setSelectBody((SelectBody)attrSelect);
        attrSubSelect.withUseBrackets(false);
        arrayFunction.setParameters(new ExpressionList(new Expression[]{attrSubSelect}));
        Table attrTableSelect = new Table(tableName + "_" + childAttribute);
        attrTableSelect.setAlias(new Alias("c", false));
        attrSelect.setFromItem((FromItem)attrTableSelect);
        Column attrSelectColumn = new Column(attrTableSelect, childAttribute);
        attrSelect.addSelectItems(new SelectItem[]{new SelectExpressionItem((Expression)attrSelectColumn)});
        Column attrLeftColumn = new Column(this.tableAlias, "doc_id");
        Column attrRightColumn = new Column(attrTableSelect, "doc_id");
        EqualsTo attrEquals = new EqualsTo((Expression)attrLeftColumn, (Expression)attrRightColumn);
        attrSelect.withWhere((Expression)attrEquals);
        return arraySelectItem;
    }

    @Override
    public String escapeValue(String value) {
        return value;
    }

    @Override
    public void escapeValues(Object[] realValues) {
    }

    @Override
    public String unescapeValue(String value) {
        return value;
    }

    @Override
    public void unescapeValues(Object[] realValues) {
    }

    @Override
    public String toInternalAttribute(String attributeName) {
        return attributeName;
    }

    @Override
    public String[] toInternalAttributes(String[] attributeNames) {
        return attributeNames;
    }

    @Override
    public String fromInternalAttribute(String internalAttributeName) {
        return internalAttributeName;
    }

    @Override
    public String[] fromInternalAttributes(String[] internalAttributeNames) {
        return internalAttributeNames;
    }

    private void applyParametersBinding(Statement.Builder builder, ConvertedExpression expression) throws IncompatibleTypeException {
        if (expression == null) {
            return;
        }
        Map<String, ValueWithStructField> queryParameters = expression.queryParameters();
        for (Map.Entry<String, ValueWithStructField> queryParameterEntry : queryParameters.entrySet()) {
            String attributeName = queryParameterEntry.getKey();
            ValueWithStructField valueWithStructField = queryParameterEntry.getValue();
            ValueBinder valueBinder = builder.bind(attributeName);
            this.setMutationBuilderValue(valueBinder, valueWithStructField.getStructField(), true, valueWithStructField.getValue());
        }
    }

    private void applyWhereExpression(Delete sqlDeleteQuery, ConvertedExpression expression) {
        if (expression == null) {
            return;
        }
        Expression whereExp = expression.expression();
        sqlDeleteQuery.setWhere(whereExp);
        Map<String, Join> joinTables = expression.joinTables();
        if (joinTables != null) {
            sqlDeleteQuery.setJoins(new ArrayList<Join>(joinTables.values()));
        }
    }

    private void applyWhereExpression(PlainSelect sqlSelectQuery, ConvertedExpression expression) {
        if (expression == null) {
            return;
        }
        Expression whereExp = expression.expression();
        sqlSelectQuery.setWhere(whereExp);
        Map<String, Join> joinTables = expression.joinTables();
        if (joinTables != null && joinTables.size() > 0) {
            sqlSelectQuery.setJoins(new ArrayList<Join>(joinTables.values()));
        }
    }

    private void setMutationBuilderValue(Mutation.WriteBuilder mutation, Type.StructField attributeType, Object ... values) throws IncompatibleTypeException {
        ValueBinder valueBinder = mutation.set(attributeType.getName());
        this.setMutationBuilderValue(valueBinder, attributeType, false, values);
    }

    private void setMutationBuilderValue(ValueBinder<?> valueBinder, Type.StructField attributeType, boolean useArrayElementType, Object ... values) throws IncompatibleTypeException {
        if (values == null || values.length == 0) {
            return;
        }
        Type.Code typeCode = attributeType.getType().getCode();
        if (useArrayElementType && Type.Code.ARRAY == typeCode) {
            typeCode = attributeType.getType().getArrayElementType().getCode();
        }
        if (Type.Code.BOOL == typeCode) {
            valueBinder.to(SpannerValueHelper.toBoolean((Object)values[0]));
        } else if (Type.Code.DATE == typeCode) {
            valueBinder.to(SpannerValueHelper.toGoogleDate(values[0]));
        } else if (Type.Code.TIMESTAMP == typeCode) {
            valueBinder.to(SpannerValueHelper.toGoogleTimestamp(values[0]));
        } else if (Type.Code.INT64 == typeCode) {
            valueBinder.to(SpannerValueHelper.toLong((Object)values[0]));
        } else if (Type.Code.NUMERIC == typeCode) {
            valueBinder.to(SpannerValueHelper.toBigDecimal((Object)values[0]));
        } else if (Type.Code.STRING == typeCode) {
            Object value = values[0];
            if (value instanceof java.util.Date) {
                valueBinder.to(SpannerValueHelper.toGoogleTimestamp(value).toString());
            } else {
                valueBinder.to(SpannerValueHelper.toString((Object)value));
            }
        } else if (Type.Code.ARRAY == typeCode) {
            Type.Code arrayCode = attributeType.getType().getArrayElementType().getCode();
            if (Type.Code.BOOL == arrayCode) {
                valueBinder.toBoolArray((Iterable)SpannerValueHelper.toBooleanList((Object[])values));
            } else if (Type.Code.DATE == arrayCode) {
                valueBinder.toDateArray(SpannerValueHelper.toGoogleDateList(values));
            } else if (Type.Code.TIMESTAMP == arrayCode) {
                valueBinder.toTimestampArray(SpannerValueHelper.toGoogleTimestampList(values));
            } else if (Type.Code.INT64 == arrayCode) {
                valueBinder.toInt64Array((Iterable)SpannerValueHelper.toLongList((Object[])values));
            } else if (Type.Code.NUMERIC == arrayCode) {
                valueBinder.toNumericArray((Iterable)SpannerValueHelper.toBigDecimalList((Object[])values));
            } else if (Type.Code.STRING == arrayCode) {
                valueBinder.toStringArray((Iterable)SpannerValueHelper.toStringList((Object[])values));
            }
        } else {
            throw new IncompatibleTypeException(String.format("Array column with name '%s' does not contain supported type '%s'", attributeType.getName(), attributeType.getType()));
        }
    }

    private void removeMutationBuilderValue(Mutation.WriteBuilder mutation, AttributeData attribute, Type.StructField attributeType) throws EntryConvertationException {
        ValueBinder valueBinder = mutation.set(attributeType.getName());
        Type.Code typeCode = attributeType.getType().getCode();
        if (Type.Code.BOOL == typeCode) {
            valueBinder.to((Boolean)null);
        } else if (Type.Code.DATE == typeCode) {
            valueBinder.to((Date)null);
        } else if (Type.Code.TIMESTAMP == typeCode) {
            valueBinder.to((Timestamp)null);
        } else if (Type.Code.INT64 == typeCode) {
            valueBinder.to((Long)null);
        } else if (Type.Code.NUMERIC == typeCode) {
            valueBinder.to((BigDecimal)null);
        } else if (Type.Code.STRING == typeCode) {
            valueBinder.to((String)null);
        } else if (Type.Code.ARRAY == typeCode) {
            Type.Code arrayCode = attributeType.getType().getArrayElementType().getCode();
            if (Type.Code.BOOL == arrayCode) {
                valueBinder.toBoolArray((boolean[])null);
            } else if (Type.Code.DATE == arrayCode) {
                valueBinder.toDateArray((Iterable)null);
            } else if (Type.Code.TIMESTAMP == arrayCode) {
                valueBinder.toTimestampArray((Iterable)null);
            } else if (Type.Code.INT64 == arrayCode) {
                valueBinder.toInt64Array((long[])null);
            } else if (Type.Code.NUMERIC == arrayCode) {
                valueBinder.toNumericArray((Iterable)null);
            } else if (Type.Code.STRING == arrayCode) {
                valueBinder.toStringArray((Iterable)null);
            }
        } else {
            throw new EntryConvertationException(String.format("Array column with name '%s' does not contain supported type '%s'", attribute.getName(), attributeType));
        }
    }

    private Object[] convertDbArrayToValue(ResultSet resultSet, Type elementType, int columnIndex, String attributeName) throws EntryConvertationException {
        Type.Code elementCode = elementType.getCode();
        if (Type.Code.BOOL == elementCode) {
            return resultSet.getBooleanList(columnIndex).toArray(NO_OBJECTS);
        }
        if (Type.Code.DATE == elementCode) {
            return SpannerValueHelper.toJavaDateArrayFromSpannerDateList(resultSet.getDateList(columnIndex));
        }
        if (Type.Code.TIMESTAMP == elementCode) {
            return SpannerValueHelper.toJavaDateArrayFromSpannerTimestampList(resultSet.getTimestampList(columnIndex));
        }
        if (Type.Code.INT64 == elementCode) {
            return resultSet.getLongList(columnIndex).toArray(NO_OBJECTS);
        }
        if (Type.Code.NUMERIC == elementCode) {
            return SpannerValueHelper.toJavaLongArrayFromBigDecimalList((List)resultSet.getBigDecimalList(columnIndex));
        }
        if (Type.Code.STRING == elementCode) {
            return resultSet.getStringList(columnIndex).toArray(NO_OBJECTS);
        }
        throw new EntryConvertationException(String.format("Array column with name '%s' does not contain supported type '%s'", attributeName, elementType));
    }

    public String getStringUniqueKey(MessageDigest messageDigest, Object value) {
        if (value == null) {
            return "null";
        }
        String str = StringHelper.toString((Object)value);
        byte[] digest = messageDigest.digest(str.getBytes(StandardCharsets.UTF_8));
        return Hex.encodeHexString((byte[])digest);
    }

    public static MessageDigest getMessageDigestInstance() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-256 is not available!");
        }
        return messageDigest;
    }
}

