/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.cloud.spanner.impl;

import java.util.HashMap;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import org.gluu.orm.util.PropertiesHelper;
import org.gluu.orm.util.StringHelper;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.PersistenceEntryManagerFactory;
import org.gluu.persist.cloud.spanner.impl.SpannerEntryManager;
import org.gluu.persist.cloud.spanner.operation.impl.SpannerConnectionProvider;
import org.gluu.persist.cloud.spanner.operation.impl.SpannerOperationServiceImpl;
import org.gluu.persist.exception.operation.ConfigurationException;
import org.gluu.persist.service.BaseFactoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SpannerEntryManagerFactory
implements PersistenceEntryManagerFactory {
    public static final String PERSISTENCE_TYPE = PersistenceEntryManager.PERSITENCE_TYPES.spanner.name();
    public static final String PROPERTIES_FILE = "gluu-spanner%s.properties";
    private static final Logger LOG = LoggerFactory.getLogger(SpannerEntryManagerFactory.class);

    @PostConstruct
    public void create() {
    }

    @PreDestroy
    public void destroy() {
    }

    public String getPersistenceType() {
        return PERSISTENCE_TYPE;
    }

    public HashMap<String, String> getConfigurationFileNames(String alias) {
        String usedAlias = StringHelper.isEmpty((String)alias) ? "" : "." + alias;
        HashMap<String, String> confs = new HashMap<String, String>();
        String confFileName = String.format(PROPERTIES_FILE, usedAlias);
        confs.put(PERSISTENCE_TYPE + usedAlias, confFileName);
        return confs;
    }

    public SpannerEntryManager createEntryManager(Properties conf) {
        Properties entryManagerConf = PropertiesHelper.filterProperties((Properties)conf, (String)"#");
        SpannerConnectionProvider connectionProvider = new SpannerConnectionProvider(entryManagerConf);
        connectionProvider.create();
        if (!connectionProvider.isCreated()) {
            throw new ConfigurationException(String.format("Failed to create Spanner connection pool! Result code: '%s'", connectionProvider.getCreationResultCode()));
        }
        LOG.debug("Created connectionProvider '{}' with code '{}'", (Object)connectionProvider, (Object)connectionProvider.getCreationResultCode());
        SpannerEntryManager sqlEntryManager = new SpannerEntryManager(new SpannerOperationServiceImpl(entryManagerConf, connectionProvider));
        LOG.info("Created SpannerEntryManager: {}", (Object)sqlEntryManager.getOperationService());
        return sqlEntryManager;
    }

    public void initStandalone(BaseFactoryService persistanceFactoryService) {
    }
}

