<!--
  ! CDDL HEADER START
  !
  ! The contents of this file are subject to the terms of the
  ! Common Development and Distribution License, Version 1.0 only
  ! (the "License").  You may not use this file except in compliance
  ! with the License.
  !
  ! You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
  ! or http://forgerock.org/license/CDDLv1.0.html.
  ! See the License for the specific language governing permissions
  ! and limitations under the License.
  !
  ! When distributing Covered Code, include this CDDL HEADER in each
  ! file and include the License file at legal-notices/CDDLv1_0.txt.
  ! If applicable, add the following below this CDDL HEADER, with the
  ! fields enclosed by brackets "[]" replaced with your own identifying
  ! information:
  !      Portions Copyright [yyyy] [name of copyright owner]
  !
  ! CDDL HEADER END
  !
  !
  !      Copyright 2008 Sun Microsystems, Inc.
  ! -->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:adm="http://www.opends.org/admin"
  xmlns:ldap="http://www.opends.org/admin-ldap">
  <xsl:import href="java-utilities.xsl" />
  <xsl:import href="preprocessor.xsl" />
  <xsl:import href="property-types.xsl" />
  <xsl:output method="text" encoding="us-ascii" />
  <!--
    Document parsing.
  -->
  <xsl:template match="/">
    <xsl:if
      test="not($this/adm:profile[@name='ldap']/ldap:object-class/ldap:name) and not($this-is-root)">
      <xsl:message terminate="yes">
        <xsl:value-of
          select="concat('No object class found for managed object definition ', $this-name)" />
      </xsl:message>
    </xsl:if>
    <xsl:value-of
      select="concat('objectclass=',
                     normalize-space($this/adm:profile[@name='ldap']/ldap:object-class/ldap:name),
                     '&#xa;')" />
    <xsl:for-each select="$this-all-properties">
      <xsl:sort select="@name" />
      <xsl:if
        test="not(adm:profile[@name='ldap']/ldap:attribute/ldap:name)">
        <xsl:message terminate="yes">
          <xsl:value-of
            select="concat('No attribute type found for property ', @name, ' in managed object definition ', $this-name)" />
        </xsl:message>
      </xsl:if>
      <xsl:value-of
        select="concat('attribute.',
                       normalize-space(@name),
                       '=',
                       normalize-space(adm:profile[@name='ldap']/ldap:attribute/ldap:name),
                       '&#xa;')" />
    </xsl:for-each>
    <xsl:for-each select="$this-all-relations">
      <xsl:sort select="@name" />
      <xsl:if test="not(adm:profile[@name='ldap']/ldap:rdn-sequence)">
        <xsl:message terminate="yes">
          <xsl:value-of
            select="concat('No RDN sequence found for relation ', @name, ' in managed object definition ', $this-name)" />
        </xsl:message>
      </xsl:if>
      <xsl:value-of
        select="concat('rdn.',
                       normalize-space(@name),
                       '=',
                       normalize-space(adm:profile[@name='ldap']/ldap:rdn-sequence),
                       '&#xa;')" />
      <xsl:choose>
        <xsl:when
          test="adm:profile[@name='ldap']/ldap:naming-attribute">
          <xsl:if test="not(adm:one-to-many)">
            <xsl:message terminate="yes">
              <xsl:value-of
                select="concat('Naming attribute specified for relation ',
                               @name, ' in managed object definition ',
                               $this-name, ' which is not a one-to-many relation.')" />
            </xsl:message>
          </xsl:if>
          <xsl:if test="adm:one-to-many/@naming-property">
            <xsl:message terminate="yes">
              <xsl:value-of
                select="concat('Naming attribute specified for one-to-many relation ',
                               @name, ' in managed object definition ',
                               $this-name, ' which uses a naming property.')" />
            </xsl:message>
          </xsl:if>
          <xsl:value-of
            select="concat('naming-attribute.',
                       normalize-space(@name),
                       '=',
                       normalize-space(adm:profile[@name='ldap']/ldap:naming-attribute),
                       '&#xa;')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of
            select="concat('naming-attribute.', normalize-space(@name), '=cn&#xa;')" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
