/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.CliMessages;
import java.util.Collection;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;

public final class MultiChoiceArgument<T>
extends Argument {
    private final boolean caseSensitive;
    private final Collection<T> allowedValues;

    public MultiChoiceArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean isMultiValued, boolean needsValue, LocalizableMessage valuePlaceholder, String defaultValue, String propertyName, Collection<T> allowedValues, boolean caseSensitive, LocalizableMessage description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, isMultiValued, needsValue, valuePlaceholder, defaultValue, propertyName, description);
        this.allowedValues = allowedValues;
        this.caseSensitive = caseSensitive;
    }

    public MultiChoiceArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean needsValue, LocalizableMessage valuePlaceholder, Collection<T> allowedValues, boolean caseSensitive, LocalizableMessage description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, false, needsValue, valuePlaceholder, null, null, description);
        this.allowedValues = allowedValues;
        this.caseSensitive = caseSensitive;
    }

    public Collection<T> getAllowedValues() {
        return this.allowedValues;
    }

    public T getTypedValue() throws ArgumentException {
        String v = super.getValue();
        if (v == null) {
            return null;
        }
        for (T o : this.allowedValues) {
            if ((!this.caseSensitive || !o.toString().equals(v)) && !o.toString().equalsIgnoreCase(v)) continue;
            return o;
        }
        throw new ArgumentException(null);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setDefaultValue(T defaultValue) {
        super.setDefaultValue(defaultValue.toString());
    }

    @Override
    public boolean valueIsAcceptable(String valueString, LocalizableMessageBuilder invalidReason) {
        for (T o : this.allowedValues) {
            if ((!this.caseSensitive || !o.toString().equals(valueString)) && !o.toString().equalsIgnoreCase(valueString)) continue;
            return true;
        }
        invalidReason.append(CliMessages.ERR_MCARG_VALUE_NOT_ALLOWED.get((Object)this.getName(), (Object)valueString));
        return false;
    }
}

