/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedHashMap;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.util.Utils;

public final class FileBasedArgument
extends Argument {
    private final LinkedHashMap<String, String> namesToValues = new LinkedHashMap();

    public FileBasedArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean isMultiValued, LocalizableMessage valuePlaceholder, String defaultValue, String propertyName, LocalizableMessage description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, isMultiValued, true, valuePlaceholder, defaultValue, propertyName, description);
    }

    public FileBasedArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, LocalizableMessage valuePlaceholder, LocalizableMessage description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, false, true, valuePlaceholder, null, null, description);
    }

    @Override
    public void addValue(String valueString) {
        String actualValue = this.namesToValues.get(valueString);
        if (actualValue != null) {
            super.addValue(actualValue);
        }
    }

    public LinkedHashMap<String, String> getNameToValueMap() {
        return this.namesToValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean valueIsAcceptable(String valueString, LocalizableMessageBuilder invalidReason) {
        String line;
        BufferedReader reader;
        File valueFile;
        try {
            valueFile = new File(valueString);
            if (!valueFile.exists()) {
                invalidReason.append(CliMessages.ERR_FILEARG_NO_SUCH_FILE.get((Object)valueString, (Object)this.getName()));
                return false;
            }
        }
        catch (Exception e) {
            invalidReason.append(CliMessages.ERR_FILEARG_CANNOT_VERIFY_FILE_EXISTENCE.get((Object)valueString, (Object)this.getName(), (Object)StaticUtils.getExceptionMessage((Throwable)e)));
            return false;
        }
        try {
            reader = new BufferedReader(new FileReader(valueFile));
        }
        catch (Exception e) {
            invalidReason.append(CliMessages.ERR_FILEARG_CANNOT_OPEN_FILE.get((Object)valueString, (Object)this.getName(), (Object)StaticUtils.getExceptionMessage((Throwable)e)));
            return false;
        }
        try {
            line = reader.readLine();
        }
        catch (Exception e) {
            boolean bl;
            try {
                invalidReason.append(CliMessages.ERR_FILEARG_CANNOT_READ_FILE.get((Object)valueString, (Object)this.getName(), (Object)StaticUtils.getExceptionMessage((Throwable)e)));
                bl = false;
            }
            catch (Throwable throwable) {
                Utils.closeSilently((Closeable[])new Closeable[]{reader});
                throw throwable;
            }
            Utils.closeSilently((Closeable[])new Closeable[]{reader});
            return bl;
        }
        Utils.closeSilently((Closeable[])new Closeable[]{reader});
        if (line == null) {
            invalidReason.append(CliMessages.ERR_FILEARG_EMPTY_FILE.get((Object)valueString, (Object)this.getName()));
            return false;
        }
        this.namesToValues.put(valueString, line);
        return true;
    }
}

