/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.ApplicationKeyManager;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.AuthenticatedConnectionFactory;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.FileBasedArgument;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.PromptingTrustManager;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.KeyManagers;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LDAPOptions;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.TrustManagers;
import org.forgerock.opendj.ldap.controls.AuthorizationIdentityRequestControl;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.PasswordPolicyRequestControl;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Requests;

public final class ConnectionFactoryProvider {
    static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private StringArgument hostNameArg;
    private IntegerArgument portArg;
    private StringArgument bindNameArg;
    private FileBasedArgument bindPasswordFileArg;
    private char[] password;
    private StringArgument bindPasswordArg;
    private IntegerArgument connectTimeOut;
    private BooleanArgument trustAllArg;
    private StringArgument trustStorePathArg;
    private StringArgument trustStorePasswordArg;
    private FileBasedArgument trustStorePasswordFileArg;
    private StringArgument keyStorePathArg;
    private StringArgument keyStorePasswordArg;
    private FileBasedArgument keyStorePasswordFileArg;
    private StringArgument certNicknameArg;
    private BooleanArgument useSSLArg;
    private BooleanArgument useStartTLSArg;
    private StringArgument saslOptionArg;
    private final BooleanArgument reportAuthzIDArg;
    private final BooleanArgument usePasswordPolicyControlArg;
    private int port = 389;
    private SSLContext sslContext;
    private ConnectionFactory connFactory;
    protected ConnectionFactory authenticatedConnFactory;
    private BindRequest bindRequest;
    private final ConsoleApplication app;
    private boolean isAdminConnection;

    public ConnectionFactoryProvider(ArgumentParser argumentParser, ConsoleApplication app) throws ArgumentException {
        this(argumentParser, app, "", 389, false);
    }

    public ConnectionFactoryProvider(ArgumentParser argumentParser, ConsoleApplication app, String defaultBindDN, int defaultPort, boolean alwaysSSL) throws ArgumentException {
        String defaultHostName;
        this.app = app;
        this.useSSLArg = CommonArguments.getUseSSL();
        if (!alwaysSSL) {
            argumentParser.addLdapConnectionArgument(this.useSSLArg);
        } else {
            this.useSSLArg.setPresent(true);
        }
        this.useStartTLSArg = CommonArguments.getStartTLS();
        if (!alwaysSSL) {
            argumentParser.addLdapConnectionArgument(this.useStartTLSArg);
        }
        try {
            defaultHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            defaultHostName = "Unknown (" + e + ")";
        }
        this.hostNameArg = CommonArguments.getHostName(defaultHostName);
        argumentParser.addLdapConnectionArgument(this.hostNameArg);
        LocalizableMessage portDescription = CliMessages.INFO_DESCRIPTION_PORT.get();
        if (alwaysSSL) {
            portDescription = CliMessages.INFO_DESCRIPTION_ADMIN_PORT.get();
        }
        this.portArg = CommonArguments.getPort(defaultPort, portDescription);
        argumentParser.addLdapConnectionArgument(this.portArg);
        this.bindNameArg = CommonArguments.getBindDN(defaultBindDN);
        argumentParser.addLdapConnectionArgument(this.bindNameArg);
        this.bindPasswordArg = CommonArguments.getBindPassword();
        argumentParser.addLdapConnectionArgument(this.bindPasswordArg);
        this.bindPasswordFileArg = CommonArguments.getBindPasswordFile();
        argumentParser.addLdapConnectionArgument(this.bindPasswordFileArg);
        this.saslOptionArg = CommonArguments.getSASL();
        argumentParser.addLdapConnectionArgument(this.saslOptionArg);
        this.trustAllArg = CommonArguments.getTrustAll();
        argumentParser.addLdapConnectionArgument(this.trustAllArg);
        this.trustStorePathArg = CommonArguments.getTrustStorePath();
        argumentParser.addLdapConnectionArgument(this.trustStorePathArg);
        this.trustStorePasswordArg = CommonArguments.getTrustStorePassword();
        argumentParser.addLdapConnectionArgument(this.trustStorePasswordArg);
        this.trustStorePasswordFileArg = CommonArguments.getTrustStorePasswordFile();
        argumentParser.addLdapConnectionArgument(this.trustStorePasswordFileArg);
        this.keyStorePathArg = CommonArguments.getKeyStorePath();
        argumentParser.addLdapConnectionArgument(this.keyStorePathArg);
        this.keyStorePasswordArg = CommonArguments.getKeyStorePassword();
        argumentParser.addLdapConnectionArgument(this.keyStorePasswordArg);
        this.keyStorePasswordFileArg = CommonArguments.getKeyStorePasswordFile();
        argumentParser.addLdapConnectionArgument(this.keyStorePasswordFileArg);
        this.certNicknameArg = CommonArguments.getCertNickName();
        argumentParser.addLdapConnectionArgument(this.certNicknameArg);
        this.reportAuthzIDArg = CommonArguments.getReportAuthzId();
        argumentParser.addArgument(this.reportAuthzIDArg);
        this.connectTimeOut = CommonArguments.getConnectTimeOut();
        argumentParser.addArgument(this.connectTimeOut);
        this.usePasswordPolicyControlArg = new BooleanArgument("usepwpolicycontrol", null, "usePasswordPolicyControl", CliMessages.INFO_DESCRIPTION_USE_PWP_CONTROL.get());
        this.usePasswordPolicyControlArg.setPropertyName("usePasswordPolicyControl");
        argumentParser.addArgument(this.usePasswordPolicyControlArg);
    }

    public int getConnectTimeout() {
        if (this.connectTimeOut.isPresent()) {
            try {
                return this.connectTimeOut.getIntValue();
            }
            catch (ArgumentException e) {
                return Integer.valueOf(this.connectTimeOut.getDefaultValue());
            }
        }
        return Integer.valueOf(this.connectTimeOut.getDefaultValue());
    }

    public String getHostname() throws ArgumentException {
        String value = "";
        if (this.hostNameArg.isPresent()) {
            value = this.hostNameArg.getValue();
        } else if (this.app.isInteractive()) {
            try {
                value = this.app.readInput(CliMessages.INFO_DESCRIPTION_HOST.get(), this.hostNameArg.getDefaultValue() == null ? value : this.hostNameArg.getDefaultValue());
                this.app.println();
                this.hostNameArg.addValue(value);
                this.hostNameArg.setPresent(true);
            }
            catch (ClientException e) {
                throw new ArgumentException(CliMessages.ERR_ERROR_CANNOT_READ_HOST_NAME.get(), (Throwable)e);
            }
        } else {
            return this.hostNameArg.getDefaultValue() == null ? value : this.hostNameArg.getDefaultValue();
        }
        return Utils.getHostNameForLdapUrl(value);
    }

    public int getPort() {
        if (this.portArg.isPresent()) {
            try {
                return this.portArg.getIntValue();
            }
            catch (ArgumentException e) {
                return Integer.valueOf(this.portArg.getDefaultValue());
            }
        }
        return Integer.valueOf(this.portArg.getDefaultValue());
    }

    public boolean useSSL() {
        return this.useSSLArg.isPresent();
    }

    public boolean useStartTLS() {
        return this.useStartTLSArg.isPresent();
    }

    public ConnectionFactory getConnectionFactory() throws ArgumentException {
        if (this.connFactory == null) {
            this.port = this.portArg.isPresent() ? this.portArg.getIntValue() : 0;
            this.checkForConflictingArguments();
            if (this.app.isInteractive()) {
                if (!this.hostNameArg.isPresent() || this.port == 0 || !this.bindNameArg.isPresent() || !this.bindPasswordArg.isPresent() && !this.bindPasswordFileArg.isPresent()) {
                    this.app.printHeader(CliMessages.INFO_LDAP_CONN_HEADING_CONNECTION_PARAMETERS.get());
                }
                if (!this.hostNameArg.isPresent()) {
                    this.getHostname();
                }
                if (this.port == 0) {
                    LocalizableMessage portMsg = this.isAdminConnection ? CliMessages.INFO_DESCRIPTION_ADMIN_PORT.get() : CliMessages.INFO_DESCRIPTION_PORT.get();
                    this.port = this.app.askPort(portMsg, Integer.valueOf(this.portArg.getDefaultValue()), logger);
                    this.app.println();
                }
                if (!this.bindNameArg.isPresent()) {
                    this.getBindName();
                }
                if (!this.bindPasswordArg.isPresent() && !this.bindPasswordFileArg.isPresent()) {
                    this.getPassword();
                }
            }
            try {
                if (this.useSSLArg.isPresent() || this.useStartTLSArg.isPresent()) {
                    String clientAlias = this.certNicknameArg.isPresent() ? this.certNicknameArg.getValue() : null;
                    if (this.sslContext == null) {
                        TrustManager trustManager = this.getTrustManager();
                        X509KeyManager keyManager = null;
                        X509KeyManager akm = this.getKeyManager(this.keyStorePathArg.getValue());
                        if (akm != null && clientAlias != null) {
                            keyManager = KeyManagers.useSingleCertificate((String)clientAlias, (X509KeyManager)akm);
                        }
                        this.sslContext = new SSLContextBuilder().setTrustManager(trustManager).setKeyManager((KeyManager)keyManager).getSSLContext();
                    }
                }
            }
            catch (Exception e) {
                throw new ArgumentException(CliMessages.ERR_LDAP_CONN_CANNOT_INITIALIZE_SSL.get((Object)e.toString()), (Throwable)e);
            }
            LDAPOptions options = new LDAPOptions();
            if (this.sslContext != null) {
                options.setSSLContext(this.sslContext).setUseStartTLS(this.useStartTLSArg.isPresent());
            }
            options.setConnectTimeout((long)this.getConnectTimeout(), TimeUnit.MILLISECONDS);
            this.connFactory = new LDAPConnectionFactory(this.hostNameArg.getValue(), this.port, options);
        }
        return this.connFactory;
    }

    private void checkForConflictingArguments() throws ArgumentException {
        String value;
        if (this.bindPasswordArg.isPresent() && this.bindPasswordFileArg.isPresent()) {
            LocalizableMessage message = CliMessages.ERR_TOOL_CONFLICTING_ARGS.get((Object)this.bindPasswordArg.getLongIdentifier(), (Object)this.bindPasswordFileArg.getLongIdentifier());
            throw new ArgumentException(message);
        }
        if (this.trustAllArg.isPresent() && this.trustStorePathArg.isPresent()) {
            LocalizableMessage message = CliMessages.ERR_TOOL_CONFLICTING_ARGS.get((Object)this.trustAllArg.getLongIdentifier(), (Object)this.trustStorePathArg.getLongIdentifier());
            throw new ArgumentException(message);
        }
        if (this.trustAllArg.isPresent() && this.trustStorePasswordArg.isPresent()) {
            LocalizableMessage message = CliMessages.ERR_TOOL_CONFLICTING_ARGS.get((Object)this.trustAllArg.getLongIdentifier(), (Object)this.trustStorePasswordArg.getLongIdentifier());
            throw new ArgumentException(message);
        }
        if (this.trustAllArg.isPresent() && this.trustStorePasswordFileArg.isPresent()) {
            LocalizableMessage message = CliMessages.ERR_TOOL_CONFLICTING_ARGS.get((Object)this.trustAllArg.getLongIdentifier(), (Object)this.trustStorePasswordFileArg.getLongIdentifier());
            throw new ArgumentException(message);
        }
        if (this.trustStorePasswordArg.isPresent() && this.trustStorePasswordFileArg.isPresent()) {
            LocalizableMessage message = CliMessages.ERR_TOOL_CONFLICTING_ARGS.get((Object)this.trustStorePasswordArg.getLongIdentifier(), (Object)this.trustStorePasswordFileArg.getLongIdentifier());
            throw new ArgumentException(message);
        }
        if (this.trustStorePathArg.isPresent() && !this.canReadPath(value = this.trustStorePathArg.getValue())) {
            LocalizableMessage message = CliMessages.ERR_CANNOT_READ_TRUSTSTORE.get((Object)value);
            throw new ArgumentException(message);
        }
        if (this.keyStorePathArg.isPresent() && !this.canReadPath(value = this.keyStorePathArg.getValue())) {
            LocalizableMessage message = CliMessages.ERR_CANNOT_READ_KEYSTORE.get((Object)value);
            throw new ArgumentException(message);
        }
        if (this.useStartTLSArg.isPresent() && this.useSSLArg.isPresent()) {
            LocalizableMessage message = CliMessages.ERR_TOOL_CONFLICTING_ARGS.get((Object)this.useStartTLSArg.getLongIdentifier(), (Object)this.useSSLArg.getLongIdentifier());
            throw new ArgumentException(message);
        }
    }

    public ConnectionFactory getAuthenticatedConnectionFactory() throws ArgumentException {
        if (this.authenticatedConnFactory == null) {
            this.authenticatedConnFactory = this.getConnectionFactory();
            BindRequest bindRequest = this.getBindRequest();
            if (bindRequest != null) {
                this.authenticatedConnFactory = new AuthenticatedConnectionFactory(this.authenticatedConnFactory, bindRequest);
            }
        }
        return this.authenticatedConnFactory;
    }

    private boolean canReadPath(String path) {
        File file = new File(path);
        return file.exists() && file.canRead();
    }

    private String getAuthID(String mech) throws ArgumentException {
        String value = null;
        for (String s : this.saslOptionArg.getValues()) {
            if (!s.startsWith("authid")) continue;
            value = this.parseSASLOptionValue(s);
            break;
        }
        if (value == null && this.bindNameArg.isPresent()) {
            value = "dn: " + this.bindNameArg.getValue();
        }
        if (value == null && this.app.isInteractive()) {
            try {
                value = this.app.readInput(LocalizableMessage.raw((CharSequence)"Authentication ID:", (Object[])new Object[0]), this.bindNameArg.getDefaultValue() == null ? null : "dn: " + this.bindNameArg.getDefaultValue());
            }
            catch (ClientException e) {
                throw new ArgumentException(LocalizableMessage.raw((CharSequence)"Unable to read authentication ID", (Object[])new Object[0]), (Throwable)e);
            }
        }
        if (value == null) {
            LocalizableMessage message = CliMessages.ERR_LDAPAUTH_SASL_AUTHID_REQUIRED.get((Object)mech);
            throw new ArgumentException(message);
        }
        return value;
    }

    private String getAuthzID() throws ArgumentException {
        String value = null;
        for (String s : this.saslOptionArg.getValues()) {
            if (!s.startsWith("authzid")) continue;
            value = this.parseSASLOptionValue(s);
            break;
        }
        return value;
    }

    public String getBindName() throws ArgumentException {
        String value = "";
        if (this.bindNameArg.isPresent()) {
            value = this.bindNameArg.getValue();
        } else if (this.app.isInteractive()) {
            LocalizableMessage bindMsg = this.isAdminConnection ? CliMessages.INFO_DESCRIPTION_ADMIN_BINDDN.get() : CliMessages.INFO_DESCRIPTION_BINDDN.get();
            try {
                value = this.app.readInput(bindMsg, this.bindNameArg.getDefaultValue() == null ? value : this.bindNameArg.getDefaultValue());
                this.app.println();
                this.bindNameArg.clearValues();
                this.bindNameArg.addValue(value);
                this.bindNameArg.setPresent(true);
            }
            catch (ClientException e) {
                throw new ArgumentException(CliMessages.ERR_ERROR_CANNOT_READ_BIND_NAME.get(), (Throwable)e);
            }
        }
        return value;
    }

    public BindRequest getBindRequest() throws ArgumentException {
        if (this.bindRequest == null) {
            String mech = null;
            for (String s : this.saslOptionArg.getValues()) {
                if (!s.startsWith("mech")) continue;
                mech = this.parseSASLOptionValue(s);
                break;
            }
            if (mech == null) {
                if (this.bindNameArg.isPresent() || this.bindPasswordFileArg.isPresent() || this.bindPasswordArg.isPresent()) {
                    this.bindRequest = Requests.newSimpleBindRequest((String)this.getBindName(), (char[])this.getPassword());
                }
            } else if ("DIGEST-MD5".equals(mech)) {
                this.bindRequest = Requests.newDigestMD5SASLBindRequest((String)this.getAuthID("DIGEST-MD5"), (char[])this.getPassword()).setAuthorizationID(this.getAuthzID()).setRealm(this.getRealm());
            } else if ("CRAM-MD5".equals(mech)) {
                this.bindRequest = Requests.newCRAMMD5SASLBindRequest((String)this.getAuthID("CRAM-MD5"), (char[])this.getPassword());
            } else if ("GSSAPI".equals(mech)) {
                this.bindRequest = Requests.newGSSAPISASLBindRequest((String)this.getAuthID("GSSAPI"), (char[])this.getPassword()).setKDCAddress(this.getKDC()).setRealm(this.getRealm()).setAuthorizationID(this.getAuthzID());
            } else if ("EXTERNAL".equals(mech)) {
                LocalizableMessage message;
                if (this.sslContext == null) {
                    message = CliMessages.ERR_TOOL_SASLEXTERNAL_NEEDS_SSL_OR_TLS.get();
                    throw new ArgumentException(message);
                }
                if (!this.keyStorePathArg.isPresent() && this.getKeyStore() == null) {
                    message = CliMessages.ERR_TOOL_SASLEXTERNAL_NEEDS_KEYSTORE.get();
                    throw new ArgumentException(message);
                }
                this.bindRequest = Requests.newExternalSASLBindRequest().setAuthorizationID(this.getAuthzID());
            } else if ("PLAIN".equals(mech)) {
                this.bindRequest = Requests.newPlainSASLBindRequest((String)this.getAuthID("PLAIN"), (char[])this.getPassword()).setAuthorizationID(this.getAuthzID());
            } else {
                throw new ArgumentException(CliMessages.ERR_LDAPAUTH_UNSUPPORTED_SASL_MECHANISM.get((Object)mech));
            }
            if (this.reportAuthzIDArg.isPresent()) {
                this.bindRequest.addControl((Control)AuthorizationIdentityRequestControl.newControl((boolean)false));
            }
            if (this.usePasswordPolicyControlArg.isPresent()) {
                this.bindRequest.addControl((Control)PasswordPolicyRequestControl.newControl((boolean)false));
            }
        }
        return this.bindRequest;
    }

    public String toString() {
        return this.connFactory.toString();
    }

    private String getKDC() throws ArgumentException {
        String value = null;
        for (String s : this.saslOptionArg.getValues()) {
            if (!s.startsWith("kdc")) continue;
            value = this.parseSASLOptionValue(s);
            break;
        }
        return value;
    }

    public X509KeyManager getKeyManager(String keyStoreFile) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (keyStoreFile == null) {
            keyStoreFile = this.getKeyStore();
        }
        if (keyStoreFile == null) {
            return null;
        }
        String keyStorePass = this.getKeyStorePIN();
        char[] keyStorePIN = null;
        if (keyStorePass != null) {
            keyStorePIN = keyStorePass.toCharArray();
        }
        FileInputStream fos = new FileInputStream(keyStoreFile);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(fos, keyStorePIN);
        fos.close();
        return new ApplicationKeyManager(keystore, keyStorePIN);
    }

    private String getKeyStore() {
        return System.getProperty("javax.net.ssl.keyStore");
    }

    private String getKeyStorePIN() {
        String pwd = this.keyStorePasswordArg.isPresent() ? this.keyStorePasswordArg.getValue() : (this.keyStorePasswordFileArg.isPresent() ? this.keyStorePasswordFileArg.getValue() : System.getProperty("javax.net.ssl.keyStorePassword"));
        return pwd;
    }

    public char[] getPassword() throws ArgumentException {
        char[] value = "".toCharArray();
        if (this.bindPasswordArg.isPresent()) {
            value = this.bindPasswordArg.getValue().toCharArray();
        } else if (this.bindPasswordFileArg.isPresent()) {
            value = this.bindPasswordFileArg.getValue().toCharArray();
        } else if (this.password != null) {
            return this.password;
        }
        if (value.length == 0 && this.app.isInteractive()) {
            LocalizableMessage msg = this.isAdminConnection ? CliMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get((Object)this.getBindName()) : CliMessages.INFO_DESCRIPTION_BINDPASSWORD.get();
            try {
                value = this.app.readPassword(msg);
                this.app.println();
            }
            catch (ClientException e) {
                throw new ArgumentException(CliMessages.ERR_ERROR_CANNOT_READ_PASSWORD.get(), (Throwable)e);
            }
            this.password = value;
        }
        return value;
    }

    private String getRealm() throws ArgumentException {
        String value = null;
        for (String s : this.saslOptionArg.getValues()) {
            if (!s.startsWith("realm")) continue;
            value = this.parseSASLOptionValue(s);
            break;
        }
        return value;
    }

    public TrustManager getTrustManager() throws IOException, GeneralSecurityException {
        if (this.trustAllArg.isPresent()) {
            return TrustManagers.trustAll();
        }
        X509TrustManager tm = null;
        if (this.trustStorePathArg.isPresent() && this.trustStorePathArg.getValue().length() > 0) {
            tm = TrustManagers.checkValidityDates((X509TrustManager)TrustManagers.checkHostName((String)this.hostNameArg.getValue(), (X509TrustManager)TrustManagers.checkUsingTrustStore((String)this.trustStorePathArg.getValue(), (char[])this.getTrustStorePIN(), null)));
        } else if (this.getTrustStore() != null) {
            tm = TrustManagers.checkValidityDates((X509TrustManager)TrustManagers.checkHostName((String)this.hostNameArg.getValue(), (X509TrustManager)TrustManagers.checkUsingTrustStore((String)this.getTrustStore(), (char[])this.getTrustStorePIN(), null)));
        }
        if (this.app != null && !this.app.isQuiet()) {
            return new PromptingTrustManager(this.app, tm);
        }
        return tm;
    }

    private String getTrustStore() {
        return System.getProperty("javax.net.ssl.trustStore");
    }

    private char[] getTrustStorePIN() {
        String pwd = this.trustStorePasswordArg.isPresent() ? this.trustStorePasswordArg.getValue() : (this.trustStorePasswordFileArg.isPresent() ? this.trustStorePasswordFileArg.getValue() : System.getProperty("javax.net.ssl.trustStorePassword"));
        return pwd == null ? null : pwd.toCharArray();
    }

    private String parseSASLOptionValue(String option) throws ArgumentException {
        int equalPos = option.indexOf(61);
        if (equalPos <= 0) {
            LocalizableMessage message = CliMessages.ERR_LDAP_CONN_CANNOT_PARSE_SASL_OPTION.get((Object)option);
            throw new ArgumentException(message);
        }
        return option.substring(equalPos + 1, option.length());
    }

    public void setIsAnAdminConnection() {
        this.isAdminConnection = true;
    }
}

