/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.opendj.ldap.AbstractConnectionWrapper;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.ResultHandler;

public final class AuthenticatedConnectionFactory
implements ConnectionFactory {
    private final BindRequest request;
    private final ConnectionFactory parentFactory;
    private boolean allowRebinds;

    public AuthenticatedConnectionFactory(ConnectionFactory factory, BindRequest request) {
        Reject.ifNull((Object[])new Object[]{factory, request});
        this.parentFactory = factory;
        this.request = request;
    }

    public void close() {
        this.parentFactory.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws LdapException {
        Connection connection = this.parentFactory.getConnection();
        BindResult bindResult = null;
        try {
            bindResult = connection.bind(this.request);
        }
        finally {
            if (bindResult == null) {
                connection.close();
            }
        }
        return new AuthenticatedConnection(connection, this.request, bindResult);
    }

    public Promise<Connection, LdapException> getConnectionAsync() {
        final AtomicReference connectionHolder = new AtomicReference();
        return this.parentFactory.getConnectionAsync().thenAsync((AsyncFunction)new AsyncFunction<Connection, BindResult, LdapException>(){

            public Promise<BindResult, LdapException> apply(Connection connection) throws LdapException {
                connectionHolder.set(connection);
                return connection.bindAsync(AuthenticatedConnectionFactory.this.request);
            }
        }).then((Function)new Function<BindResult, Connection, LdapException>(){

            public Connection apply(BindResult result) throws LdapException {
                return new AuthenticatedConnection((Connection)connectionHolder.get(), AuthenticatedConnectionFactory.this.request, result);
            }
        }, (Function)new Function<LdapException, Connection, LdapException>(){

            public Connection apply(LdapException errorResult) throws LdapException {
                Utils.closeSilently((Closeable[])new Closeable[]{(Closeable)connectionHolder.get()});
                throw errorResult;
            }
        });
    }

    boolean isRebindAllowed() {
        return this.allowRebinds;
    }

    AuthenticatedConnectionFactory setRebindAllowed(boolean allowRebinds) {
        this.allowRebinds = allowRebinds;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthenticatedConnectionFactory(");
        builder.append(this.parentFactory);
        builder.append(')');
        return builder.toString();
    }

    public static final class AuthenticatedConnection
    extends AbstractConnectionWrapper<Connection> {
        private final BindRequest request;
        private volatile BindResult result;

        private AuthenticatedConnection(Connection connection, BindRequest request, BindResult result) {
            super(connection);
            this.request = request;
            this.result = result;
        }

        public BindResult bind(BindRequest request) throws LdapException {
            throw new UnsupportedOperationException();
        }

        public BindResult bind(String name, char[] password) throws LdapException {
            throw new UnsupportedOperationException();
        }

        public LdapPromise<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            throw new UnsupportedOperationException();
        }

        public BindResult getAuthenticatedBindResult() {
            return this.result;
        }

        public LdapPromise<BindResult> rebindAsync() {
            if (this.request == null) {
                throw new UnsupportedOperationException();
            }
            return this.connection.bindAsync(this.request).thenOnResult((ResultHandler)new ResultHandler<BindResult>(){

                public void handleResult(BindResult result) {
                    AuthenticatedConnection.this.result = result;
                }
            }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                public void handleException(LdapException exception) {
                    AuthenticatedConnection.this.connection.close();
                }
            });
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AuthenticatedConnection(");
            builder.append(this.connection);
            builder.append(')');
            return builder.toString();
        }
    }
}

