/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.servlet;

import java.util.concurrent.CountDownLatch;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.forgerock.json.resource.servlet.HttpUtils;
import org.forgerock.json.resource.servlet.ServletApiVersionAdapter;
import org.forgerock.json.resource.servlet.ServletSynchronizer;

final class Servlet2Adapter
extends ServletApiVersionAdapter {
    Servlet2Adapter() {
    }

    @Override
    public ServletSynchronizer createServletSynchronizer(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        return new Servlet2Synchronizer(httpRequest, httpResponse);
    }

    static final class Servlet2Synchronizer
    implements ServletSynchronizer {
        private final HttpServletRequest httpRequest;
        private final HttpServletResponse httpResponse;
        private final CountDownLatch latch = new CountDownLatch(1);

        Servlet2Synchronizer(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
            this.httpRequest = httpRequest;
            this.httpResponse = httpResponse;
        }

        @Override
        public void addAsyncListener(Runnable runnable) {
        }

        @Override
        public void awaitIfNeeded() throws Exception {
            this.latch.await();
        }

        @Override
        public boolean isAsync() {
            return false;
        }

        @Override
        public void signal() {
            this.latch.countDown();
        }

        @Override
        public void signalAndComplete() {
            this.latch.countDown();
        }

        @Override
        public void signalAndComplete(Throwable t) {
            HttpUtils.fail(this.httpRequest, this.httpResponse, t);
            this.latch.countDown();
        }
    }
}

