/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.servlet;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.RootContext;
import org.forgerock.json.resource.SecurityContext;
import org.forgerock.json.resource.servlet.HttpServletContextFactory;

public final class SecurityContextFactory
implements HttpServletContextFactory {
    @Deprecated
    public static final String ATTRIBUTE_AUTHCID_V1 = "org.forgerock.security.authcid";
    public static final String ATTRIBUTE_AUTHCID_V2 = "org.forgerock.authentication.principal";
    public static final String ATTRIBUTE_AUTHCID = "org.forgerock.authentication.principal";
    @Deprecated
    public static final String ATTRIBUTE_AUTHZID_V1 = "org.forgerock.security.authzid";
    public static final String ATTRIBUTE_AUTHZID_V2 = "org.forgerock.authentication.context";
    public static final String ATTRIBUTE_AUTHZID = "org.forgerock.authentication.context";
    private static final SecurityContextFactory INSTANCE = new SecurityContextFactory();

    public static SecurityContextFactory getHttpServletContextFactory() {
        return INSTANCE;
    }

    private SecurityContextFactory() {
    }

    public SecurityContext createContext(Context parent, HttpServletRequest request) throws ResourceException {
        Map<String, Object> authzid;
        String authcid = this.getAuthenticationIdAttribute("org.forgerock.authentication.principal", request);
        if (authcid == null) {
            authcid = this.getAuthenticationIdAttribute(ATTRIBUTE_AUTHCID_V1, request);
        }
        if ((authzid = this.getAuthorizationIdAttribute("org.forgerock.authentication.context", request)) == null) {
            authzid = this.getAuthorizationIdAttribute(ATTRIBUTE_AUTHZID_V1, request);
        }
        return new SecurityContext(parent, authcid, authzid);
    }

    private String getAuthenticationIdAttribute(String attributeName, HttpServletRequest request) throws InternalServerErrorException {
        try {
            return (String)request.getAttribute(attributeName);
        }
        catch (ClassCastException e) {
            throw new InternalServerErrorException("The security context could not be created because the authentication ID attribute, " + attributeName + ", contained in the HTTP servlet request did " + "not have the correct type", (Throwable)e);
        }
    }

    private Map<String, Object> getAuthorizationIdAttribute(String attributeName, HttpServletRequest request) throws InternalServerErrorException {
        try {
            return (Map)request.getAttribute(attributeName);
        }
        catch (ClassCastException e) {
            throw new InternalServerErrorException("The security context could not be created because the authorization ID attribute, " + attributeName + ", contained in the HTTP servlet request did " + "not have the correct type", (Throwable)e);
        }
    }

    public SecurityContext createContext(HttpServletRequest request) throws ResourceException {
        return this.createContext((Context)new RootContext(), request);
    }
}

