/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.servlet;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.ConnectionFactory;
import org.forgerock.json.resource.MemoryBackend;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.Router;

final class MemoryBackendConnectionFactoryProvider {
    private static final String INIT_PARAM_URI_TEMPLATE = "uri-template";

    private MemoryBackendConnectionFactoryProvider() {
    }

    static ConnectionFactory getConnectionFactory(ServletConfig config) throws ServletException {
        String uriTemplate = config.getInitParameter(INIT_PARAM_URI_TEMPLATE);
        if (uriTemplate == null) {
            throw new ServletException("Servlet initialization parameter 'uri-template' not specified");
        }
        Router router = new Router();
        router.addRoute(uriTemplate, (CollectionResourceProvider)new MemoryBackend());
        return Resources.newInternalConnectionFactory((RequestHandler)router);
    }
}

