/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.servlet;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.ResourceException;

final class HttpUtils {
    static final String CACHE_CONTROL = "no-cache";
    static final String CHARACTER_ENCODING = "UTF-8";
    static final String CONTENT_TYPE = "application/json";
    static final Pattern CONTENT_TYPE_REGEX = Pattern.compile("^application/json([ ]*;[ ]*charset=utf-8)?$", 2);
    static final String CRLF = "\r\n";
    static final String ETAG_ANY = "*";
    static final String HEADER_CACHE_CONTROL = "Cache-Control";
    static final String HEADER_ETAG = "ETag";
    static final String HEADER_IF_MATCH = "If-Match";
    static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    static final String HEADER_LOCATION = "Location";
    static final String HEADER_X_HTTP_METHOD_OVERRIDE = "X-HTTP-Method-Override";
    static final String METHOD_DELETE = "DELETE";
    static final String METHOD_GET = "GET";
    static final String METHOD_HEAD = "HEAD";
    static final String METHOD_OPTIONS = "OPTIONS";
    static final String METHOD_PATCH = "PATCH";
    static final String METHOD_POST = "POST";
    static final String METHOD_PUT = "PUT";
    static final String METHOD_TRACE = "TRACE";
    static final String PARAM_ACTION = HttpUtils.param("action");
    static final String PARAM_DEBUG = "_debug";
    static final String PARAM_FIELDS = HttpUtils.param("fields");
    static final String PARAM_PAGE_SIZE = HttpUtils.param("pageSize");
    static final String PARAM_PAGED_RESULTS_COOKIE = HttpUtils.param("pagedResultsCookie");
    static final String PARAM_PAGED_RESULTS_OFFSET = HttpUtils.param("pagedResultsOffset");
    static final String PARAM_PRETTY_PRINT = "_prettyPrint";
    static final String PARAM_QUERY_EXPRESSION = HttpUtils.param("queryExpression");
    static final String PARAM_QUERY_FILTER = HttpUtils.param("queryFilter");
    static final String PARAM_QUERY_ID = HttpUtils.param("queryId");
    static final String PARAM_SORT_KEYS = HttpUtils.param("sortKeys");
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    static ResourceException adapt(Throwable t) {
        if (t instanceof ResourceException) {
            return (ResourceException)t;
        }
        return new InternalServerErrorException(t);
    }

    static boolean asBooleanValue(String name, String[] values) throws ResourceException {
        String value = HttpUtils.asSingleValue(name, values);
        return Boolean.parseBoolean(value);
    }

    static int asIntValue(String name, String[] values) throws ResourceException {
        String value = HttpUtils.asSingleValue(name, values);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("The value '" + value + "' for parameter '" + name + "' could not be parsed as a valid integer");
        }
    }

    static String asSingleValue(String name, String[] values) throws ResourceException {
        if (values == null || values.length == 0) {
            throw new BadRequestException("No values provided for the request parameter '" + name + "'");
        }
        if (values.length > 1) {
            throw new BadRequestException("Multiple values provided for the single-valued request parameter '" + name + "'");
        }
        return values[0];
    }

    static <T> T checkNotNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    static void closeQuietly(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
    }

    static void fail(HttpServletRequest req, HttpServletResponse resp, Throwable t) {
        if (!resp.isCommitted()) {
            ResourceException re = HttpUtils.adapt(t);
            try {
                resp.reset();
                HttpUtils.prepareResponse(resp);
                resp.setStatus(re.getCode());
                JsonGenerator writer = HttpUtils.getJsonGenerator(req, resp);
                writer.writeObject(re.toJsonValue().getObject());
                HttpUtils.closeQuietly(new Closeable[]{writer, resp.getOutputStream()});
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    static String getIfMatch(HttpServletRequest req) {
        String etag = req.getHeader(HEADER_IF_MATCH);
        if (etag != null) {
            if (etag.length() >= 2) {
                if (etag.charAt(0) == '\"') {
                    return etag.substring(1, etag.length() - 1);
                }
            } else if (etag.equals(ETAG_ANY)) {
                return null;
            }
        }
        return etag;
    }

    static String getIfNoneMatch(HttpServletRequest req) {
        String etag = req.getHeader(HEADER_IF_NONE_MATCH);
        if (etag != null) {
            if (etag.length() >= 2) {
                if (etag.charAt(0) == '\"') {
                    return etag.substring(1, etag.length() - 1);
                }
            } else if (etag.equals(ETAG_ANY)) {
                return ETAG_ANY;
            }
        }
        return etag;
    }

    static JsonValue getJsonContentIfPresent(HttpServletRequest req) throws ResourceException {
        return HttpUtils.getJsonContent0(req, true);
    }

    static JsonValue getJsonContent(HttpServletRequest req) throws ResourceException {
        return HttpUtils.getJsonContent0(req, false);
    }

    static JsonGenerator getJsonGenerator(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JsonGenerator writer = JSON_MAPPER.getJsonFactory().createJsonGenerator((OutputStream)resp.getOutputStream());
        writer.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        String[] values = HttpUtils.getParameter(req, PARAM_PRETTY_PRINT);
        if (values != null) {
            try {
                if (HttpUtils.asBooleanValue(PARAM_PRETTY_PRINT, values)) {
                    writer.useDefaultPrettyPrinter();
                }
            }
            catch (ResourceException e) {
                // empty catch block
            }
        }
        return writer;
    }

    static List<PatchOperation> getJsonPatchContent(HttpServletRequest req) throws ResourceException {
        return PatchOperation.valueOfList((JsonValue)new JsonValue(HttpUtils.parseJsonBody(req, false)));
    }

    static JsonValue getJsonActionContent(HttpServletRequest req) throws ResourceException {
        return new JsonValue(HttpUtils.parseJsonBody(req, true));
    }

    static String getMethod(HttpServletRequest req) {
        String method = req.getMethod();
        if (METHOD_POST.equals(method) && req.getHeader(HEADER_X_HTTP_METHOD_OVERRIDE) != null) {
            method = req.getHeader(HEADER_X_HTTP_METHOD_OVERRIDE);
        }
        return method;
    }

    static String[] getParameter(HttpServletRequest req, String parameter) {
        for (Map.Entry p : req.getParameterMap().entrySet()) {
            if (!((String)p.getKey()).equalsIgnoreCase(parameter)) continue;
            return (String[])p.getValue();
        }
        return null;
    }

    static boolean hasParameter(HttpServletRequest req, String parameter) {
        return HttpUtils.getParameter(req, parameter) != null;
    }

    static boolean isDebugRequested(HttpServletRequest req) throws ResourceException {
        String[] values = req.getParameterValues(PARAM_DEBUG);
        return values != null && HttpUtils.asBooleanValue(PARAM_DEBUG, values);
    }

    static void prepareResponse(HttpServletResponse resp) {
        resp.setContentType(CONTENT_TYPE);
        resp.setCharacterEncoding(CHARACTER_ENCODING);
        resp.setHeader(HEADER_CACHE_CONTROL, CACHE_CONTROL);
    }

    static void rejectIfMatch(HttpServletRequest req) throws ResourceException, PreconditionFailedException {
        if (req.getHeader(HEADER_IF_MATCH) != null) {
            throw new PreconditionFailedException("If-Match not supported for " + HttpUtils.getMethod(req) + " requests");
        }
    }

    static void rejectIfNoneMatch(HttpServletRequest req) throws ResourceException, PreconditionFailedException {
        if (req.getHeader(HEADER_IF_NONE_MATCH) != null) {
            throw new PreconditionFailedException("If-None-Match not supported for " + HttpUtils.getMethod(req) + " requests");
        }
    }

    private static JsonValue getJsonContent0(HttpServletRequest req, boolean allowEmpty) throws ResourceException {
        Object body = HttpUtils.parseJsonBody(req, allowEmpty);
        if (body == null) {
            return new JsonValue(new LinkedHashMap(0));
        }
        if (!(body instanceof Map)) {
            throw new BadRequestException("The request could not be processed because the provided content is not a JSON object");
        }
        return new JsonValue(body);
    }

    /*
     * Exception decompiling
     */
    private static Object parseJsonBody(HttpServletRequest req, boolean allowEmpty) throws BadRequestException, ResourceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String param(String field) {
        return "_" + field;
    }

    private HttpUtils() {
    }
}

