/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

class MediatedFileChannel
extends FileChannel {
    private static final String LOCK_EXTENSION = ".lck";
    final File _file;
    final File _lockFile;
    final String _mode;
    volatile FileChannel _channel;
    volatile FileChannel _lockChannel;

    MediatedFileChannel(String path, String mode) throws IOException {
        this(new File(path), mode);
    }

    MediatedFileChannel(File file, String mode) throws IOException {
        this._file = file;
        this._lockFile = new File(file.getParentFile(), file.getName() + LOCK_EXTENSION);
        this._mode = mode;
        this.openChannel();
    }

    private void handleClosedChannelException(ClosedChannelException cce) throws IOException {
        if (!this.isOpen()) {
            throw cce;
        }
        this.openChannel();
        if (Thread.interrupted()) {
            InterruptedIOException iioe = new InterruptedIOException();
            iioe.initCause(cce);
            throw iioe;
        }
    }

    private synchronized void openChannel() throws IOException {
        if (this.isOpen() && (this._channel == null || !this._channel.isOpen())) {
            this._channel = new RandomAccessFile(this._file, this._mode).getChannel();
        }
    }

    @Override
    public void force(boolean metaData) throws IOException {
        while (true) {
            try {
                this._channel.force(metaData);
            }
            catch (ClosedChannelException e) {
                this.handleClosedChannelException(e);
                continue;
            }
            break;
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer, long position) throws IOException {
        int offset = byteBuffer.position();
        while (true) {
            try {
                return this._channel.read(byteBuffer, position);
            }
            catch (ClosedChannelException e) {
                this.handleClosedChannelException(e);
                byteBuffer.position(offset);
                continue;
            }
            break;
        }
    }

    @Override
    public long size() throws IOException {
        while (true) {
            try {
                return this._channel.size();
            }
            catch (ClosedChannelException e) {
                this.handleClosedChannelException(e);
                continue;
            }
            break;
        }
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        while (true) {
            try {
                return this._channel.truncate(size);
            }
            catch (ClosedChannelException e) {
                this.handleClosedChannelException(e);
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized FileLock tryLock(long position, long size, boolean shared) throws IOException {
        block3: {
            if (this._lockChannel == null) {
                try {
                    this._lockChannel = new RandomAccessFile(this._lockFile, "rw").getChannel();
                }
                catch (IOException ioe) {
                    if (shared) break block3;
                    throw ioe;
                }
            }
        }
        return this._lockChannel.tryLock(position, size, shared);
    }

    @Override
    public int write(ByteBuffer byteBuffer, long position) throws IOException {
        int offset = byteBuffer.position();
        while (true) {
            try {
                return this._channel.write(byteBuffer, position);
            }
            catch (ClosedChannelException e) {
                this.handleClosedChannelException(e);
                byteBuffer.position(offset);
                continue;
            }
            break;
        }
    }

    @Override
    protected synchronized void implCloseChannel() throws IOException {
        try {
            IOException exception = null;
            try {
                if (this._lockChannel != null) {
                    this._lockFile.delete();
                    this._lockChannel.close();
                }
            }
            catch (IOException e) {
                exception = e;
            }
            try {
                if (this._channel != null) {
                    this._channel.close();
                }
            }
            catch (IOException e) {
                exception = e;
            }
            if (exception != null) {
                throw exception;
            }
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode arg0, long arg1, long arg2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileChannel position(long arg0) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long read(ByteBuffer[] arg0, int arg1, int arg2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long transferFrom(ReadableByteChannel arg0, long arg1, long arg2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long transferTo(long arg0, long arg1, WritableByteChannel arg2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long write(ByteBuffer[] arg0, int arg1, int arg2) throws IOException {
        throw new UnsupportedOperationException();
    }

    void injectChannelForTests(FileChannel channel) {
        ((TestChannelInjector)((Object)channel)).setChannel(this._channel);
        this._channel = channel;
    }

    static interface TestChannelInjector {
        public void setChannel(FileChannel var1);
    }
}

