/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Persistit;
import com.persistit.exception.PersistitException;
import com.persistit.util.Util;

abstract class IOTaskRunnable
implements Runnable {
    private static final long THREAD_DEATH_WAIT_INTERVAL = 5000L;
    protected final Persistit _persistit;
    private volatile Thread _thread;
    private boolean _stopped;
    private boolean _notified;
    private long _pollInterval;
    private int _exceptionCount = 0;
    private Exception _lastException;

    protected IOTaskRunnable(Persistit persistit) {
        this._persistit = persistit;
    }

    protected void start(String name, long pollInterval) {
        this._pollInterval = pollInterval;
        this._thread = new Thread((Runnable)this, name);
        this._thread.start();
    }

    Thread getThread() {
        return this._thread;
    }

    synchronized void kick() {
        if (!this._notified) {
            this._notified = true;
            this.notify();
        }
    }

    public final synchronized long getPollInterval() {
        return this._pollInterval;
    }

    public final synchronized void setPollInterval(long pollInterval) {
        this._pollInterval = pollInterval;
        this.kick();
    }

    public final synchronized Exception getLastException() {
        return this._lastException;
    }

    public final synchronized int getExceptionCount() {
        return this._exceptionCount;
    }

    synchronized boolean lastException(Exception exception) {
        ++this._exceptionCount;
        if (this._lastException == null || exception == null || !this._lastException.getClass().equals(exception.getClass())) {
            this._lastException = exception;
            return true;
        }
        return false;
    }

    protected synchronized boolean isStopped() {
        Thread thread = this._thread;
        if (thread == null || !thread.isAlive()) {
            return true;
        }
        return this._stopped;
    }

    protected synchronized void setStopped() {
        this._stopped = true;
    }

    void join(long millis) throws InterruptedException {
        if (this._thread != null) {
            this._thread.join(millis);
        }
    }

    protected void crash() {
        Thread thread = this._thread;
        int count = 0;
        while (thread != null && thread.isAlive()) {
            if (count > 0) {
                this._persistit.getLogBase().crashRetry.log(count, this._thread.getName());
            }
            thread.stop();
            try {
                thread.join(5000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            ++count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            block17: {
                IOTaskRunnable iOTaskRunnable = this;
                synchronized (iOTaskRunnable) {
                    this._notified = false;
                }
                try {
                    if (this.getPollInterval() < 0L) {
                        Util.spinSleep();
                    } else {
                        this.runTask();
                    }
                }
                catch (Exception e) {
                    if (!this.lastException(e)) break block17;
                    this._persistit.getLogBase().exception.log(e);
                }
            }
            long lastCycleTime = System.currentTimeMillis();
            IOTaskRunnable iOTaskRunnable = this;
            synchronized (iOTaskRunnable) {
                if (this.shouldStop()) {
                    this._stopped = true;
                    this.kick();
                    break;
                }
                while (!this.shouldStop()) {
                    long waitTime;
                    long pollInterval = this.pollInterval();
                    if (this._notified && pollInterval >= 0L) break;
                    long l = waitTime = pollInterval < 0L ? 500L : lastCycleTime + pollInterval - System.currentTimeMillis();
                    if (waitTime <= 0L) break;
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException ie) {
                        this._persistit.getLogBase().exception.log(ie);
                        break;
                    }
                }
            }
        }
        try {
            this._persistit.closeSession();
        }
        catch (PersistitException e) {
            this._persistit.getLogBase().exception.log(e);
        }
    }

    static void crash(IOTaskRunnable task) {
        if (task != null) {
            task.crash();
        }
    }

    protected long pollInterval() {
        return this.getPollInterval();
    }

    protected abstract boolean shouldStop();

    protected abstract void runTask() throws Exception;
}

