/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Accumulator;
import com.persistit.IOTaskRunnable;
import com.persistit.Persistit;
import com.persistit.SessionId;
import com.persistit.Transaction;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.mxbeans.CheckpointManagerMXBean;
import com.persistit.util.SequencerConstants;
import com.persistit.util.ThreadSequencer;
import com.persistit.util.Util;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class CheckpointManager
extends IOTaskRunnable
implements CheckpointManagerMXBean {
    private static final Checkpoint UNAVALABLE_CHECKPOINT = new Checkpoint(0L, 0L);
    private final SessionId _checkpointTxnSessionId = new SessionId();
    private volatile long _checkpointIntervalNanos;
    private volatile long _lastCheckpointNanos = Long.MAX_VALUE;
    private static final long SHORT_DELAY = 500L;
    private static final long FLUSH_CHECKPOINT_INTERVAL = 5000L;
    private volatile Checkpoint _currentCheckpoint = new Checkpoint(0L, 0L, true);
    private final List<Checkpoint> _outstandingCheckpoints = new ArrayList<Checkpoint>();
    private final AtomicBoolean _closed = new AtomicBoolean();
    private final AtomicBoolean _fastClose = new AtomicBoolean();

    CheckpointManager(Persistit persistit) {
        super(persistit);
    }

    public void start() {
        this._closed.set(false);
        this._checkpointIntervalNanos = this._persistit.getConfiguration().getCheckpointInterval() * 1000000000L;
        this.start("CHECKPOINT_WRITER", 5000L);
    }

    public void close(boolean flush) throws PersistitException {
        if (flush) {
            this.checkpoint();
        } else {
            this._fastClose.set(true);
        }
        this._closed.set(true);
    }

    Checkpoint getCurrentCheckpoint() {
        return this._currentCheckpoint;
    }

    long getCheckpointIntervalNanos() {
        return this._checkpointIntervalNanos;
    }

    void setCheckpointIntervalNanos(long interval) {
        this._checkpointIntervalNanos = interval;
    }

    @Override
    public String getProposedCheckpoint() {
        return this._currentCheckpoint.toString();
    }

    @Override
    public long getCheckpointInterval() {
        return this._checkpointIntervalNanos / 1000000000L;
    }

    @Override
    public void setCheckpointInterval(long interval) {
        Util.rangeCheck(interval, 10L, 3600L);
        this._checkpointIntervalNanos = interval * 1000000000L;
    }

    @Override
    public synchronized int getOutstandingCheckpointCount() {
        return this._outstandingCheckpoints.size();
    }

    @Override
    public synchronized String outstandingCheckpointReport() {
        StringBuilder sb = new StringBuilder();
        for (Checkpoint cp : this._outstandingCheckpoints) {
            sb.append(cp);
            sb.append(Util.NEW_LINE);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Checkpoint checkpoint() throws PersistitException {
        long timestamp = this.createCheckpoint().getTimestamp();
        this._persistit.flushBuffers(timestamp);
        while (true) {
            this.pollFlushCheckpoint();
            CheckpointManager checkpointManager = this;
            synchronized (checkpointManager) {
                if (this._currentCheckpoint.isCompleted() && this._currentCheckpoint.getTimestamp() >= timestamp) {
                    return this._currentCheckpoint;
                }
            }
            Util.sleep(500L);
        }
    }

    void pollCreateCheckpoint() throws PersistitException {
        long now = System.nanoTime();
        if (this._lastCheckpointNanos + this._checkpointIntervalNanos < now) {
            this._persistit.recordBufferPoolInventory();
            this.createCheckpoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Checkpoint createCheckpoint() throws PersistitException {
        SessionId saveSessionId = this._persistit.getSessionId();
        try {
            this._persistit.setSessionId(this._checkpointTxnSessionId);
            Transaction txn = this._persistit.getTransaction();
            this._lastCheckpointNanos = System.nanoTime();
            txn.beginCheckpoint();
            try {
                this._persistit.flushTransactions(txn.getStartTimestamp());
                ThreadSequencer.sequence(SequencerConstants.ACCUMULATOR_CHECKPOINT_A);
                List<Accumulator> accumulators = this._persistit.takeCheckpointAccumulators(txn.getStartTimestamp());
                this._persistit.getTransactionIndex().checkpointAccumulatorSnapshots(txn.getStartTimestamp(), accumulators);
                Accumulator.saveAccumulatorCheckpointValues(accumulators);
                this._persistit.flushStatistics();
                txn.commit(Transaction.CommitPolicy.HARD);
                this._currentCheckpoint = new Checkpoint(txn.getStartTimestamp(), System.currentTimeMillis());
                this._outstandingCheckpoints.add(this._currentCheckpoint);
                this._persistit.getLogBase().checkpointProposed.log(this._currentCheckpoint);
            }
            catch (InterruptedException ie) {
                throw new PersistitInterruptedException(ie);
            }
            finally {
                txn.end();
            }
            Checkpoint checkpoint = this._currentCheckpoint;
            return checkpoint;
        }
        finally {
            this._persistit.setSessionId(saveSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollFlushCheckpoint() {
        long earliestDirtyTimestamp = this._persistit.earliestDirtyTimestamp();
        Checkpoint checkpoint = null;
        CheckpointManager checkpointManager = this;
        synchronized (checkpointManager) {
            Checkpoint cp;
            while (!this._outstandingCheckpoints.isEmpty() && (cp = this._outstandingCheckpoints.get(0)).getTimestamp() <= earliestDirtyTimestamp) {
                checkpoint = cp;
                this._outstandingCheckpoints.remove(0);
            }
            if (checkpoint != null) {
                try {
                    this._persistit.getJournalManager().writeCheckpointToJournal(checkpoint);
                }
                catch (PersistitException e) {
                    this._persistit.getLogBase().exception.log(e);
                }
            }
        }
    }

    @Override
    protected synchronized boolean shouldStop() {
        return this._closed.get() && (this._currentCheckpoint.isCompleted() || this._fastClose.get());
    }

    @Override
    protected void runTask() throws Exception {
        this.pollCreateCheckpoint();
        this.pollFlushCheckpoint();
    }

    public static class Checkpoint {
        private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        private final long _timestamp;
        private final long _systemTime;
        private volatile boolean _completed = false;

        Checkpoint(long timestamp, long systemTime) {
            this._timestamp = timestamp;
            this._systemTime = systemTime;
        }

        Checkpoint(long timestamp, long systemTime, boolean completed) {
            this(timestamp, systemTime);
            this._completed = completed;
        }

        public long getTimestamp() {
            return this._timestamp;
        }

        public long getSystemTimeMillis() {
            return this._systemTime;
        }

        void completed() {
            this._completed = true;
        }

        public boolean isCompleted() {
            return this._completed;
        }

        public String toString() {
            return String.format("Checkpoint %,d%s @ %s", this._timestamp, this.isCompleted() ? "c" : "u", SDF.format(new Date(this._systemTime)));
        }

        public boolean equals(Object object) {
            if (!(object instanceof Checkpoint)) {
                return false;
            }
            Checkpoint cp = (Checkpoint)object;
            return cp._systemTime == this._systemTime && cp._timestamp == this._timestamp;
        }
    }
}

