/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.StaticGroupImplementationCfgClient;
import org.forgerock.opendj.server.config.meta.GroupImplementationCfgDefn;
import org.forgerock.opendj.server.config.server.GroupImplementationCfg;
import org.forgerock.opendj.server.config.server.StaticGroupImplementationCfg;

public final class StaticGroupImplementationCfgDefn
extends ManagedObjectDefinition<StaticGroupImplementationCfgClient, StaticGroupImplementationCfg> {
    private static final StaticGroupImplementationCfgDefn INSTANCE = new StaticGroupImplementationCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static StaticGroupImplementationCfgDefn getInstance() {
        return INSTANCE;
    }

    private StaticGroupImplementationCfgDefn() {
        super("static-group-implementation", GroupImplementationCfgDefn.getInstance());
    }

    @Override
    public StaticGroupImplementationCfgClient createClientConfiguration(ManagedObject<? extends StaticGroupImplementationCfgClient> impl) {
        return new StaticGroupImplementationCfgClientImpl(impl);
    }

    @Override
    public StaticGroupImplementationCfg createServerConfiguration(ServerManagedObject<? extends StaticGroupImplementationCfg> impl) {
        return new StaticGroupImplementationCfgServerImpl(impl);
    }

    @Override
    public Class<StaticGroupImplementationCfg> getServerConfigurationClass() {
        return StaticGroupImplementationCfg.class;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return GroupImplementationCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        ClassPropertyDefinition.Builder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.StaticGroup");
        builder.setDefaultBehaviorProvider(provider);
        builder.addInstanceOf("org.opends.server.api.Group");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class StaticGroupImplementationCfgServerImpl
    implements StaticGroupImplementationCfg {
        private ServerManagedObject<? extends StaticGroupImplementationCfg> impl;
        private final boolean pEnabled;
        private final String pJavaClass;

        private StaticGroupImplementationCfgServerImpl(ServerManagedObject<? extends StaticGroupImplementationCfg> impl) {
            this.impl = impl;
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addStaticChangeListener(ConfigurationChangeListener<StaticGroupImplementationCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeStaticChangeListener(ConfigurationChangeListener<StaticGroupImplementationCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<GroupImplementationCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<GroupImplementationCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends StaticGroupImplementationCfg> configurationClass() {
            return StaticGroupImplementationCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class StaticGroupImplementationCfgClientImpl
    implements StaticGroupImplementationCfgClient {
        private ManagedObject<? extends StaticGroupImplementationCfgClient> impl;

        private StaticGroupImplementationCfgClientImpl(ManagedObject<? extends StaticGroupImplementationCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends StaticGroupImplementationCfgClient, ? extends StaticGroupImplementationCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }
    }
}

